/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SetBeaconOverflowMessage {
    private final BlockPos pos;
    private final boolean overflowDelete;

    public SetBeaconOverflowMessage(BlockPos pos, boolean overflowDelete) {
        this.pos = pos;
        this.overflowDelete = overflowDelete;
    }

    public static void encode(SetBeaconOverflowMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeBoolean(message.overflowDelete);
    }

    public static SetBeaconOverflowMessage decode(FriendlyByteBuf buf) {
        return new SetBeaconOverflowMessage(buf.m_130135_(), buf.readBoolean());
    }

    public static void handle(SetBeaconOverflowMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                Level world = sender.m_9236_();
                if (world.m_46749_(message.pos) && (te = world.m_7702_(message.pos)) instanceof TileEntityMaidBeacon) {
                    ((TileEntityMaidBeacon)te).setOverflowDelete(message.overflowDelete);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

