/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.block.ModelSwitcherGui;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class OpenSwitcherGuiMessage {
    private final BlockPos pos;

    public OpenSwitcherGuiMessage(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(OpenSwitcherGuiMessage message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
    }

    public static OpenSwitcherGuiMessage decode(FriendlyByteBuf buf) {
        return new OpenSwitcherGuiMessage(buf.m_130135_());
    }

    public static void handle(OpenSwitcherGuiMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> OpenSwitcherGuiMessage.handleOpenGui(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOpenGui(OpenSwitcherGuiMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        BlockEntity te = mc.f_91073_.m_7702_(message.pos);
        if (mc.f_91074_ != null && mc.f_91074_.m_6084_() && te instanceof TileEntityModelSwitcher) {
            mc.m_91152_((Screen)new ModelSwitcherGui((TileEntityModelSwitcher)te));
        }
    }
}

