/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.FoxScrollScreen;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class FoxScrollMessage {
    private final Map<String, List<FoxScrollData>> data;

    public FoxScrollMessage(Map<String, List<FoxScrollData>> data) {
        this.data = data;
    }

    public static void encode(FoxScrollMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.data.size());
        message.data.forEach((dim, scrollData) -> {
            buf.m_130130_(scrollData.size());
            buf.m_130070_(dim);
            scrollData.forEach(data -> FoxScrollData.encode(data, buf));
        });
    }

    public static FoxScrollMessage decode(FriendlyByteBuf buf) {
        HashMap data = Maps.newHashMap();
        int dimLength = buf.m_130242_();
        for (int i = 0; i < dimLength; ++i) {
            ArrayList scrollData = Lists.newArrayList();
            int dataLength = buf.m_130242_();
            String dim = buf.m_130277_();
            for (int j = 0; j < dataLength; ++j) {
                scrollData.add(FoxScrollData.decode(buf));
            }
            data.put(dim, scrollData);
        }
        return new FoxScrollMessage(data);
    }

    public static void handle(FoxScrollMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> FoxScrollMessage.onHandle(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(FoxScrollMessage message) {
        Minecraft.m_91087_().m_91152_((Screen)new FoxScrollScreen(message.data));
    }

    public static class FoxScrollData {
        private final BlockPos pos;
        private final Component name;
        private final long timestamp;

        public FoxScrollData(BlockPos pos, Component name, long timestamp) {
            this.pos = pos;
            this.name = name;
            this.timestamp = timestamp;
        }

        public static void encode(FoxScrollData data, FriendlyByteBuf buf) {
            buf.m_130064_(data.pos);
            buf.m_130083_(data.name);
            buf.writeLong(data.timestamp);
        }

        public static FoxScrollData decode(FriendlyByteBuf buf) {
            return new FoxScrollData(buf.m_130135_(), buf.m_130238_(), buf.readLong());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Component getName() {
            return this.name;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

