/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class PersistentEntitySectionManagerMixin {
    @Final
    @Shadow
    private LongSet f_157499_;
    @Final
    @Shadow
    private Long2ObjectMap<Visibility> f_157497_;
    @Final
    @Shadow
    EntitySectionStorage<EntityAccess> f_157495_;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;processUnloads()V")}, method={"tick"})
    private void companionTick(CallbackInfo ci) {
        this.f_157499_.forEach(l -> {
            if (this.f_157497_.get(l) != Visibility.HIDDEN || !this.m_157507_(l)) {
                return;
            }
            List<EntityAccess> entities = this.f_157495_.m_156888_(l).flatMap(EntitySection::m_156845_).toList();
            PersistentEntitySectionManagerMixin.handleChunkPreUnload(entities);
        });
    }

    @Unique
    private static void handleChunkPreUnload(List<EntityAccess> entities) {
        for (EntityAccess entityAccess : entities) {
            MaidWorldData data;
            Player owner;
            EntityMaid maid;
            LivingEntity livingEntity;
            if (!(entityAccess instanceof EntityMaid) || !((livingEntity = (maid = (EntityMaid)entityAccess).m_269323_()) instanceof Player) || (owner = (Player)livingEntity).m_9236_() != maid.m_9236_() || !PersistentEntitySectionManagerMixin.shouldFollowOwner((LivingEntity)owner, maid) || !maid.teleportToOwner((LivingEntity)owner) || (data = MaidWorldData.get(maid.f_19853_)) == null) continue;
            data.removeInfo(maid);
        }
    }

    @Unique
    private static boolean shouldFollowOwner(LivingEntity owner, EntityMaid maid) {
        if (owner == null || owner.m_21224_() || owner.m_5833_()) {
            return false;
        }
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    @Shadow
    public abstract boolean m_157507_(long var1);
}

