/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class TaskAttack
implements IAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "attack");
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_42388_.m_7968_();
    }

    @Override
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_ATTACK.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasAssaultWeapon, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl moveToTargetTask = SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)0.6f);
        OneShot attackTargetTask = MeleeAttack.m_257733_((int)20);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::hasAssaultWeapon, IAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.hasAssaultWeapon(maid) || this.farAway((LivingEntity)target, maid));
        OneShot attackTargetTask = MeleeAttack.m_257733_((int)20);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return maid.m_21206_().m_150930_((Item)InitItems.EXTINGUISHER.get()) && target.m_5825_();
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, Entity target) {
        Level world = maid.f_19853_;
        AABB aabb = target.m_20191_().m_82377_(1.5, 1.0, 1.5);
        List extinguishingAgents = world.m_6443_(EntityExtinguishingAgent.class, aabb, Entity::m_6084_);
        if (extinguishingAgents.isEmpty()) {
            world.m_7967_((Entity)new EntityExtinguishingAgent(world, target.m_20182_()));
            maid.m_21206_().m_41622_(1, (LivingEntity)maid, m -> m.m_21190_(InteractionHand.OFF_HAND));
            return true;
        }
        return false;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"assault_weapon", this::hasAssaultWeapon), Pair.of((Object)"extinguisher", this::hasExtinguisher)});
    }

    @Override
    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return stack.m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_);
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return this.isWeapon(maid, maid.m_21205_());
    }

    private boolean hasExtinguisher(EntityMaid maid) {
        return maid.m_21206_().m_150930_((Item)InitItems.EXTINGUISHER.get());
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > 8.0f;
    }
}

