/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.TextChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TextChatBubbleData
implements IChatBubbleData {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "text");
    private final int existTick;
    private final ResourceLocation bg;
    private final int priority;
    private Component text;
    @OnlyIn(value=Dist.CLIENT)
    private IChatBubbleRenderer renderer;

    private TextChatBubbleData(int existTick, Component text, ResourceLocation bg, int priority) {
        this.existTick = existTick;
        this.text = text;
        this.bg = bg;
        this.priority = priority;
    }

    private TextChatBubbleData(int existTick, Component text, ResourceLocation bg) {
        this(existTick, text, bg, 0);
    }

    public static TextChatBubbleData type1(Component text) {
        return new TextChatBubbleData(300, text, TYPE_1);
    }

    public static TextChatBubbleData type2(Component text) {
        return new TextChatBubbleData(300, text, TYPE_2);
    }

    public static TextChatBubbleData create(int existTick, Component text, ResourceLocation bg, int priority) {
        return new TextChatBubbleData(existTick, text, bg, priority);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public void setText(Component text) {
        this.text = text;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new TextChatBubbleRenderer(this.text, this.bg, position);
        }
        return this.renderer;
    }

    public static class TextChatSerializer
    implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(FriendlyByteBuf buf) {
            return new TextChatBubbleData(300, buf.m_130238_(), buf.m_130281_());
        }

        @Override
        public void writeToBuff(FriendlyByteBuf buf, IChatBubbleData data) {
            TextChatBubbleData textChat = (TextChatBubbleData)data;
            buf.m_130083_(textChat.text);
            buf.m_130085_(textChat.bg);
        }
    }
}

