/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.ProgressChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ProgressChatBubbleData
implements IChatBubbleData {
    public static final ResourceLocation ID = new ResourceLocation("touhou_little_maid", "progress");
    private final int existTick;
    private final ResourceLocation bg;
    private final int priority;
    private final Component text;
    private final int barBackgroundColor;
    private final int barForegroundColor;
    private final double progress;
    private final boolean alignCenter;
    @OnlyIn(value=Dist.CLIENT)
    private IChatBubbleRenderer renderer;

    private ProgressChatBubbleData(int existTick, ResourceLocation bg, int priority, Component text, int barBackgroundColor, int barForegroundColor, double progress, boolean alignCenter) {
        this.existTick = existTick;
        this.bg = bg;
        this.priority = priority;
        this.text = text;
        this.barBackgroundColor = barBackgroundColor;
        this.barForegroundColor = barForegroundColor;
        this.progress = progress;
        this.alignCenter = alignCenter;
    }

    public static ProgressChatBubbleData create(int existTick, ResourceLocation bg, int priority, Component text, int barBackgroundColor, int barForegroundColor, double progress, boolean alignCenter) {
        return new ProgressChatBubbleData(existTick, bg, priority, text, barBackgroundColor, barForegroundColor, progress, alignCenter);
    }

    public static ProgressChatBubbleData create(Component text, int barBackgroundColor, int barForegroundColor, double progress, boolean alignCenter) {
        return new ProgressChatBubbleData(300, TYPE_2, 0, text, barBackgroundColor, barForegroundColor, progress, alignCenter);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new ProgressChatBubbleRenderer(this.bg, this.text, this.barBackgroundColor, this.barForegroundColor, this.progress, this.alignCenter);
        }
        return this.renderer;
    }

    public static class ProgressChatSerializer
    implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(FriendlyByteBuf buf) {
            return new ProgressChatBubbleData(300, buf.m_130281_(), 0, buf.m_130238_(), buf.readInt(), buf.readInt(), buf.readDouble(), buf.readBoolean());
        }

        @Override
        public void writeToBuff(FriendlyByteBuf buf, IChatBubbleData data) {
            ProgressChatBubbleData textChat = (ProgressChatBubbleData)data;
            buf.m_130085_(textChat.bg);
            buf.m_130083_(textChat.text);
            buf.writeInt(textChat.barBackgroundColor);
            buf.writeInt(textChat.barForegroundColor);
            buf.writeDouble(textChat.progress);
            buf.writeBoolean(textChat.alignCenter);
        }
    }
}

