/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleDataCollection;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.RandomEmoji;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ImageChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.ProgressChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.WaitingChatBubbleData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;

public class ChatBubbleRegister {
    public static Map<ResourceLocation, IChatBubbleData.ChatSerializer> CODEC_MAP = Maps.newHashMap();
    public static final EntityDataSerializer<ChatBubbleDataCollection> INSTANCE = new EntityDataSerializer<ChatBubbleDataCollection>(){

        public void write(FriendlyByteBuf buf, ChatBubbleDataCollection data) {
            buf.m_130130_(Math.min(5, data.size()));
            int i = 0;
            LongBidirectionalIterator longBidirectionalIterator = data.keySet().iterator();
            while (longBidirectionalIterator.hasNext()) {
                long key = (Long)longBidirectionalIterator.next();
                if (i < 5) {
                    IChatBubbleData bubbleData = data.get(key);
                    buf.writeLong(key);
                    ResourceLocation id = bubbleData.id();
                    buf.m_130085_(id);
                    CODEC_MAP.get(id).writeToBuff(buf, bubbleData);
                }
                ++i;
            }
        }

        public ChatBubbleDataCollection read(FriendlyByteBuf buf) {
            ChatBubbleDataCollection map = new ChatBubbleDataCollection((Long2ObjectSortedMap<IChatBubbleData>)new Long2ObjectAVLTreeMap());
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                long key = buf.readLong();
                ResourceLocation id = buf.m_130281_();
                IChatBubbleData bubbleData = CODEC_MAP.get(id).readFromBuff(buf);
                map.put(key, bubbleData);
            }
            return map;
        }

        public ChatBubbleDataCollection copy(ChatBubbleDataCollection value) {
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            this.write(byteBuf, value);
            return this.read(byteBuf);
        }
    };

    public static void init() {
        ChatBubbleRegister register = new ChatBubbleRegister();
        register.register(TextChatBubbleData.ID, new TextChatBubbleData.TextChatSerializer());
        register.register(ImageChatBubbleData.ID, new ImageChatBubbleData.ImageChatSerializer());
        register.register(WaitingChatBubbleData.ID, new WaitingChatBubbleData.WaitingChatSerializer());
        register.register(ProgressChatBubbleData.ID, new ProgressChatBubbleData.ProgressChatSerializer());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerChatBubble(register);
        }
        CODEC_MAP = ImmutableMap.copyOf(CODEC_MAP);
        RandomEmoji.init();
    }

    public void register(ResourceLocation id, IChatBubbleData.ChatSerializer serializer) {
        if (CODEC_MAP.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate codec id: " + String.valueOf(id));
        }
        CODEC_MAP.put(id, serializer);
    }
}

