/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.IForgeShearable;

public class MaidShearTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private LivingEntity shearableEntity = null;

    public MaidShearTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        ItemStack mainHandItem = maid.m_21205_();
        this.shearableEntity = null;
        if (!(mainHandItem.m_41720_() instanceof ShearsItem)) {
            return;
        }
        this.getEntities(maid).m_186128_(e -> maid.m_21444_(e.m_20183_())).filter(Entity::m_6084_).filter(e -> e instanceof IForgeShearable).filter(e -> ((IForgeShearable)e).isShearable(mainHandItem, maid.m_9236_(), e.m_20183_())).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.shearableEntity = e;
            BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.shearableEntity != null && this.shearableEntity.m_19950_((Entity)maid, 2.0)) {
            RandomSource rand = maid.m_217043_();
            int level = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)mainHandItem);
            List drops = ((IForgeShearable)this.shearableEntity).onSheared(null, mainHandItem, maid.m_9236_(), this.shearableEntity.m_20183_(), level);
            drops.forEach(stack -> {
                ItemEntity itemEntity = this.shearableEntity.m_5552_(stack, 1.0f);
                if (itemEntity != null) {
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                }
            });
            maid.m_6674_(InteractionHand.MAIN_HAND);
            mainHandItem.m_41622_(1, (LivingEntity)maid, entityMaid -> entityMaid.m_21190_(InteractionHand.MAIN_HAND));
            this.shearableEntity = null;
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
    }
}

