/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugTarget;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DefaultTargets;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.VisibleForDebug;

@VisibleForDebug
public class DebugMaidManager {
    public static ConcurrentHashMap<UUID, Set<UUID>> PLAYER_DEBUGGING_MAID = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, Set<UUID>> MAID_DEBUGGING_PLAYER = new ConcurrentHashMap();
    public static List<Function<EntityMaid, List<DebugTarget>>> DEBUG_TARGETS = new ArrayList<Function<EntityMaid, List<DebugTarget>>>();

    public static void init() {
        DEBUG_TARGETS.addAll(DefaultTargets.getDefaultTargets());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            DEBUG_TARGETS.addAll(littleMaid.getMaidDebugTargets());
        }
    }

    public static List<DebugTarget> getDebugTargets(EntityMaid maid) {
        return DEBUG_TARGETS.stream().flatMap(f -> ((List)f.apply(maid)).stream()).toList();
    }

    public static List<ServerPlayer> getDebuggingPlayer(EntityMaid maid) {
        Set<UUID> playerId = MAID_DEBUGGING_PLAYER.get(maid.m_20148_());
        if (playerId == null) {
            return List.of();
        }
        MinecraftServer server = maid.f_19853_.m_7654_();
        if (server == null) {
            return List.of();
        }
        return playerId.stream().map(uuid -> server.m_6846_().m_11259_(uuid)).filter(Objects::nonNull).toList();
    }

    public static List<EntityMaid> getDebuggingMaid(ServerPlayer player) {
        Set<UUID> maidId = PLAYER_DEBUGGING_MAID.get(player.m_20148_());
        if (maidId == null) {
            return List.of();
        }
        return maidId.stream().map(uuid -> player.m_284548_().m_8791_(uuid)).filter(Objects::nonNull).filter(EntityMaid.class::isInstance).map(EntityMaid.class::cast).toList();
    }

    public static void setDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        DebugMaidManager.removeDebuggingMaid(player, maid);
        PLAYER_DEBUGGING_MAID.computeIfAbsent(player.m_20148_(), k -> new HashSet()).add(maid.m_20148_());
        MAID_DEBUGGING_PLAYER.computeIfAbsent(maid.m_20148_(), k -> new HashSet()).add(player.m_20148_());
    }

    public static void removeDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.m_20148_())) {
            PLAYER_DEBUGGING_MAID.get(player.m_20148_()).remove(maid.m_20148_());
        }
        if (MAID_DEBUGGING_PLAYER.containsKey(maid.m_20148_())) {
            MAID_DEBUGGING_PLAYER.get(maid.m_20148_()).remove(player.m_20148_());
        }
    }

    public static void triggerDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.m_20148_()) && PLAYER_DEBUGGING_MAID.get(player.m_20148_()).contains(maid.m_20148_())) {
            DebugMaidManager.removeDebuggingMaid(player, maid);
            player.m_213846_((Component)Component.m_237115_((String)"debug.touhou_little_maid.debug_stick.show_path_finder.disable"));
        } else {
            DebugMaidManager.setDebuggingMaid(player, maid);
            player.m_213846_((Component)Component.m_237115_((String)"debug.touhou_little_maid.debug_stick.show_path_finder.enable"));
        }
    }
}

