/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.loot.AdditionLootModifier;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    private static final ResourceLocation CHEST = new ResourceLocation("chest");
    private static final ResourceLocation FISHING = new ResourceLocation("fishing");

    public GlobalLootModifier(PackOutput output) {
        super(output, "touhou_little_maid");
    }

    public void start() {
        this.addAllChestLootModifier("chest_power_point", LootTableGenerator.CHEST_POWER_POINT);
        this.addChestLootModifier("spawn_bonus_chest", BuiltInLootTables.f_78740_, LootTableGenerator.SPAWN_BONUS);
        this.addChestLootModifier("village_temple", BuiltInLootTables.f_78753_, LootTableGenerator.NORMAL_BAUBLE);
        this.addChestLootModifier("desert_pyramid", BuiltInLootTables.f_78764_, LootTableGenerator.RARE_BAUBLE);
        this.addChestLootModifier("jungle_temple", BuiltInLootTables.f_78686_, LootTableGenerator.RARE_BAUBLE);
        this.addChestLootModifier("woodland_mansion_bauble", BuiltInLootTables.f_78689_, LootTableGenerator.VERY_RARE_BAUBLE);
        this.addChestLootModifier("simple_dungeon", BuiltInLootTables.f_78742_, LootTableGenerator.FURNACE_OR_CRAFTING_TABLE_BACKPACK);
        this.addChestLootModifier("abandoned_mineshaft", BuiltInLootTables.f_78759_, LootTableGenerator.NORMAL_BACKPACK);
        this.addChestLootModifier("nether_bridge", BuiltInLootTables.f_78760_, LootTableGenerator.TANK_BACKPACK);
        this.addChestLootModifier("stronghold_corridor", BuiltInLootTables.f_78763_, LootTableGenerator.ENDER_CHEST_BACKPACK);
        this.addChestLootModifier("stronghold_library", BuiltInLootTables.f_78761_, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("ancient_city", BuiltInLootTables.f_230876_, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("bastion_treasure", BuiltInLootTables.f_78697_, LootTableGenerator.SHRINE_LESS);
        this.addChestLootModifier("end_city_treasure", BuiltInLootTables.f_78741_, LootTableGenerator.SHRINE_MORE);
        this.addChestLootModifier("maid_buried_treasure", BuiltInLootTables.f_78692_, LootTableGenerator.MAID_BURIED_TREASURE);
        this.addChestLootModifier("pillager_outpost_gift", BuiltInLootTables.f_78696_, LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT);
        this.addChestLootModifier("woodland_mansion_gift", BuiltInLootTables.f_78689_, LootTableGenerator.STRUCTURE_SPAWN_MAID_GIFT);
        this.addFishLootModifier("fishing_power_point", BuiltInLootTables.f_78721_, LootTableGenerator.FISHING_POWER_POINT);
    }

    private void addChestLootModifier(String name, @Nullable ResourceLocation lootTableId, ResourceLocation lootTableAdd) {
        LootItemCondition[] conditions = new LootItemCondition[]{};
        this.add(name, (IGlobalLootModifier)new AdditionLootModifier(conditions, CHEST, Optional.ofNullable(lootTableId), lootTableAdd));
    }

    private void addAllChestLootModifier(String name, ResourceLocation lootTableAdd) {
        this.addChestLootModifier(name, null, lootTableAdd);
    }

    private void addFishLootModifier(String name, @Nullable ResourceLocation lootTableId, ResourceLocation lootTableAdd) {
        LootItemCondition[] conditions = new LootItemCondition[]{};
        this.add(name, (IGlobalLootModifier)new AdditionLootModifier(conditions, FISHING, Optional.ofNullable(lootTableId), lootTableAdd));
    }
}

