/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;

public class GunShootTargetTask
extends Behavior<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        Optional memory = owner.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        if (memory.isPresent()) {
            LivingEntity target = (LivingEntity)memory.get();
            return IGun.mainhandHoldGun((LivingEntity)owner) && owner.canSee(target);
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(ServerLevel worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(ServerLevel worldIn, EntityMaid owner, long gameTime) {
        owner.m_6274_().m_21952_(MemoryModuleType.f_26372_).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            owner.m_21563_().m_24946_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = owner.canSee((LivingEntity)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                ItemStack mainHandItem = owner.m_21205_();
                IGun iGun = IGun.getIGunOrNull((ItemStack)mainHandItem);
                if (iGun == null) {
                    this.attackCooldown = 100;
                    return;
                }
                ResourceLocation gunId = iGun.getGunId(mainHandItem);
                TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).ifPresentOrElse(index -> {
                    try {
                        this.performGunAttack(owner, (LivingEntity)target, mainHandItem, iGun, (CommonGunIndex)index);
                    }
                    catch (Exception e) {
                        TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", (Object)owner.m_20148_(), (Object)e);
                        this.attackCooldown = 100;
                    }
                }, () -> {
                    this.attackCooldown = 100;
                });
            }
        });
    }

    public void performGunAttack(EntityMaid shooter, LivingEntity target, ItemStack gunItem, IGun iGun, CommonGunIndex gunIndex) {
        GunData gunData = gunIndex.getGunData();
        double x = target.m_20185_() - shooter.m_20185_();
        double y = target.m_20188_() - shooter.m_20188_();
        double z = target.m_20189_() - shooter.m_20189_();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        float radius = shooter.m_21535_();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)shooter);
        ShootResult result = gunOperator.shoot(() -> Float.valueOf(pitch), () -> Float.valueOf(yaw));
        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            this.attackCooldown = 100;
            return;
        }
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
            return;
        }
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.m_20270_((Entity)target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
                return;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
                return;
            }
        }
        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(() -> ((EntityMaid)shooter).m_21205_());
            this.attackCooldown = Math.round(gunData.getDrawTime() * 20.0f) + 2;
            return;
        }
        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            this.attackCooldown = Math.round(gunData.getBoltActionTime() * 20.0f) + 2;
            return;
        }
        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            this.attackCooldown = Math.round(emptyTime * 20.0f) + 2;
            return;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            this.attackCooldown = 10 + shooter.m_217043_().m_188503_(5);
            return;
        }
        this.attackCooldown = 2;
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        this.stopAim(maid);
    }

    private void stopAim(EntityMaid maid) {
        ItemStack mainHandItem = maid.m_21205_();
        IGun iGun = IGun.getIGunOrNull((ItemStack)mainHandItem);
        if (iGun == null) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((LivingEntity)maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}

