/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.aquaculture.entity;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import com.teammetallurgy.aquaculture.api.fishing.Hook;
import com.teammetallurgy.aquaculture.api.fishing.Hooks;
import com.teammetallurgy.aquaculture.init.AquaItems;
import com.teammetallurgy.aquaculture.init.AquaLootTables;
import com.teammetallurgy.aquaculture.init.AquaSounds;
import com.teammetallurgy.aquaculture.item.AquaFishingRodItem;
import com.teammetallurgy.aquaculture.item.HookItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AquacultureFishingHook
extends MaidFishingHook
implements IEntityAdditionalSpawnData {
    public static final EntityType<AquacultureFishingHook> TYPE = EntityType.Builder.m_20704_(AquacultureFishingHook::new, (MobCategory)MobCategory.MISC).m_20716_().m_20698_().m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(5).m_20712_("aquaculture_fishing_hook");
    private Hook hook = Hooks.EMPTY;
    private ItemStack fishingLine = ItemStack.f_41583_;
    private ItemStack bobber = ItemStack.f_41583_;
    private ItemStack fishingRod = ItemStack.f_41583_;

    public AquacultureFishingHook(EntityType<AquacultureFishingHook> entityType, Level level) {
        super(entityType, level, 0, 0);
    }

    public AquacultureFishingHook(EntityMaid maid, Level world, int luck, int lureSpeed, Vec3 pos, @Nonnull Hook hook, @Nonnull ItemStack fishingLine, @Nonnull ItemStack bobber, @Nonnull ItemStack rod) {
        super(TYPE, world, luck, lureSpeed);
        this.m_5602_((Entity)maid);
        this.m_20219_(pos);
        this.hook = hook;
        this.fishingLine = fishingLine;
        this.bobber = bobber;
        this.fishingRod = rod;
        if (this.hasHook() && hook.getWeight() != null) {
            this.m_20256_(this.m_20184_().m_82559_(hook.getWeight()));
        }
    }

    @Override
    protected float getFluidHeight(FluidState fluidState, BlockPos blockPos) {
        if (this.isLavaHook() && fluidState.m_205070_(FluidTags.f_13132_)) {
            return fluidState.m_76155_((BlockGetter)this.m_9236_(), blockPos);
        }
        return super.getFluidHeight(fluidState, blockPos);
    }

    @Override
    protected void fallTick(FluidState fluidState) {
        if (this.isLavaHook() && !fluidState.m_205070_(FluidTags.f_13132_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.03, 0.0));
        } else {
            super.fallTick(fluidState);
        }
    }

    @Override
    protected void spawnFishingParticle(ServerLevel level, BlockState blockState, double x, double y, double z, float sin, float cos) {
        if (this.isLavaHook() && blockState.m_60819_().m_205070_(FluidTags.f_13132_)) {
            float sinOffset = sin * 0.04f;
            float cosOffset = cos * 0.04f;
            if (this.f_19796_.m_188501_() < 0.15f) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, x, y - 0.1, z, 1, (double)sin, 0.1, (double)cos, 0.0);
            }
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, (double)cosOffset, 0.01, (double)(-sinOffset), 1.0);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0, (double)(-cosOffset), 0.01, (double)sinOffset, 1.0);
        } else {
            super.spawnFishingParticle(level, blockState, x, y, z, sin, cos);
        }
        EntityMaid maidOwner = this.getMaidOwner();
        if (this.hasHook() && this.hook.getCatchSound() != null && maidOwner != null) {
            this.f_19853_.m_5594_(null, maidOwner.m_20183_(), this.hook.getCatchSound(), this.m_5720_(), 0.1f, 0.1f);
        }
    }

    @Override
    protected void spawnNibbleParticle(ServerLevel level) {
        if (level.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_)) {
            super.spawnNibbleParticle(level);
        } else if (level.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13132_)) {
            Vec3 motion = this.m_20184_();
            double boundingBox = this.m_20191_().f_82289_ + 0.5;
            float bbWidth = this.m_20205_();
            this.m_20334_(motion.f_82479_, -0.4f * Mth.m_216267_((RandomSource)this.f_19796_, (float)0.6f, (float)1.0f), motion.f_82481_);
            this.m_5496_((SoundEvent)AquaSounds.BOBBER_LAND_IN_LAVA.get(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, this.m_20185_(), boundingBox, this.m_20189_(), (int)(1.0f + bbWidth * 20.0f), (double)bbWidth, 0.0, (double)bbWidth, 0.2);
        }
    }

    @Override
    protected void addExtraLoot(List<ItemStack> randomItems) {
        if (randomItems.isEmpty()) {
            if (this.f_19853_.m_46472_() == Level.f_46430_) {
                randomItems.add(new ItemStack((ItemLike)AquaItems.FISH_BONES.get()));
            } else if (!this.f_19853_.m_46859_(this.m_20183_()) && this.f_19853_.m_6425_(this.m_20183_()).m_76170_()) {
                randomItems.add(new ItemStack((ItemLike)Items.f_42526_));
            }
        }
    }

    @Override
    @NotNull
    protected List<ItemStack> getLoot(MinecraftServer server, LootParams lootParams) {
        List<ItemStack> loot = this.getAquaLoot(server, lootParams);
        if (this.hasHook() && this.hook.getDoubleCatchChance() > 0.0 && this.f_19796_.m_188500_() <= this.hook.getDoubleCatchChance()) {
            List<ItemStack> doubleLoot = this.getAquaLoot(server, lootParams);
            loot.addAll(doubleLoot);
        }
        return loot;
    }

    private List<ItemStack> getAquaLoot(MinecraftServer server, LootParams lootParams) {
        ResourceLocation lootTableLocation = this.isLavaHook() && this.f_19853_.m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13132_) ? (this.f_19853_.m_6042_().f_63856_() ? AquaLootTables.NETHER_FISHING : AquaLootTables.LAVA_FISHING) : BuiltInLootTables.f_78720_;
        LootTable lootTable = server.m_278653_().m_278676_(lootTableLocation);
        return lootTable.m_287195_(lootParams);
    }

    @Override
    protected void afterFishing() {
        super.afterFishing();
        ItemStackHandler rodHandler = AquaFishingRodItem.getHandler((ItemStack)this.fishingRod);
        ItemStack bait = rodHandler.getStackInSlot(1);
        if (!bait.m_41619_()) {
            if (bait.m_220157_(1, this.f_19853_.f_46441_, null)) {
                bait.m_41774_(1);
                this.m_5496_((SoundEvent)AquaSounds.BOBBER_BAIT_BREAK.get(), 0.7f, 0.2f);
            }
            rodHandler.setStackInSlot(1, bait);
        }
    }

    @Override
    protected void hurtRod(EntityMaid maid, ItemStack rodItem, int rodDamage) {
        int currentDamage = rodItem.m_41776_() - rodItem.m_41773_();
        if (rodDamage >= currentDamage) {
            rodDamage = currentDamage;
        }
        if (this.hook != Hooks.EMPTY && this.hook.getDurabilityChance() > 0.0) {
            if (this.f_19853_.f_46441_.m_188500_() >= this.hook.getDurabilityChance()) {
                rodItem.m_220157_(rodDamage, this.f_19853_.f_46441_, null);
            }
        } else {
            rodItem.m_220157_(rodDamage, this.f_19853_.f_46441_, null);
        }
    }

    protected boolean isLavaHook() {
        return this.hasHook() && this.hook.getFluids().contains(FluidTags.f_13132_);
    }

    public boolean hasHook() {
        return this.hook != Hooks.EMPTY;
    }

    public Hook getHook() {
        return this.hook;
    }

    @Nonnull
    public ItemStack getBobber() {
        return this.bobber;
    }

    public boolean hasBobber() {
        return !this.getBobber().m_41619_();
    }

    @Nonnull
    public ItemStack getFishingLine() {
        return this.fishingLine;
    }

    public void m_20093_() {
        if (!this.isLavaHook()) {
            super.m_20093_();
        }
    }

    public boolean m_6051_() {
        return this.hasHook() && !this.hook.getFluids().contains(FluidTags.f_13132_) && super.m_6051_();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.m_19749_();
        buffer.m_130130_(owner == null ? this.m_19879_() : owner.m_19879_());
        buffer.m_130070_(this.hook.getName() == null ? "" : this.hook.getName());
        buffer.m_130055_(this.fishingLine);
        buffer.m_130055_(this.bobber);
        buffer.m_130055_(this.fishingRod);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.f_19853_.m_6815_(buffer.m_130242_());
        this.m_5602_(owner);
        String hookName = buffer.m_130277_();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{hookName})) {
            Item hookItem = (Item)((RegistryObject)Hook.HOOKS.get(hookName)).get();
            this.hook = ((HookItem)hookItem).getHookType();
        }
        this.fishingLine = buffer.m_130267_();
        this.bobber = buffer.m_130267_();
        this.fishingRod = buffer.m_130267_();
    }

    @Override
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

