/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Mob;

public class EasterEggModel
extends BedrockModel<Mob> {
    private static final ResourceLocation MODEL = new ResourceLocation("touhou_little_maid", "models/bedrock/entity/easter_egg_model.json");
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/bedrock/entity/easter_egg_model.png");
    private static EasterEggModel INSTANCE;
    private static MaidModelInfo INFO;

    public EasterEggModel() {
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        try (InputStream stream = manager.m_215595_(MODEL);){
            this.loadLegacyModel((BedrockModelPOJO)CustomPackLoader.GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class));
        }
        catch (IOException exception) {
            TouhouLittleMaid.LOGGER.error("Failed to load easter egg model", (Throwable)exception);
        }
        this.modelMap.forEach((key, model) -> this.modelMapWrapper.put(key, new ModelRendererWrapper((BedrockPart)model)));
    }

    public static EasterEggModel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EasterEggModel();
        }
        return INSTANCE;
    }

    public static MaidModelInfo getInfo() {
        if (INFO == null) {
            INFO = new MaidModelInfo(){

                @Override
                public ResourceLocation getTexture() {
                    return TEXTURE;
                }
            };
        }
        return INFO;
    }
}

