/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class HistoryChatWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("touhou_little_maid", "textures/gui/maid_history_chat.png");
    private static final long TICKS_PER_DAY = 24000L;
    private static final long TICKS_PER_HOUR = 1000L;
    private final boolean isLeft;
    private final ResourceLocation playerSkin;
    private final Component time;

    public HistoryChatWidget(int pX, int pY, int width, int height, Component message, ResourceLocation playerSkin, long gameTime, boolean isLeft) {
        super(pX, pY, width, height, message);
        this.isLeft = isLeft;
        this.playerSkin = playerSkin;
        this.time = this.convertGameTime(gameTime);
    }

    private Component convertGameTime(long inputGameTime) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Component.m_237119_();
        }
        long currentGameTime = level.m_46467_();
        long diff = currentGameTime - inputGameTime;
        if (diff < 0L) {
            return Component.m_237119_();
        }
        long days = diff / 24000L;
        long hours = (diff %= 24000L) / 1000L;
        if (days > 0L) {
            return Component.m_237110_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.days", (Object[])new Object[]{days});
        }
        if (hours > 0L) {
            return Component.m_237110_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.hours", (Object[])new Object[]{hours});
        }
        return Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.just_now");
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        this.drawBackground(graphics);
        this.drawAvatar(graphics);
        this.renderString(graphics, Minecraft.m_91087_().f_91062_);
    }

    private void drawAvatar(GuiGraphics graphics) {
        int xOffset;
        int size = 16;
        int offset = 6;
        int n = xOffset = this.isLeft ? -size - offset : this.m_5711_() + offset;
        if (this.isLeft) {
            graphics.m_280218_(TEXTURE, this.m_252754_() + xOffset, this.getHeightMiddle(size), 0, 32, size, size);
        } else {
            PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)this.playerSkin, (int)(this.m_252754_() + xOffset), (int)this.getHeightMiddle(size), (int)size);
        }
    }

    private void drawBackground(GuiGraphics graphics) {
        int heightMiddle = this.getHeightMiddle(14);
        graphics.m_280027_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 8, 4, 100, 16, 0, this.getTextureY());
        if (this.isLeft) {
            graphics.m_280218_(TEXTURE, this.m_252754_() - 4, heightMiddle, 100, 16, 6, 14);
        } else {
            graphics.m_280218_(TEXTURE, this.m_252754_() + this.m_5711_() - 2, heightMiddle, 100, 0, 6, 14);
        }
    }

    public void renderString(GuiGraphics graphics, Font font) {
        Component message = this.m_6035_();
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.isLeft) {
            graphics.m_280554_(font, (FormattedText)message, this.m_252754_() + 5, this.m_252907_() + 5, this.m_5711_() - 10, 0x555555);
        } else {
            graphics.m_280554_(font, (FormattedText)message, this.m_252754_() + 5, this.m_252907_() + 5, this.m_5711_() - 10, 0xFFFFFF);
        }
        float scale = 0.5f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        if (this.isLeft) {
            graphics.drawString(font, this.time.m_7532_(), (float)(this.m_252754_() + 2) / scale, (float)(this.m_252907_() - 5) / scale, 0x999999, false);
        } else {
            float width = (float)font.m_92852_((FormattedText)this.time) * scale;
            graphics.drawString(font, this.time.m_7532_(), ((float)(this.m_252754_() + this.m_5711_()) - width - 2.0f) / scale, (float)(this.m_252907_() - 5) / scale, 0x999999, false);
        }
        graphics.m_280168_().m_85849_();
    }

    private int getTextureY() {
        return this.isLeft ? 16 : 0;
    }

    private int getHeightMiddle(int height) {
        return this.m_252907_() + (this.m_93694_() - height) / 2;
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }
}

