/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.HistoryChatWidget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ClearMaidAIDataMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiMessage;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.StringUtils;

public class HistoryAIChatScreen
extends Screen {
    private final EntityMaid maid;
    private final ResourceLocation playerSkin;
    private final List<LLMMessage> history = Lists.newArrayList();
    private final List<Renderable> historyWidgets = Lists.newArrayList();
    private double scroll = 0.0;
    private int maxHeight = 0;
    private int posX = 0;

    public HistoryAIChatScreen(EntityMaid maid) {
        super((Component)Component.m_237113_((String)"Maid History AI Chat Screen"));
        this.maid = maid;
        this.playerSkin = this.getPlayerSkin();
        this.transformMessage();
    }

    protected void m_7856_() {
        this.m_169413_();
        this.historyWidgets.clear();
        this.posX = this.f_96543_ / 2 - 75;
        this.maxHeight = 10;
        for (LLMMessage message : this.history) {
            int lineHeight = this.addHistoryWidget(message, this.posX);
            this.maxHeight += lineHeight + 5;
        }
        this.addButtons();
        if (this.maxHeight < this.f_96544_) {
            this.scroll = (double)(this.f_96544_ - this.maxHeight) / 2.0;
        } else {
            double topMax = (double)this.f_96544_ / 2.0 - 100.0;
            double bottomMax = (double)this.f_96544_ / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (this.scroll > topMax) {
                this.scroll = topMax;
            }
            if (bottomMax > scrollBottom) {
                this.scroll = bottomMax - (double)this.maxHeight;
            }
        }
    }

    private void addButtons() {
        MutableComponent clearName = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat");
        MutableComponent clearMsg = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat.confirm");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)clearName, button -> this.getMinecraft().m_91152_((Screen)new ConfirmScreen(yes -> {
            if (yes) {
                this.history.clear();
                this.historyWidgets.clear();
                this.maid.getAiChatManager().getHistory().getDeque().clear();
                NetworkHandler.CHANNEL.sendToServer((Object)new ClearMaidAIDataMessage(this.maid.m_19879_()));
            }
            this.getMinecraft().m_91152_((Screen)this);
        }, (Component)clearName, (Component)clearMsg))).m_252987_(this.posX + 150, this.f_96544_ / 2 - 20, 120, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130660_, button -> {
            OpenMaidGuiMessage message = new OpenMaidGuiMessage(this.maid.m_19879_(), 3);
            NetworkHandler.CHANNEL.sendToServer((Object)message);
        }).m_252987_(this.posX + 150, this.f_96544_ / 2 + 5, 120, 20).m_253136_());
    }

    private int addHistoryWidget(LLMMessage message, int posX) {
        boolean isLeft = message.role() != Role.USER;
        MutableComponent msg = Component.m_237113_((String)message.message());
        int width = Math.min(this.f_96547_.m_92852_((FormattedText)msg), 140) + 10;
        int n = this.f_96547_.m_92923_((FormattedText)msg, 140).size();
        Objects.requireNonNull(this.f_96547_);
        int lineHeight = 10 + n * 9;
        if (isLeft) {
            this.historyWidgets.add((Renderable)new HistoryChatWidget(posX - 100, this.maxHeight, width, lineHeight, (Component)msg, this.playerSkin, message.gameTime(), true));
        } else {
            this.historyWidgets.add((Renderable)new HistoryChatWidget(posX + 100 - width, this.maxHeight, width, lineHeight, (Component)msg, this.playerSkin, message.gameTime(), false));
        }
        return lineHeight;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        MutableComponent title = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.title");
        graphics.m_280653_(this.f_96547_, (Component)title, this.posX + 210, this.f_96544_ / 2 - 35, 0xFFFFFF);
        if (this.historyWidgets.isEmpty()) {
            MutableComponent empty = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat_is_empty");
            List split = this.f_96547_.m_92923_((FormattedText)empty, 150);
            for (int i = 0; i < split.size(); ++i) {
                Objects.requireNonNull(this.f_96547_);
                int height = i * 9;
                graphics.m_280364_(this.f_96547_, (FormattedCharSequence)split.get(i), this.posX, this.f_96544_ / 2 - 10 + height, 0xFF5555);
            }
        } else {
            graphics.m_280588_(this.posX - 128, 5, this.posX + 128, this.f_96544_ - 5);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(0.0, this.scroll, 0.0);
            for (Renderable renderable : this.historyWidgets) {
                renderable.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.m_280168_().m_85849_();
            graphics.m_280618_();
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double delta) {
        if (delta != 0.0) {
            double topMax = (double)this.f_96544_ / 2.0 - 100.0;
            double bottomMax = (double)this.f_96544_ / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (delta < 0.0 && bottomMax < scrollBottom) {
                this.scroll += delta * 15.0;
            }
            if (0.0 < delta && this.scroll < topMax) {
                this.scroll += delta * 15.0;
            }
        }
        return super.m_6050_(pMouseX, pMouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    private void transformMessage() {
        LinkedBlockingDeque<LLMMessage> deque = this.maid.getAiChatManager().getHistory().getDeque();
        deque.descendingIterator().forEachRemaining(message -> {
            if (message.role() == Role.USER) {
                this.history.add((LLMMessage)message);
            } else if (message.role() == Role.ASSISTANT && StringUtils.isNotBlank((CharSequence)message.message())) {
                ResponseChat responseChat = new ResponseChat(message.message());
                this.history.add(new LLMMessage(Role.ASSISTANT, responseChat.getChatText(), message.gameTime(), null, null));
            }
        });
    }

    private ResourceLocation getPlayerSkin() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return DefaultPlayerSkin.m_118627_((UUID)Util.f_137441_);
        }
        return mc.m_91109_().m_240306_(player.m_36316_());
    }
}

