/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class ConditionArmor {
    private static final Pattern ID_PRE_REG = Pattern.compile("^(.+?)\\$(.*?)$");
    private static final Pattern TAG_PRE_REG = Pattern.compile("^(.+?)#(.*?)$");
    private static final String EMPTY = "";
    private final Map<EquipmentSlot, List<ResourceLocation>> idTest = Maps.newHashMap();
    private final Map<EquipmentSlot, List<TagKey<Item>>> tagTest = Maps.newHashMap();

    public void addTest(String name) {
        Matcher matcherId = ID_PRE_REG.matcher(name);
        if (matcherId.find()) {
            EquipmentSlot type = ConditionArmor.getType(matcherId.group(1));
            if (type == null) {
                return;
            }
            String id = matcherId.group(2);
            if (!ResourceLocation.m_135830_((String)id)) {
                return;
            }
            ResourceLocation res = new ResourceLocation(id);
            if (this.idTest.containsKey(type)) {
                this.idTest.get(type).add(res);
            } else {
                this.idTest.put(type, Lists.newArrayList((Object[])new ResourceLocation[]{res}));
            }
            return;
        }
        Matcher matcherTag = TAG_PRE_REG.matcher(name);
        if (matcherTag.find()) {
            EquipmentSlot type = ConditionArmor.getType(matcherTag.group(1));
            if (type == null) {
                return;
            }
            String id = matcherTag.group(2);
            if (!ResourceLocation.m_135830_((String)id)) {
                return;
            }
            ITagManager tags = ForgeRegistries.ITEMS.tags();
            if (tags == null) {
                return;
            }
            TagKey tagKey = tags.createTagKey(new ResourceLocation(id));
            if (this.tagTest.containsKey(type)) {
                this.tagTest.get(type).add((TagKey<Item>)tagKey);
            } else {
                this.tagTest.put(type, Lists.newArrayList((Object[])new TagKey[]{tagKey}));
            }
        }
    }

    public String doTest(IMaid maid, EquipmentSlot slot) {
        ItemStack item = maid.asEntity().m_6844_(slot);
        if (item.m_41619_()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, slot);
        if (result.isEmpty()) {
            return this.doTagTest(maid, slot);
        }
        return result;
    }

    private String doIdTest(IMaid maid, EquipmentSlot slot) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.idTest.containsKey(slot) || this.idTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<ResourceLocation> idListTest = this.idTest.get(slot);
        ItemStack item = maid.asEntity().m_6844_(slot);
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
        if (registryName == null) {
            return EMPTY;
        }
        if (idListTest.contains(registryName)) {
            return slot.m_20751_() + "$" + String.valueOf(registryName);
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, EquipmentSlot slot) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        if (!this.tagTest.containsKey(slot) || this.tagTest.get(slot).isEmpty()) {
            return EMPTY;
        }
        List<TagKey<Item>> tagListTest = this.tagTest.get(slot);
        ItemStack item = maid.asEntity().m_6844_(slot);
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags == null) {
            return EMPTY;
        }
        return tagListTest.stream().filter(arg_0 -> ((ItemStack)item).m_204117_(arg_0)).findFirst().map(itemTagKey -> slot.m_20751_() + "#" + String.valueOf(itemTagKey.f_203868_())).orElse(EMPTY);
    }

    @Nullable
    public static EquipmentSlot getType(String type) {
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            if (!equipmentslot.m_20751_().equals(type)) continue;
            return equipmentslot;
        }
        return null;
    }
}

