/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BlockShrine
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});

    public BlockShrine() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (hand == InteractionHand.MAIN_HAND && (blockEntity = worldIn.m_7702_(pos)) instanceof TileEntityShrine) {
            TileEntityShrine shrine = (TileEntityShrine)blockEntity;
            if (playerIn.m_6144_()) {
                if (!shrine.isEmpty()) {
                    ItemStack storageItem = shrine.extractStorageItem();
                    ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)storageItem);
                    worldIn.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            if (shrine.isEmpty()) {
                if (shrine.canInsert(playerIn.m_21205_())) {
                    shrine.insertStorageItem(ItemHandlerHelper.copyStackWithSize((ItemStack)playerIn.m_21205_(), (int)1));
                    playerIn.m_21205_().m_41774_(1);
                    worldIn.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (!worldIn.f_46443_) {
                    playerIn.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.shrine.not_film"));
                }
                return InteractionResult.PASS;
            }
            if (playerIn.m_21205_().m_41619_()) {
                if (!playerIn.m_7500_()) {
                    if (playerIn.m_21223_() < playerIn.m_21233_() / 2.0f + 1.0f) {
                        if (!worldIn.f_46443_) {
                            playerIn.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.shrine.health_low"));
                        }
                        return InteractionResult.FAIL;
                    }
                    playerIn.m_21153_(0.25f);
                }
                ItemStack film = shrine.getStorageItem();
                ItemFilm.filmToMaid(film, worldIn, pos.m_7494_(), playerIn);
                if (playerIn instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "shrine_reborn_maid");
                }
            }
        }
        return super.m_6227_(state, worldIn, pos, playerIn, hand, hit);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntityShrine shrine;
        ItemStack storageItem;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof TileEntityShrine && !(storageItem = (shrine = (TileEntityShrine)blockEntity).extractStorageItem()).m_41619_()) {
            Block.m_49840_((Level)worldIn, (BlockPos)pos.m_7918_(0, 1, 0), (ItemStack)storageItem);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        return new TileEntityShrine(pos, blockState);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

