/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight;

import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Util;

public class Search {
    private static final int HASH_ALPHA = 1;
    private static final int HASH_BETA = 2;
    private static final int HASH_PV = 3;
    private static final int LIMIT_DEPTH = 64;
    private static final int NULL_DEPTH = 2;
    private static final int RANDOM_MASK = 7;
    private static final int MAX_GEN_MOVES = 128;
    private static final int MATE_VALUE = 10000;
    private static final int BAN_VALUE = 9900;
    private static final int WIN_VALUE = 9800;
    private int hashMask;
    private int mvResult;
    private int allNodes;
    private int allMillis;
    private HashItem[] hashTable;
    Position pos;
    int[] historyTable = new int[4096];
    int[][] mvKiller = new int[64][2];

    public Search(Position pos, int hashLevel) {
        this.pos = pos;
        this.hashMask = (1 << hashLevel) - 1;
        this.hashTable = new HashItem[this.hashMask + 1];
        for (int i = 0; i <= this.hashMask; ++i) {
            this.hashTable[i] = new HashItem();
        }
    }

    private HashItem getHashItem() {
        return this.hashTable[this.pos.zobristKey & this.hashMask];
    }

    private int probeHash(int vlAlpha, int vlBeta, int depth, int[] mv) {
        HashItem hash = this.getHashItem();
        if (hash.zobristLock != this.pos.zobristLock) {
            mv[0] = 0;
            return -10000;
        }
        mv[0] = hash.mv;
        boolean mate = false;
        if (hash.vl > 9800) {
            if (hash.vl <= 9900) {
                return -10000;
            }
            hash.vl = (short)(hash.vl - (short)this.pos.distance);
            mate = true;
        } else if (hash.vl < -9800) {
            if (hash.vl >= -9900) {
                return -10000;
            }
            hash.vl = (short)(hash.vl + (short)this.pos.distance);
            mate = true;
        } else if (hash.vl == this.pos.drawValue()) {
            return -10000;
        }
        if (hash.depth >= depth || mate) {
            if (hash.flag == 2) {
                return hash.vl >= vlBeta ? (int)hash.vl : -10000;
            }
            if (hash.flag == 1) {
                return hash.vl <= vlAlpha ? (int)hash.vl : -10000;
            }
            return hash.vl;
        }
        return -10000;
    }

    private void recordHash(int flag, int vl, int depth, int mv) {
        HashItem hash = this.getHashItem();
        if (hash.depth > depth) {
            return;
        }
        hash.flag = (byte)flag;
        hash.depth = (byte)depth;
        if (vl > 9800) {
            if (mv == 0 && vl <= 9900) {
                return;
            }
            hash.vl = (short)(vl + this.pos.distance);
        } else if (vl < -9800) {
            if (mv == 0 && vl >= -9900) {
                return;
            }
            hash.vl = (short)(vl - this.pos.distance);
        } else {
            if (vl == this.pos.drawValue() && mv == 0) {
                return;
            }
            hash.vl = (short)vl;
        }
        hash.mv = mv;
        hash.zobristLock = this.pos.zobristLock;
    }

    private void setBestMove(int mv, int depth) {
        int n = this.pos.historyIndex(mv);
        this.historyTable[n] = this.historyTable[n] + depth * depth;
        int[] killers = this.mvKiller[this.pos.distance];
        if (killers[0] != mv) {
            killers[1] = killers[0];
            killers[0] = mv;
        }
    }

    private int searchQuiesc(int vlAlpha_, int vlBeta) {
        int genMoves;
        int vlAlpha = vlAlpha_;
        ++this.allNodes;
        int vl = this.pos.mateValue();
        if (vl >= vlBeta) {
            return vl;
        }
        int vlRep = this.pos.repStatus();
        if (vlRep > 0) {
            return this.pos.repValue(vlRep);
        }
        if (this.pos.distance == 64) {
            return this.pos.evaluate();
        }
        int vlBest = -10000;
        int[] mvs = new int[128];
        if (this.pos.inCheck()) {
            genMoves = this.pos.generateAllMoves(mvs);
            vls = new int[128];
            for (i = 0; i < genMoves; ++i) {
                vls[i] = this.historyTable[this.pos.historyIndex(mvs[i])];
            }
            Util.shellSort(mvs, vls, 0, genMoves);
        } else {
            vl = this.pos.evaluate();
            if (vl > vlBest) {
                if (vl >= vlBeta) {
                    return vl;
                }
                vlBest = vl;
                vlAlpha = Math.max(vl, vlAlpha);
            }
            vls = new int[128];
            genMoves = this.pos.generateMoves(mvs, vls);
            Util.shellSort(mvs, vls, 0, genMoves);
            for (i = 0; i < genMoves; ++i) {
                if (vls[i] >= 10 && (vls[i] >= 20 || !Position.HOME_HALF(Position.DST(mvs[i]), this.pos.sdPlayer))) continue;
                genMoves = i;
                break;
            }
        }
        for (int i = 0; i < genMoves; ++i) {
            if (!this.pos.makeMove(mvs[i])) continue;
            vl = -this.searchQuiesc(-vlBeta, -vlAlpha);
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            if (vl >= vlBeta) {
                return vl;
            }
            vlBest = vl;
            vlAlpha = Math.max(vl, vlAlpha);
        }
        return vlBest == -10000 ? this.pos.mateValue() : vlBest;
    }

    private int searchNoNull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, true);
    }

    private int searchFull(int vlAlpha, int vlBeta, int depth) {
        return this.searchFull(vlAlpha, vlBeta, depth, false);
    }

    private int searchFull(int vlAlpha_, int vlBeta, int depth, boolean noNull) {
        int mv;
        int vlAlpha = vlAlpha_;
        if (depth <= 0) {
            return this.searchQuiesc(vlAlpha, vlBeta);
        }
        ++this.allNodes;
        int vl = this.pos.mateValue();
        if (vl >= vlBeta) {
            return vl;
        }
        int vlRep = this.pos.repStatus();
        if (vlRep > 0) {
            return this.pos.repValue(vlRep);
        }
        int[] mvHash = new int[1];
        vl = this.probeHash(vlAlpha, vlBeta, depth, mvHash);
        if (vl > -10000) {
            return vl;
        }
        if (this.pos.distance == 64) {
            return this.pos.evaluate();
        }
        if (!noNull && !this.pos.inCheck() && this.pos.nullOkay()) {
            this.pos.nullMove();
            vl = -this.searchNoNull(-vlBeta, 1 - vlBeta, depth - 2 - 1);
            this.pos.undoNullMove();
            if (vl >= vlBeta && (this.pos.nullSafe() || this.searchNoNull(vlAlpha, vlBeta, depth - 2) >= vlBeta)) {
                return vl;
            }
        }
        int hashFlag = 1;
        int vlBest = -10000;
        int mvBest = 0;
        SortItem sort = new SortItem(mvHash[0]);
        while ((mv = sort.next()) > 0) {
            int newDepth;
            if (!this.pos.makeMove(mv)) continue;
            int n = newDepth = this.pos.inCheck() || sort.singleReply ? depth : depth - 1;
            if (vlBest == -10000) {
                vl = -this.searchFull(-vlBeta, -vlAlpha, newDepth);
            } else {
                vl = -this.searchFull(-vlAlpha - 1, -vlAlpha, newDepth);
                if (vl > vlAlpha && vl < vlBeta) {
                    vl = -this.searchFull(-vlBeta, -vlAlpha, newDepth);
                }
            }
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            vlBest = vl;
            if (vl >= vlBeta) {
                hashFlag = 2;
                mvBest = mv;
                break;
            }
            if (vl <= vlAlpha) continue;
            vlAlpha = vl;
            hashFlag = 3;
            mvBest = mv;
        }
        if (vlBest == -10000) {
            return this.pos.mateValue();
        }
        this.recordHash(hashFlag, vlBest, depth, mvBest);
        if (mvBest > 0) {
            this.setBestMove(mvBest, depth);
        }
        return vlBest;
    }

    private int searchRoot(int depth) {
        int mv;
        int vlBest = -10000;
        SortItem sort = new SortItem(this.mvResult);
        while ((mv = sort.next()) > 0) {
            int vl;
            int newDepth;
            if (!this.pos.makeMove(mv)) continue;
            int n = newDepth = this.pos.inCheck() ? depth : depth - 1;
            if (vlBest == -10000) {
                vl = -this.searchNoNull(-10000, 10000, newDepth);
            } else {
                vl = -this.searchFull(-vlBest - 1, -vlBest, newDepth);
                if (vl > vlBest) {
                    vl = -this.searchNoNull(-10000, -vlBest, newDepth);
                }
            }
            this.pos.undoMakeMove();
            if (vl <= vlBest) continue;
            vlBest = vl;
            this.mvResult = mv;
            if (vlBest <= -9800 || vlBest >= 9800) continue;
            vlBest = (vlBest += (Position.random.nextInt() & 7) - (Position.random.nextInt() & 7)) == this.pos.drawValue() ? vlBest - 1 : vlBest;
        }
        this.setBestMove(this.mvResult, depth);
        return vlBest;
    }

    public boolean searchUnique(int vlBeta, int depth) {
        int mv;
        SortItem sort = new SortItem(this.mvResult);
        sort.next();
        while ((mv = sort.next()) > 0) {
            if (!this.pos.makeMove(mv)) continue;
            int vl = -this.searchFull(-vlBeta, 1 - vlBeta, this.pos.inCheck() ? depth : depth - 1);
            this.pos.undoMakeMove();
            if (vl < vlBeta) continue;
            return false;
        }
        return true;
    }

    public int searchMain(int millis) {
        return this.searchMain(64, millis);
    }

    public int searchMain(int depth, int millis) {
        int i;
        this.mvResult = this.pos.bookMove();
        if (this.mvResult > 0) {
            this.pos.makeMove(this.mvResult);
            if (this.pos.repStatus(3) == 0) {
                this.pos.undoMakeMove();
                return this.mvResult;
            }
            this.pos.undoMakeMove();
        }
        for (i = 0; i <= this.hashMask; ++i) {
            HashItem hash = this.hashTable[i];
            hash.flag = 0;
            hash.depth = 0;
            hash.vl = 0;
            hash.zobristLock = 0;
            hash.mv = 0;
        }
        for (i = 0; i < 64; ++i) {
            this.mvKiller[i][1] = 0;
            this.mvKiller[i][0] = 0;
        }
        for (i = 0; i < 4096; ++i) {
            this.historyTable[i] = 0;
        }
        this.mvResult = 0;
        this.allNodes = 0;
        this.pos.distance = 0;
        long t = System.currentTimeMillis();
        for (int i2 = 1; i2 <= depth; ++i2) {
            int vl = this.searchRoot(i2);
            this.allMillis = (int)(System.currentTimeMillis() - t);
            if (this.allMillis > millis || vl > 9800 || vl < -9800 || this.searchUnique(-9799, i2)) break;
        }
        return this.mvResult;
    }

    public int getKNPS() {
        return this.allNodes / this.allMillis;
    }

    static class HashItem {
        byte depth;
        byte flag;
        short vl;
        int mv;
        int zobristLock;

        HashItem() {
        }
    }

    private class SortItem {
        private static final int PHASE_HASH = 0;
        private static final int PHASE_KILLER_1 = 1;
        private static final int PHASE_KILLER_2 = 2;
        private static final int PHASE_GEN_MOVES = 3;
        private static final int PHASE_REST = 4;
        private int index;
        private int moves;
        private int phase;
        private int mvHash;
        private int mvKiller1;
        private int mvKiller2;
        private int[] mvs;
        private int[] vls;
        boolean singleReply = false;

        SortItem(int mvHash) {
            if (!Search.this.pos.inCheck()) {
                this.phase = 0;
                this.mvHash = mvHash;
                this.mvKiller1 = Search.this.mvKiller[Search.this.pos.distance][0];
                this.mvKiller2 = Search.this.mvKiller[Search.this.pos.distance][1];
                return;
            }
            this.phase = 4;
            this.mvKiller2 = 0;
            this.mvKiller1 = 0;
            this.mvHash = 0;
            this.mvs = new int[128];
            this.vls = new int[128];
            this.moves = 0;
            int[] mvsAll = new int[128];
            int numAll = Search.this.pos.generateAllMoves(mvsAll);
            for (int i = 0; i < numAll; ++i) {
                int mv = mvsAll[i];
                if (!Search.this.pos.makeMove(mv)) continue;
                Search.this.pos.undoMakeMove();
                this.mvs[this.moves] = mv;
                this.vls[this.moves] = mv == mvHash ? Integer.MAX_VALUE : Search.this.historyTable[Search.this.pos.historyIndex(mv)];
                ++this.moves;
            }
            Util.shellSort(this.mvs, this.vls, 0, this.moves);
            this.index = 0;
            this.singleReply = this.moves == 1;
        }

        int next() {
            if (this.phase == 0) {
                this.phase = 1;
                if (this.mvHash > 0) {
                    return this.mvHash;
                }
            }
            if (this.phase == 1) {
                this.phase = 2;
                if (this.mvKiller1 != this.mvHash && this.mvKiller1 > 0 && Search.this.pos.legalMove(this.mvKiller1)) {
                    return this.mvKiller1;
                }
            }
            if (this.phase == 2) {
                this.phase = 3;
                if (this.mvKiller2 != this.mvHash && this.mvKiller2 > 0 && Search.this.pos.legalMove(this.mvKiller2)) {
                    return this.mvKiller2;
                }
            }
            if (this.phase == 3) {
                this.phase = 4;
                this.mvs = new int[128];
                this.vls = new int[128];
                this.moves = Search.this.pos.generateAllMoves(this.mvs);
                for (int i = 0; i < this.moves; ++i) {
                    this.vls[i] = Search.this.historyTable[Search.this.pos.historyIndex(this.mvs[i])];
                }
                Util.shellSort(this.mvs, this.vls, 0, this.moves);
                this.index = 0;
            }
            while (this.index < this.moves) {
                int mv = this.mvs[this.index];
                ++this.index;
                if (mv == this.mvHash || mv == this.mvKiller1 || mv == this.mvKiller2) continue;
                return mv;
            }
            return 0;
        }
    }
}

