/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai;

import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializableSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SupportModelSelect;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.LLMOpenAIClient;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public final class LLMOpenAISite
implements LLMSite,
SupportModelSelect {
    public static final String API_TYPE = LLMApiType.OPENAI.getName();
    private final String id;
    private final ResourceLocation icon;
    private final Map<String, String> headers;
    private final Map<String, String> models;
    private String url;
    private boolean enabled;
    private String secretKey;

    public LLMOpenAISite(String id, ResourceLocation icon, String url, boolean enabled, String secretKey, Map<String, String> headers, Map<String, String> models) {
        this.id = id;
        this.icon = icon;
        this.url = url;
        this.enabled = enabled;
        this.secretKey = secretKey;
        this.headers = headers;
        this.models = models;
    }

    public LLMOpenAISite(String id, ResourceLocation icon, String url, boolean enabled, String secretKey, Map<String, String> headers, List<String> models) {
        this(id, icon, url, enabled, secretKey, headers, models.stream().collect(Collectors.toMap(Function.identity(), Function.identity())));
    }

    @Override
    public String getApiType() {
        return API_TYPE;
    }

    @Override
    public LLMClient client() {
        return new LLMOpenAIClient(LLM_HTTP_CLIENT, this);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ResourceLocation icon() {
        return this.icon;
    }

    @Override
    public String url() {
        return this.url;
    }

    public String secretKey() {
        return this.secretKey;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public Map<String, String> models() {
        return this.models;
    }

    public void addModel(String model) {
        this.addModel(model, model);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public static class Serializer
    implements SerializableSite<LLMOpenAISite> {
        private static final Codec<Map<String, String>> MODELS_CODEC = Codec.list((Codec)Codec.STRING).xmap(list -> list.stream().collect(Collectors.toMap(Function.identity(), Function.identity())), map -> map.keySet().stream().toList());
        public static final Codec<LLMOpenAISite> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(LLMOpenAISite::id), (App)ResourceLocation.f_135803_.fieldOf("icon").forGetter(LLMOpenAISite::icon), (App)Codec.STRING.fieldOf("url").forGetter(LLMOpenAISite::url), (App)Codec.BOOL.fieldOf("enabled").forGetter(LLMOpenAISite::enabled), (App)Codec.STRING.fieldOf("secret_key").forGetter(LLMOpenAISite::secretKey), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("headers").forGetter(LLMOpenAISite::headers), (App)MODELS_CODEC.fieldOf("models").forGetter(LLMOpenAISite::models)).apply((Applicative)instance, LLMOpenAISite::new));

        @Override
        public LLMOpenAISite defaultSite() {
            return new LLMOpenAISite(API_TYPE, SerializableSite.defaultIcon(API_TYPE), "https://api.openai.com/v1/chat/completions", false, "", Map.of(), List.of("gpt-4o", "chatgpt-4o-latest", "gpt-4o-mini", "o1", "o1-mini", "o3-mini", "o1-preview"));
        }

        @Override
        public Codec<LLMOpenAISite> codec() {
            return CODEC;
        }
    }
}

