/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.site;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.ClientAvailableSitesSync;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializerRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.DefaultLLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.google.common.collect.Maps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class AvailableSites {
    private static final String FOLDER_NAME = "sites";
    public static final Map<String, LLMSite> LLM_SITES = Maps.newLinkedHashMap();
    public static final Map<String, TTSSite> TTS_SITES = Maps.newLinkedHashMap();
    public static final Map<String, STTSite> STT_SITES = Maps.newLinkedHashMap();

    public static void init() {
        AvailableSites.clearSites();
        AvailableSites.addDefaultSites();
        AvailableSites.readSites();
        AvailableSites.saveSites();
        ClientAvailableSitesSync.init(LLM_SITES, TTS_SITES);
        SettingReader.reloadSettings();
    }

    private static void clearSites() {
        LLM_SITES.clear();
        TTS_SITES.clear();
        STT_SITES.clear();
    }

    private static void addDefaultSites() {
        SerializerRegister.LLM_SERIALIZER.forEach((key, value) -> LLM_SITES.put((String)key, (LLMSite)value.defaultSite()));
        SerializerRegister.TTS_SERIALIZER.forEach((key, value) -> TTS_SITES.put((String)key, (TTSSite)value.defaultSite()));
        SerializerRegister.STT_SERIALIZER.forEach((key, value) -> STT_SITES.put((String)key, (STTSite)value.defaultSite()));
        DefaultLLMSite.addDefaultSites();
    }

    private static void readSites() {
        Path root = AvailableSites.createFolder();
        Path llmConfig = root.resolve("llm.json");
        Path ttsConfig = root.resolve("tts.json");
        Path sttConfig = root.resolve("stt.json");
        if (Files.exists(llmConfig, new LinkOption[0])) {
            try {
                LLM_SITES.putAll(LLMSite.readSites(llmConfig));
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to read LLM sites", (Throwable)e);
            }
        }
        if (Files.exists(ttsConfig, new LinkOption[0])) {
            try {
                TTS_SITES.putAll(TTSSite.readSites(ttsConfig));
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to read TTS sites", (Throwable)e);
            }
        }
        if (Files.exists(sttConfig, new LinkOption[0])) {
            try {
                STT_SITES.putAll(STTSite.readSites(sttConfig));
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to read STT sites", (Throwable)e);
            }
        }
    }

    public static void saveSites() {
        Path root = AvailableSites.createFolder();
        Path llmConfig = root.resolve("llm.json");
        Path ttsConfig = root.resolve("tts.json");
        Path sttConfig = root.resolve("stt.json");
        try {
            LLMSite.writeSites(llmConfig, LLM_SITES);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to save LLM sites", (Throwable)e);
        }
        try {
            TTSSite.writeSites(ttsConfig, TTS_SITES);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to save TTS sites", (Throwable)e);
        }
        try {
            STTSite.writeSites(sttConfig, STT_SITES);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to save STT sites", (Throwable)e);
        }
    }

    public static LLMSite getLLMSite(String siteName) {
        return LLM_SITES.get(siteName);
    }

    public static TTSSite getTTSSite(String siteName) {
        return TTS_SITES.get(siteName);
    }

    public static STTSite getSTTSite(String siteName) {
        return STT_SITES.get(siteName);
    }

    private static Path createFolder() {
        Path root = FMLPaths.CONFIGDIR.get().resolve("touhou_little_maid").resolve(FOLDER_NAME);
        if (!root.toFile().isDirectory()) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to create sites folder", (Throwable)e);
            }
        }
        return root;
    }
}

