/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.IPaintable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class PaintedBlockEntity
extends BlockEntity {
    public static final ModelProperty<Supplier<BlockState>> FACADE_STATE = new ModelProperty();
    private BlockState blockState;

    public PaintedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.paintedTile.get(), pos, state);
    }

    public PaintedBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public boolean setPaintedBlockState(BlockState blockState) {
        boolean changed;
        BlockState old = this.getPaintedBlockState();
        this.blockState = blockState;
        boolean bl = changed = !this.getPaintedBlockState().equals(old);
        if (changed) {
            this.markDirtyClient();
        }
        return changed;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(FACADE_STATE, this::getPaintedBlockState).build();
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.blockState = IPaintable.readBlockState(this.f_58857_, compound.m_128469_("block"));
        this.markDirtyClient();
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        if (this.blockState != null) {
            compound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        }
    }

    private void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public BlockState getPaintedBlockState() {
        return this.blockState == null ? Blocks.f_50016_.m_49966_() : this.blockState;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        BlockState old = this.getPaintedBlockState();
        super.onDataPacket(net, packet);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            if (!this.getPaintedBlockState().equals(old)) {
                this.f_58857_.m_151543_(this.m_58899_());
            }
            this.requestModelDataUpdate();
        }
    }
}

