/*
 * Decompiled with CFR 0.152.
 */
package andrews.swampier_swamps.objects.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class SwampVineBlock
extends VineBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SwampVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57834_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57835_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57836_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57837_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean isWaterloggableVine = blockstate.m_60713_((Block)this);
        BlockState state = isWaterloggableVine ? blockstate : this.m_49966_();
        for (Direction direction : context.m_6232_()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = SwampVineBlock.m_57883_((Direction)direction);
            boolean bl = flag1 = isWaterloggableVine && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            if (flag1 || !this.m_57887_((BlockGetter)context.m_43725_(), context.m_8083_(), direction)) continue;
            return (BlockState)((BlockState)state.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return isWaterloggableVine ? state : null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{f_57833_, f_57834_, f_57835_, f_57836_, f_57837_, WATERLOGGED});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN) {
            return state;
        }
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)levelAccessor, pos);
        return !this.hasFaces(blockstate) ? Blocks.f_50016_.m_49966_() : blockstate;
    }

    private boolean hasFaces(BlockState state) {
        int faces = 0;
        for (BooleanProperty booleanproperty : f_57838_.values()) {
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            ++faces;
        }
        return faces > 0;
    }

    private BlockState getUpdatedState(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        if (((Boolean)state.m_61143_((Property)f_57833_)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(SwampVineBlock.m_57853_((BlockGetter)getter, (BlockPos)blockpos, (Direction)Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = SwampVineBlock.m_57883_((Direction)direction);
            if (!((Boolean)state.m_61143_((Property)booleanproperty)).booleanValue()) continue;
            boolean canSupport = this.m_57887_(getter, pos, direction);
            if (!canSupport) {
                if (blockstate == null) {
                    blockstate = getter.m_8055_(blockpos);
                }
                canSupport = blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)booleanproperty) != false;
            }
            state = (BlockState)state.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(canSupport));
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (level.f_46441_.m_188503_(4) == 0 && level.isAreaLoaded(pos, 4)) {
            Direction direction = Direction.m_235672_((RandomSource)rand);
            BlockPos blockpos = pos.m_7494_();
            if (direction.m_122434_().m_122479_() && !((Boolean)state.m_61143_((Property)SwampVineBlock.m_57883_((Direction)direction))).booleanValue()) {
                if (this.canSpread((BlockGetter)level, pos)) {
                    BlockPos relativePosInDir = pos.m_121945_(direction);
                    BlockState relativePosState = level.m_8055_(relativePosInDir);
                    if (relativePosState.m_60795_()) {
                        Direction clockWiseDir = direction.m_122427_();
                        Direction counterClockWiseDir = direction.m_122428_();
                        boolean canAttachClockWise = (Boolean)state.m_61143_((Property)SwampVineBlock.m_57883_((Direction)clockWiseDir));
                        boolean canAttachCounterClockWise = (Boolean)state.m_61143_((Property)SwampVineBlock.m_57883_((Direction)counterClockWiseDir));
                        BlockPos posRelativeClockWise = relativePosInDir.m_121945_(clockWiseDir);
                        BlockPos posRelativeCounterClockWise = relativePosInDir.m_121945_(counterClockWiseDir);
                        if (canAttachClockWise && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)posRelativeClockWise, (Direction)clockWiseDir)) {
                            level.m_7731_(relativePosInDir, (BlockState)this.m_49966_().m_61124_((Property)SwampVineBlock.m_57883_((Direction)clockWiseDir), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (canAttachCounterClockWise && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)posRelativeCounterClockWise, (Direction)counterClockWiseDir)) {
                            level.m_7731_(relativePosInDir, (BlockState)this.m_49966_().m_61124_((Property)SwampVineBlock.m_57883_((Direction)counterClockWiseDir), (Comparable)Boolean.valueOf(true)), 2);
                        } else {
                            Direction oppositeDir = direction.m_122424_();
                            if (canAttachClockWise && level.m_46859_(posRelativeClockWise) && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)pos.m_121945_(clockWiseDir), (Direction)oppositeDir)) {
                                level.m_7731_(posRelativeClockWise, (BlockState)this.m_49966_().m_61124_((Property)SwampVineBlock.m_57883_((Direction)oppositeDir), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (canAttachCounterClockWise && level.m_46859_(posRelativeCounterClockWise) && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)pos.m_121945_(counterClockWiseDir), (Direction)oppositeDir)) {
                                level.m_7731_(posRelativeCounterClockWise, (BlockState)this.m_49966_().m_61124_((Property)SwampVineBlock.m_57883_((Direction)oppositeDir), (Comparable)Boolean.valueOf(true)), 2);
                            } else if ((double)rand.m_188501_() < 0.05 && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)relativePosInDir.m_7494_(), (Direction)Direction.UP)) {
                                level.m_7731_(relativePosInDir, (BlockState)this.m_49966_().m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    } else if (SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)relativePosInDir, (Direction)direction)) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SwampVineBlock.m_57883_((Direction)direction), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                if (direction == Direction.UP && pos.m_123342_() < level.m_151558_() - 1) {
                    if (this.m_57887_((BlockGetter)level, pos, direction)) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_57833_, (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                    if (level.m_46859_(blockpos)) {
                        if (!this.canSpread((BlockGetter)level, pos)) {
                            return;
                        }
                        BlockState stateForPlacement = state;
                        for (Direction horizontalDir : Direction.Plane.HORIZONTAL) {
                            if (!rand.m_188499_() && SwampVineBlock.m_57853_((BlockGetter)level, (BlockPos)blockpos.m_121945_(horizontalDir), (Direction)horizontalDir)) continue;
                            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)SwampVineBlock.m_57883_((Direction)horizontalDir), (Comparable)Boolean.valueOf(false));
                        }
                        if (this.m_57911_(stateForPlacement)) {
                            level.m_7731_(blockpos, stateForPlacement, 2);
                        }
                        return;
                    }
                }
                if (pos.m_123342_() > level.m_141937_()) {
                    BlockState stateForPlacement;
                    BlockState vineBelow;
                    BlockPos posBelow = pos.m_7495_();
                    BlockState stateBelow = level.m_8055_(posBelow);
                    FluidState fluidStateBelow = level.m_6425_(posBelow);
                    if ((stateBelow.m_60795_() || stateBelow.m_60713_(Blocks.f_49990_) && fluidStateBelow.m_76186_() == 8 || stateBelow.m_60713_((Block)this)) && (vineBelow = stateBelow.m_60795_() || stateBelow.m_60713_(Blocks.f_49990_) ? (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(stateBelow.m_60713_(Blocks.f_49990_))) : stateBelow) != (stateForPlacement = this.m_222650_(state, vineBelow, rand)) && this.m_57911_(stateForPlacement)) {
                        level.m_7731_(posBelow, stateForPlacement, 2);
                    }
                }
            }
        }
    }

    private boolean canSpread(BlockGetter getter, BlockPos pos) {
        Iterable iterable = BlockPos.m_121976_((int)(pos.m_123341_() - 4), (int)(pos.m_123342_() - 1), (int)(pos.m_123343_() - 4), (int)(pos.m_123341_() + 4), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 4));
        int iterationsRemaining = 5;
        for (BlockPos blockpos : iterable) {
            if (!getter.m_8055_(blockpos).m_60713_((Block)this) || --iterationsRemaining > 0) continue;
            return false;
        }
        return true;
    }

    public boolean m_57887_(BlockGetter getter, BlockPos pos, Direction dir) {
        if (dir == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pos.m_121945_(dir);
        if (SwampVineBlock.m_57853_((BlockGetter)getter, (BlockPos)blockpos, (Direction)dir)) {
            return true;
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty directionProperty = (BooleanProperty)f_57838_.get(dir);
        BlockState blockstate = getter.m_8055_(pos.m_7494_());
        return blockstate.m_60713_((Block)this) && (Boolean)blockstate.m_61143_((Property)directionProperty) != false;
    }
}

