/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.entity;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import plus.dragons.splashmilk.PlatformUtil;
import plus.dragons.splashmilk.entity.MIlkAreaEffectCloudEntity;

public class MilkBottleEntity
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final Predicate<LivingEntity> WATER_SENSITIVE = LivingEntity::m_6126_;

    public MilkBottleEntity(EntityType<? extends MilkBottleEntity> entityType, Level world) {
        super(entityType, world);
    }

    public MilkBottleEntity(Level world, LivingEntity livingEntity) {
        super(PlatformUtil.getMIlkBottleEntityType().get(), livingEntity, world);
    }

    protected float m_7139_() {
        return 0.05f;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            Direction direction = blockHitResult.m_82434_();
            BlockPos blockpos = blockHitResult.m_82425_();
            BlockPos blockpos1 = blockpos.m_121945_(direction);
            this.extinguishFire(blockpos1);
            this.extinguishFire(blockpos1.m_121945_(direction.m_122424_()));
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.extinguishFire(blockpos1.m_121945_(direction1));
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().m_5776_()) {
            this.applyWater();
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud();
            } else {
                this.applySplash();
            }
            this.m_9236_().m_46796_(2007, this.m_20183_(), 0xFFFFFF);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void applyWater() {
        AABB box = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.m_9236_().m_6443_(LivingEntity.class, box, WATER_SENSITIVE);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                double d0 = this.m_20280_((Entity)livingentity);
                if (!(d0 < 16.0) || !livingentity.m_6126_()) continue;
                livingentity.m_6469_(this.m_269291_().m_269104_((Entity)this, this.m_19749_()), 1.0f);
            }
        }
    }

    private void applySplash() {
        AABB box = this.m_20191_().m_82377_(4.0, 2.0, 4.0);
        List list = this.m_9236_().m_45976_(LivingEntity.class, box);
        if (!list.isEmpty()) {
            for (LivingEntity livingentity : list) {
                livingentity.m_21219_();
            }
        }
    }

    private void makeAreaOfEffectCloud() {
        MIlkAreaEffectCloudEntity cloudEntity = new MIlkAreaEffectCloudEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            cloudEntity.setOwner((LivingEntity)entity);
        }
        cloudEntity.setRadius(3.0f);
        cloudEntity.setRadiusOnUse(-0.5f);
        cloudEntity.setWaitTime(10);
        cloudEntity.setRadiusPerTick(-cloudEntity.getRadius() / (float)cloudEntity.getDuration());
        this.m_9236_().m_7967_((Entity)cloudEntity);
    }

    private boolean isLingering() {
        return this.m_7846_().m_41720_() == PlatformUtil.getLingerMIlkBottleItem().get();
    }

    private void extinguishFire(BlockPos blockPos) {
        BlockState blockState = this.m_9236_().m_8055_(blockPos);
        if (blockState.m_204336_(BlockTags.f_13076_)) {
            this.m_9236_().m_7471_(blockPos, false);
        } else if (AbstractCandleBlock.m_151933_((BlockState)blockState)) {
            AbstractCandleBlock.m_151899_(null, (BlockState)blockState, (LevelAccessor)this.m_9236_(), (BlockPos)blockPos);
        } else if (CampfireBlock.m_51319_((BlockState)blockState)) {
            this.m_9236_().m_5898_(null, 1009, blockPos, 0);
            CampfireBlock.m_152749_(null, (LevelAccessor)this.m_9236_(), (BlockPos)blockPos, (BlockState)blockState);
            this.m_9236_().m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected Item m_7881_() {
        return PlatformUtil.getLingerMIlkBottleItem().get();
    }
}

