/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.splashmilk.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;
import plus.dragons.splashmilk.PlatformUtil;

public class MIlkAreaEffectCloudEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(MIlkAreaEffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(MIlkAreaEffectCloudEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUUID;

    public MIlkAreaEffectCloudEntity(EntityType<? extends MIlkAreaEffectCloudEntity> entityType, Level world) {
        super(entityType, world);
        this.f_19794_ = true;
        this.setRadius(3.0f);
    }

    public MIlkAreaEffectCloudEntity(Level world, double x, double y, double z) {
        this(PlatformUtil.getMilkCloudEntityType().get(), world);
        this.m_6034_(x, y, z);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        if (!this.m_9236_().m_5776_()) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAITING);
    }

    protected void setWaiting(boolean waiting) {
        this.m_20088_().m_135381_(DATA_WAITING, (Object)waiting);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int p_184486_1_) {
        this.duration = p_184486_1_;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.5f));
        this.m_20088_().m_135372_(DATA_WAITING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        float radius = this.getRadius();
        if (this.m_9236_().m_5776_()) {
            this.generateParticle(radius);
        } else {
            this.handleLifecycle(radius);
        }
    }

    private void handleLifecycle(float radius) {
        boolean flag1;
        boolean flag = this.isWaiting();
        if (this.f_19797_ >= this.waitTime + this.duration) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        boolean bl = flag1 = this.f_19797_ < this.waitTime;
        if (flag != flag1) {
            this.setWaiting(flag1);
        }
        if (flag1) {
            return;
        }
        if (this.radiusPerTick != 0.0f) {
            if ((radius += this.radiusPerTick) < 0.5f) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.setRadius(radius);
        }
        if (this.f_19797_ % 5 == 0) {
            this.findEntityAndApply(radius);
        }
    }

    private void generateParticle(float radius) {
        block3: {
            block2: {
                if (!this.isWaiting()) break block2;
                if (!this.f_19796_.m_188499_()) break block3;
                for (int i = 0; i < 2; ++i) {
                    float f1 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                    float f2 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * 0.2f;
                    float f3 = Mth.m_14089_((float)f1) * f2;
                    float f4 = Mth.m_14031_((float)f1) * f2;
                    this.m_9236_().m_7107_(PlatformUtil.getMilkCloudParticle().get(), this.m_20185_() + (double)f3, this.m_20186_(), this.m_20189_() + (double)f4, 0.98, 0.99, 1.0);
                }
                break block3;
            }
            float f5 = (float)Math.PI * radius * radius;
            int k1 = 0;
            while ((float)k1 < f5) {
                float f6 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float f7 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * radius;
                float f8 = Mth.m_14089_((float)f6) * f7;
                float f9 = Mth.m_14031_((float)f6) * f7;
                this.m_9236_().m_7107_(PlatformUtil.getMilkCloudParticle().get(), this.m_20185_() + (double)f8, this.m_20186_(), this.m_20189_() + (double)f9, 0.98, 0.99, 1.0);
                ++k1;
            }
        }
    }

    private void findEntityAndApply(float radius) {
        this.victims.entrySet().removeIf(entry -> this.f_19797_ >= (Integer)entry.getValue());
        List list1 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
        if (!list1.isEmpty()) {
            for (LivingEntity livingentity : list1) {
                double d1;
                double d0;
                double d2;
                if (this.victims.containsKey(livingentity) || !livingentity.m_5801_() || !((d2 = (d0 = livingentity.m_20185_() - this.m_20185_()) * d0 + (d1 = livingentity.m_20189_() - this.m_20189_()) * d1) <= (double)(radius * radius))) continue;
                this.victims.put((Entity)livingentity, this.f_19797_ + this.reapplicationDelay);
                livingentity.m_21219_();
                if (this.radiusOnUse != 0.0f) {
                    if ((radius += this.radiusOnUse) < 0.5f) {
                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                        return;
                    }
                    this.setRadius(radius);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
    }

    protected void m_7378_(CompoundTag nbt) {
        this.f_19797_ = nbt.m_128451_("Age");
        this.duration = nbt.m_128451_("Duration");
        this.waitTime = nbt.m_128451_("WaitTime");
        this.reapplicationDelay = nbt.m_128451_("ReapplicationDelay");
        this.durationOnUse = nbt.m_128451_("DurationOnUse");
        this.radiusOnUse = nbt.m_128457_("RadiusOnUse");
        this.radiusPerTick = nbt.m_128457_("RadiusPerTick");
        this.setRadius(nbt.m_128457_("Radius"));
        if (nbt.m_128403_("Owner")) {
            this.ownerUUID = nbt.m_128342_("Owner");
        }
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Age", this.f_19797_);
        nbt.m_128405_("Duration", this.duration);
        nbt.m_128405_("WaitTime", this.waitTime);
        nbt.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        nbt.m_128405_("DurationOnUse", this.durationOnUse);
        nbt.m_128350_("RadiusOnUse", this.radiusOnUse);
        nbt.m_128350_("RadiusPerTick", this.radiusPerTick);
        nbt.m_128350_("Radius", this.getRadius());
        if (this.ownerUUID != null) {
            nbt.m_128362_("Owner", this.ownerUUID);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public void setOwner(@Nullable LivingEntity livingEntity) {
        this.owner = livingEntity;
        this.ownerUUID = livingEntity == null ? null : livingEntity.m_20148_();
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_RADIUS.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

