/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.EntityMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyCondition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyFilterAttribute;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class AlchemyUpgradeWrapper
extends UpgradeWrapperBase<AlchemyUpgradeWrapper, AlchemyUpgradeItem>
implements ITickableUpgrade {
    private static final int CHECK_INTERVAL = 5;
    private static final int CHECK_RADIUS = 3;
    private static final String ALCHEMY_FILTER_ATTRIBUTES_TAG = "alchemyFilterAttributes";
    private static final String MATCH_ALL_EFFECTS_TAG = "matchAllEffects";
    private static final String MATCH_EFFECT_DURATION_TAG = "matchEffectDuration";
    private static final String MATCH_EFFECT_AMPLIFIER_TAG = "matchEffectAmplifier";
    private static final String ENTITY_MATCH_TAG = "entityMatch";
    private long nextCheckTime = 0L;
    private boolean applying = false;
    private LivingEntity applyingToEntity = null;
    private int remainingApplyTime = 0;
    private ItemStack stackBeingAplied = ItemStack.f_41583_;
    private AlchemyItemDefinition defBeingApplied = null;
    @Nullable
    private ObservableFilterItemStackHandler filterHandler = null;
    private static List<AlchemyItemDefinition> itemDefinitions = new ArrayList<AlchemyItemDefinition>();
    private static final Method ON_HIT;
    private static final Field EFFECTS;

    protected AlchemyUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
    }

    public List<AlchemyFilterAttribute> getFilterAttributes() {
        return NBTHelper.getCollection(this.upgrade, "", ALCHEMY_FILTER_ATTRIBUTES_TAG, (byte)10, tag -> Optional.of(AlchemyFilterAttribute.deserializeNBT((CompoundTag)tag)), ArrayList::new).orElseGet(ArrayList::new);
    }

    private List<AlchemyFilterAttribute> getEmptyAttributes() {
        ArrayList<AlchemyFilterAttribute> emptyAttributes = new ArrayList<AlchemyFilterAttribute>();
        for (int i = 0; i < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount(); ++i) {
            emptyAttributes.add(new AlchemyFilterAttribute(ItemStack.f_41583_, AlchemyCondition.NEVER));
        }
        return emptyAttributes;
    }

    private void setFilter(int slot, ItemStack filter) {
        ArrayList<AlchemyFilterAttribute> attributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
        AlchemyFilterAttribute attribute = (AlchemyFilterAttribute)attributes.get(slot);
        if (attribute.filter().m_41619_()) {
            AlchemyCondition defaultConditionForPotion = itemDefinitions.stream().filter(def -> def.filter.test(filter)).findFirst().map(def -> def.getDefaultCondition.apply(filter)).orElse(AlchemyCondition.NEVER);
            attribute = attribute.setConditionAndValue(defaultConditionForPotion, defaultConditionForPotion.defaultValue());
        } else if (filter.m_41619_()) {
            attribute = attribute.setConditionAndValue(AlchemyCondition.NEVER, -1.0f);
        }
        attribute = attribute.setFilter(filter);
        attributes.set(slot, attribute);
        this.setUpgradeStackAlchemyAttributes(attributes);
        this.save();
    }

    public AlchemyCondition getCondition(int slot) {
        return this.getFilterAttributes().get(slot).condition();
    }

    public float getValue(int slot) {
        return this.getFilterAttributes().get(slot).value();
    }

    public void setConditionValue(int slot, AlchemyCondition condition, float value) {
        ArrayList<AlchemyFilterAttribute> attributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
        attributes.set(slot, ((AlchemyFilterAttribute)attributes.get(slot)).setConditionAndValue(condition, value));
        this.setUpgradeStackAlchemyAttributes(attributes);
        this.save();
    }

    private void setUpgradeStackAlchemyAttributes(List<AlchemyFilterAttribute> attributes) {
        NBTHelper.setList(this.upgrade, "", ALCHEMY_FILTER_ATTRIBUTES_TAG, attributes, AlchemyFilterAttribute::serializeNBT);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.m_5776_() || this.nextCheckTime > level.m_46467_()) {
            return;
        }
        if (this.remainingApplyTime > 0) {
            --this.remainingApplyTime;
            if (this.remainingApplyTime <= 0) {
                if (this.defBeingApplied.hasItemUseEffects()) {
                    this.triggerItemUseEffects(level);
                }
                this.applying = false;
                ItemStack remainingStack = this.defBeingApplied.finishUsing.apply(this.stackBeingAplied, this.applyingToEntity);
                this.stackBeingAplied = ItemStack.f_41583_;
                this.storageWrapper.getInventoryForUpgradeProcessing().insertItem(remainingStack, false);
                this.nextCheckTime = level.m_46467_() + 5L;
            } else if (this.shouldTriggerItemUseEffects()) {
                this.triggerItemUseEffects(level);
            }
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.applyTo(livingEntity);
        } else {
            level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(3.0), this::entityMatches).forEach(this::applyTo);
        }
        if (!this.applying) {
            this.nextCheckTime = level.m_46467_() + 5L;
        }
    }

    private boolean entityMatches(LivingEntity livingEntity) {
        if (!livingEntity.m_6084_()) {
            return false;
        }
        switch (this.getEntityMatch()) {
            case PLAYERS: {
                return livingEntity instanceof Player;
            }
            case ENTITIES: {
                return !(livingEntity instanceof Player);
            }
            case PLAYERS_AND_ENTITIES: {
                return true;
            }
        }
        return false;
    }

    public void triggerItemUseEffects(Level level) {
        if (this.stackBeingAplied.m_41780_() == UseAnim.DRINK) {
            level.m_6263_(null, this.applyingToEntity.m_20185_(), this.applyingToEntity.m_20186_(), this.applyingToEntity.m_20189_(), this.stackBeingAplied.m_41615_(), this.applyingToEntity.m_5720_(), 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        if (this.stackBeingAplied.m_41780_() == UseAnim.EAT) {
            level.m_6263_(null, this.applyingToEntity.m_20185_(), this.applyingToEntity.m_20186_(), this.applyingToEntity.m_20189_(), this.applyingToEntity.m_7866_(this.stackBeingAplied), this.applyingToEntity.m_5720_(), 0.5f + 0.5f * (float)level.f_46441_.m_188503_(2), (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f);
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int effectDelay;
        if (this.remainingApplyTime < 2) {
            return false;
        }
        int applyTimePassed = this.stackBeingAplied.m_41779_() - this.remainingApplyTime;
        boolean canStartTriggering = applyTimePassed > (effectDelay = (int)((float)this.stackBeingAplied.m_41779_() * 0.21875f));
        return canStartTriggering && this.remainingApplyTime % 4 == 0;
    }

    private void applyTo(LivingEntity livingEntity) {
        for (AlchemyFilterAttribute filterAttribute : this.getFilterAttributes()) {
            if (filterAttribute.filter().m_41619_() || !filterAttribute.condition().test(livingEntity, filterAttribute.value())) continue;
            itemDefinitions.stream().filter(def -> def.filter.test(filterAttribute.filter())).findFirst().ifPresent(def -> {
                if (def.canApply.test(livingEntity, filterAttribute.filter(), this.shouldMatchAllEffects(), this.shouldMatchEffectAmplifier())) {
                    InventoryHelper.iterate((IItemHandler)this.storageWrapper.getInventoryForUpgradeProcessing(), (slot, stack) -> {
                        if (def.filter().test((ItemStack)stack) && def.stackMatches.test((ItemStack)stack, filterAttribute.filter(), this.shouldMatchAllEffects(), this.shouldMatchEffectDuration(), this.shouldMatchEffectAmplifier())) {
                            this.remainingApplyTime = def.startUsing.applyAsInt((ItemStack)stack, livingEntity);
                            if (this.remainingApplyTime > 0) {
                                this.applying = true;
                                this.stackBeingAplied = stack.m_255036_(1);
                                this.defBeingApplied = def;
                                this.applyingToEntity = livingEntity;
                            }
                            stack.m_41774_(1);
                            this.storageWrapper.getInventoryForUpgradeProcessing().setStackInSlot((int)slot, (ItemStack)stack);
                        }
                    }, () -> this.applying);
                }
            });
        }
    }

    public static void addItemDefinition(AlchemyItemDefinition itemDefinition) {
        itemDefinitions.add(itemDefinition);
    }

    private static boolean foodStackPotionEffectsMatch(ItemStack stack, ItemStack filter, boolean matchAllEffects, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        if (matchAllEffects && matchEffectDuration && matchEffectAmplifier) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack);
        }
        FoodProperties foodProperties = stack.getFoodProperties(null);
        FoodProperties filterFoodProperties = filter.getFoodProperties(null);
        if (foodProperties == null || filterFoodProperties == null) {
            return false;
        }
        if (AlchemyUpgradeWrapper.getEffects(foodProperties).isEmpty() || AlchemyUpgradeWrapper.getEffects(filterFoodProperties).isEmpty()) {
            return false;
        }
        for (Pair<Supplier<MobEffectInstance>, Float> possibleEffect : AlchemyUpgradeWrapper.getEffects(filterFoodProperties)) {
            if (!AlchemyUpgradeWrapper.matchEffectIn(foodProperties, (MobEffectInstance)((Supplier)possibleEffect.getFirst()).get(), matchEffectDuration, matchEffectAmplifier)) {
                return false;
            }
            if (matchAllEffects) continue;
            return true;
        }
        return true;
    }

    private static void onHit(ThrownPotion thrownPotion, EntityHitResult entityHitResult) {
        try {
            ON_HIT.invoke((Object)thrownPotion, entityHitResult);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Failed to invoke ThrownPotion::onHit method", (Throwable)e);
        }
    }

    private static List<Pair<Supplier<MobEffectInstance>, Float>> getEffects(FoodProperties foodProperties) {
        try {
            return (List)EFFECTS.get(foodProperties);
        }
        catch (IllegalAccessException e) {
            SophisticatedCore.LOGGER.error("Failed to access FoodProperties::effects field", (Throwable)e);
            return List.of();
        }
    }

    private static boolean matchEffectIn(FoodProperties foodProperties, MobEffectInstance filterInstance, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        for (Pair<Supplier<MobEffectInstance>, Float> effectInstance : AlchemyUpgradeWrapper.getEffects(foodProperties)) {
            MobEffectInstance effect = (MobEffectInstance)((Supplier)effectInstance.getFirst()).get();
            if (effect.m_19544_() != filterInstance.m_19544_() || matchEffectDuration && effect.m_19557_() != filterInstance.m_19557_() || matchEffectAmplifier && effect.m_19564_() != filterInstance.m_19564_()) continue;
            return true;
        }
        return false;
    }

    public static boolean stackPotionEffectsMatch(ItemStack stack, ItemStack filter, boolean matchAllEffects, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        if (matchAllEffects && matchEffectDuration && matchEffectAmplifier) {
            return ItemHandlerHelper.canItemStacksStack((ItemStack)filter, (ItemStack)stack);
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("Potion") && !stack.m_41783_().m_128441_("CustomPotionEffects")) {
            return false;
        }
        List effects = PotionUtils.m_43547_((ItemStack)stack);
        List filterEffects = PotionUtils.m_43547_((ItemStack)filter);
        return AlchemyUpgradeWrapper.potionEffectsMatch(effects, filterEffects, matchAllEffects, matchEffectDuration, matchEffectAmplifier);
    }

    public static boolean potionEffectsMatch(List<MobEffectInstance> effects, List<MobEffectInstance> filterEffects, boolean matchAllEffects, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        if (effects.isEmpty() || filterEffects.isEmpty()) {
            return false;
        }
        for (MobEffectInstance filterEffectInstance : filterEffects) {
            if (!AlchemyUpgradeWrapper.matchEffectIn(effects, filterEffectInstance, matchEffectDuration, matchEffectAmplifier)) {
                return false;
            }
            if (matchAllEffects) continue;
            return true;
        }
        return true;
    }

    private static boolean matchEffectIn(List<MobEffectInstance> potionEffectInstances, MobEffectInstance filterEffectInstance, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        for (MobEffectInstance effectInstance : potionEffectInstances) {
            if (effectInstance.m_19544_() != filterEffectInstance.m_19544_() || matchEffectDuration && effectInstance.m_19557_() != filterEffectInstance.m_19557_() || matchEffectAmplifier && effectInstance.m_19564_() != filterEffectInstance.m_19564_()) continue;
            return true;
        }
        return false;
    }

    public static AlchemyCondition getDefaultConditionForPotion(ItemStack potionStack) {
        List effects = PotionUtils.m_43547_((ItemStack)potionStack);
        return AlchemyUpgradeWrapper.getDefaultConditionForPotionEffects(effects);
    }

    public static AlchemyCondition getDefaultConditionForPotionEffects(List<MobEffectInstance> effects) {
        Iterator<MobEffectInstance> it = effects.iterator();
        if (!it.hasNext()) {
            return AlchemyCondition.NEVER;
        }
        MobEffect effect = it.next().m_19544_();
        if (effect == MobEffects.f_19608_) {
            return AlchemyCondition.UNDER_WATER;
        }
        if (effect == MobEffects.f_19601_ || effect == MobEffects.f_19605_) {
            return AlchemyCondition.HURT;
        }
        if (effect == MobEffects.f_19607_) {
            return AlchemyCondition.ON_FIRE;
        }
        if (effect == MobEffects.f_19596_) {
            return AlchemyCondition.SPRINTING;
        }
        if (effect == MobEffects.f_19598_) {
            return AlchemyCondition.MINING;
        }
        if (effect == MobEffects.f_19591_) {
            return AlchemyCondition.FALLING;
        }
        return AlchemyCondition.ALWAYS;
    }

    public static boolean shouldApplyPotionEffectsTo(LivingEntity le, ItemStack potionStack, boolean matchAllEffects, boolean matchEffectAmplifier) {
        List effects = PotionUtils.m_43547_((ItemStack)potionStack);
        return AlchemyUpgradeWrapper.shouldApplyPotionEffectsTo(le, effects, matchAllEffects, matchEffectAmplifier);
    }

    public static boolean shouldApplyPotionEffectsTo(LivingEntity le, List<MobEffectInstance> effects, boolean matchAllEffects, boolean matchEffectAmplifier) {
        if (effects.isEmpty()) {
            return false;
        }
        for (MobEffectInstance effectInstance : effects) {
            if (matchAllEffects) {
                if (AlchemyUpgradeWrapper.effectPresent(le, effectInstance.m_19544_(), matchEffectAmplifier, effectInstance.m_19564_())) continue;
                return true;
            }
            if (!AlchemyUpgradeWrapper.effectPresent(le, effectInstance.m_19544_(), matchEffectAmplifier, effectInstance.m_19564_())) continue;
            return false;
        }
        return !matchAllEffects;
    }

    private static boolean effectPresent(LivingEntity le, MobEffect effect, boolean matchEffectAmplifier, int amplifier) {
        MobEffectInstance leEffectInstance = le.m_21124_(effect);
        return leEffectInstance != null && (!matchEffectAmplifier || leEffectInstance.m_19564_() >= amplifier);
    }

    private static boolean shouldApplyFoodEffectsTo(LivingEntity le, ItemStack potionStack, boolean matchAllEffects, boolean matchEffectAmplifier) {
        FoodProperties foodProperties = potionStack.getFoodProperties(le);
        if (foodProperties == null) {
            return false;
        }
        for (Pair<Supplier<MobEffectInstance>, Float> possibleEffect : AlchemyUpgradeWrapper.getEffects(foodProperties)) {
            MobEffectInstance effectInstance = (MobEffectInstance)((Supplier)possibleEffect.getFirst()).get();
            if (matchAllEffects) {
                if (AlchemyUpgradeWrapper.effectPresent(le, effectInstance.m_19544_(), matchEffectAmplifier, effectInstance.m_19564_())) continue;
                return true;
            }
            if (!AlchemyUpgradeWrapper.effectPresent(le, effectInstance.m_19544_(), matchEffectAmplifier, effectInstance.m_19564_())) continue;
            return false;
        }
        return !matchAllEffects;
    }

    public boolean isValidAlchemyItem(ItemStack stack) {
        return itemDefinitions.stream().anyMatch(def -> def.filter.test(stack)) && !InventoryHelper.hasItem((IItemHandler)this.getFilterHandler(), s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack));
    }

    public ObservableFilterItemStackHandler getFilterHandler() {
        List<AlchemyFilterAttribute> filterAttributes = this.getFilterAttributes();
        if (this.filterHandler == null) {
            if (filterAttributes.size() < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount()) {
                filterAttributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
                for (int i = filterAttributes.size(); i < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount(); ++i) {
                    filterAttributes.add(new AlchemyFilterAttribute(ItemStack.f_41583_, AlchemyCondition.NEVER));
                }
                this.setUpgradeStackAlchemyAttributes(filterAttributes);
            }
            this.filterHandler = new ObservableFilterItemStackHandler(filterAttributes.size());
            this.filterHandler.initFilters(filterAttributes);
        }
        return this.filterHandler;
    }

    public void setMatchAllEffects(boolean matchAllEffects) {
        this.upgrade.m_41784_().m_128379_(MATCH_ALL_EFFECTS_TAG, matchAllEffects);
        this.save();
    }

    public boolean shouldMatchAllEffects() {
        return NBTHelper.getBoolean(this.upgrade, "", MATCH_ALL_EFFECTS_TAG).orElse(true);
    }

    public boolean shouldMatchEffectDuration() {
        return NBTHelper.getBoolean(this.upgrade, "", MATCH_EFFECT_DURATION_TAG).orElse(true);
    }

    public void setMatchEffectDuration(boolean matchEffectDuration) {
        this.upgrade.m_41784_().m_128379_(MATCH_EFFECT_DURATION_TAG, matchEffectDuration);
        this.save();
    }

    public boolean shouldMatchEffectAmplifier() {
        return NBTHelper.getBoolean(this.upgrade, "", MATCH_EFFECT_AMPLIFIER_TAG).orElse(true);
    }

    public void setMatchEffectAmplifier(boolean matchEffectAmplifier) {
        this.upgrade.m_41784_().m_128379_(MATCH_EFFECT_AMPLIFIER_TAG, matchEffectAmplifier);
        this.save();
    }

    public EntityMatch getEntityMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, ENTITY_MATCH_TAG, EntityMatch::fromName).orElse(EntityMatch.PLAYERS_AND_ENTITIES);
    }

    public void setEntityMatch(EntityMatch entityMatch) {
        NBTHelper.setEnumConstant(this.upgrade, ENTITY_MATCH_TAG, entityMatch);
        this.save();
    }

    static {
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.m_41720_() == Items.f_42736_, AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, (stack, livingEntity) -> {
            Level level = livingEntity.m_9236_();
            level.m_6263_(null, livingEntity.m_20185_() + (double)(livingEntity.m_20205_() / 2.0f), livingEntity.m_20186_(), livingEntity.m_20189_() + (double)(livingEntity.m_20205_() / 2.0f), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
            ThrownPotion thrownPotion = new ThrownPotion(level, livingEntity.m_20185_() + (double)(livingEntity.m_20205_() / 2.0f), livingEntity.m_20186_() + (double)livingEntity.m_20192_(), livingEntity.m_20189_() + (double)(livingEntity.m_20205_() / 2.0f));
            thrownPotion.m_37446_(stack);
            AlchemyUpgradeWrapper.onHit(thrownPotion, new EntityHitResult((Entity)livingEntity, new Vec3(livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20192_(), livingEntity.m_20189_())));
            return 1;
        }, (stack, livingEntity) -> ItemStack.f_41583_, false));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.m_41720_() == Items.f_42589_, AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, (stack, livingEntity) -> stack.m_41779_(), (stack, livingEntity) -> {
            ItemStack remainingItem = stack.m_41720_().m_5922_(stack, livingEntity.m_9236_(), livingEntity);
            if (livingEntity instanceof Player) {
                return remainingItem;
            }
            return new ItemStack((ItemLike)Items.f_42590_);
        }));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.m_41720_() == Items.f_42455_, stack -> AlchemyCondition.NEGATIVE_EFFECT, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> true, (stack, filter, matchAllEffects, matchEffectDuration, matchEffectAmplifier) -> stack.m_41720_() == Items.f_42455_, (stack, livingEntity) -> stack.m_41779_(), (stack, livingEntity) -> stack.m_41720_().m_5922_(stack, livingEntity.m_9236_(), livingEntity)));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.m_41720_() == Items.f_42436_, stack -> AlchemyCondition.ALWAYS, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> {
            if (le instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)le;
                return !zombieVillager.m_34408_() && zombieVillager.m_21023_(MobEffects.f_19613_);
            }
            if (le instanceof Player) {
                return AlchemyUpgradeWrapper.shouldApplyFoodEffectsTo(le, potionStack, matchAllEffects, matchEffectAmplifier);
            }
            return false;
        }, AlchemyUpgradeWrapper::foodStackPotionEffectsMatch, (stack, livingEntity) -> stack.m_41779_(), (stack, livingEntity) -> {
            ZombieVillager zombieVillager;
            if (livingEntity instanceof ZombieVillager && (zombieVillager = (ZombieVillager)livingEntity).m_21023_(MobEffects.f_19613_)) {
                zombieVillager.m_34383_(null, livingEntity.m_9236_().f_46441_.m_188503_(2401) + 3600);
                return ItemStack.f_41583_;
            }
            return stack.m_41720_().m_5922_(stack, livingEntity.m_9236_(), livingEntity);
        }));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> {
            FoodProperties foodProperties = stack.getFoodProperties(null);
            return foodProperties != null && !AlchemyUpgradeWrapper.getEffects(foodProperties).isEmpty();
        }, stack -> AlchemyCondition.ALWAYS, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> {
            if (le instanceof Player) {
                return AlchemyUpgradeWrapper.shouldApplyFoodEffectsTo(le, potionStack, matchAllEffects, matchEffectAmplifier);
            }
            return false;
        }, AlchemyUpgradeWrapper::foodStackPotionEffectsMatch, (stack, livingEntity) -> stack.m_41779_(), (stack, livingEntity) -> stack.m_41720_().m_5922_(stack, livingEntity.m_9236_(), livingEntity)));
        ON_HIT = ObfuscationReflectionHelper.findMethod(ThrownPotion.class, (String)"m_6532_", (Class[])new Class[]{HitResult.class});
        EFFECTS = ObfuscationReflectionHelper.findField(FoodProperties.class, (String)"f_38728_");
    }

    public record AlchemyItemDefinition(Predicate<ItemStack> filter, Function<ItemStack, AlchemyCondition> getDefaultCondition, AlchemyItemEntityMatcher canApply, AlchemyItemStackMatcher stackMatches, StartUsing startUsing, FinishUsing finishUsing, boolean hasItemUseEffects) {
        public AlchemyItemDefinition(Predicate<ItemStack> filter, Function<ItemStack, AlchemyCondition> getDefaultCondition, AlchemyItemEntityMatcher canApply, AlchemyItemStackMatcher stackMatches, StartUsing startUsing, FinishUsing finishUsing) {
            this(filter, getDefaultCondition, canApply, stackMatches, startUsing, finishUsing, true);
        }
    }

    public class ObservableFilterItemStackHandler
    extends FilterItemStackHandler {
        public ObservableFilterItemStackHandler(int filterSlotCount) {
            super(filterSlotCount);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            AlchemyUpgradeWrapper.this.setFilter(slot, (ItemStack)this.stacks.get(slot));
            AlchemyUpgradeWrapper.this.save();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41619_() || this.doesNotContain(stack) && AlchemyUpgradeWrapper.this.isValidAlchemyItem(stack);
        }

        private boolean doesNotContain(ItemStack stack) {
            return !InventoryHelper.hasItem((IItemHandler)this, s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack));
        }

        public void initFilters(List<AlchemyFilterAttribute> filterAttributes) {
            for (int slot = 0; slot < filterAttributes.size(); ++slot) {
                this.setStackInSlot(slot, filterAttributes.get(slot).filter().m_41777_());
            }
            this.onLoad();
        }
    }

    public static interface FinishUsing {
        public ItemStack apply(ItemStack var1, LivingEntity var2);
    }

    public static interface AlchemyItemEntityMatcher {
        public boolean test(LivingEntity var1, ItemStack var2, boolean var3, boolean var4);
    }

    public static interface AlchemyItemStackMatcher {
        public boolean test(ItemStack var1, ItemStack var2, boolean var3, boolean var4, boolean var5);
    }

    public static interface StartUsing {
        public int applyAsInt(ItemStack var1, LivingEntity var2);
    }
}

