/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.init;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedcore.compat.craftingtweaks.CraftingTweaksCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.create.CreateCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.curios.CuriosCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.inventorysorter.InventorySorterCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.itemborders.ItemBordersCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.emi.EmiCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.reliquary.ReliquaryCompat;
import net.p3pp3rf1y.sophisticatedcore.compat.trashslot.TrashSlotCompat;

public class ModCompat {
    private static final Map<String, Supplier<Callable<ICompat>>> compatFactories = new HashMap<String, Supplier<Callable<ICompat>>>();

    private ModCompat() {
    }

    public static void initCompats() {
        for (Map.Entry<String, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            try {
                entry.getValue().get().call().setup();
            }
            catch (Exception e) {
                SophisticatedCore.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
            }
        }
    }

    static {
        compatFactories.put("jei", () -> JeiCompat::new);
        compatFactories.put("roughlyenoughitems", () -> ReiCompat::new);
        compatFactories.put("emi", () -> EmiCompat::new);
        compatFactories.put("craftingtweaks", () -> CraftingTweaksCompat::new);
        compatFactories.put("inventorysorter", () -> InventorySorterCompat::new);
        compatFactories.put("itemborders", () -> ItemBordersCompat::new);
        compatFactories.put("curios", () -> CuriosCompat::new);
        compatFactories.put("create", () -> CreateCompat::new);
        compatFactories.put("trashslot", () -> TrashSlotCompat::new);
        compatFactories.put("reliquary", () -> ReliquaryCompat::new);
    }
}

