/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.rei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackSettingsScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.recipeviewers.common.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiCraftingContainerTransferHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiSettingsGhostIngredientHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiStorageGhostIngredientHandler;

@REIPluginClient
public class BackpackReiClientPlugin
implements REIClientPlugin {
    private static Consumer<WorkstationRegistration> additionalWorkstations = registration -> {};

    public static void addAdditionalWorkstations(Consumer<WorkstationRegistration> additionalWorkstations) {
        BackpackReiClientPlugin.additionalWorkstations = BackpackReiClientPlugin.additionalWorkstations.andThen(additionalWorkstations);
    }

    public void registerExclusionZones(ExclusionZones zones) {
        zones.register(BackpackScreen.class, screen -> {
            ArrayList ret = new ArrayList();
            screen.getUpgradeSlotsRectangle().ifPresent(ret::add);
            ret.addAll(screen.getUpgradeSettingsControl().getTabRectangles());
            screen.getSortButtonsRectangle().ifPresent(ret::add);
            return ret.stream().map(r -> new Rectangle(r.m_110085_(), r.m_110086_(), r.m_110090_(), r.m_110091_())).toList();
        });
        zones.register(BackpackSettingsScreen.class, screen -> {
            if (screen == null || screen.getSettingsTabControl() == null) {
                return List.of();
            }
            return screen.getSettingsTabControl().getTabRectangles().stream().map(r -> new Rectangle(r.m_110085_(), r.m_110086_(), r.m_110090_(), r.m_110091_())).toList();
        });
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(ReiCraftingContainerTransferHandler.crafting(BackpackContainer.class));
        registry.register(ReiCraftingContainerTransferHandler.smithing(BackpackContainer.class));
    }

    public void registerCategories(CategoryRegistry registry) {
        registry.addWorkstations(BuiltinPlugin.CRAFTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.CRAFTING_UPGRADE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMITHING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.SMITHING_UPGRADE.get()))});
        registry.addWorkstations(BuiltinPlugin.STONE_CUTTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModItems.STONECUTTER_UPGRADE.get()))});
        additionalWorkstations.accept(new WorkstationRegistration(registry));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new ReiStorageGhostIngredientHandler(BackpackScreen.class));
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new ReiSettingsGhostIngredientHandler(BackpackSettingsScreen.class));
    }

    public void registerDisplays(DisplayRegistry registry) {
        DyeRecipesMaker.getRecipes().forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }

    public static class WorkstationRegistration {
        private final CategoryRegistry registry;

        private WorkstationRegistration(CategoryRegistry registry) {
            this.registry = registry;
        }

        public void addWorkstations(CategoryIdentifier<? extends Display> id, Item ... workstations) {
            this.registry.addWorkstations(id, (EntryStack[])Arrays.stream(workstations).map(EntryStacks::of).toArray(EntryStack[]::new));
        }
    }
}

