/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;

public class TileEntityRGB16
extends TileEntityBase
implements IRGB16_Tile {
    private RGB16 rgb16 = new RGB16(15, 15, 15);

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, DyeColor.WHITE);
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, DyeColor color) {
        this(type, pos, state, new RGB16(color.m_41065_()).getIndex());
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, RGB16 rgb16) {
        this(type, pos, state, rgb16.getIndex());
    }

    public TileEntityRGB16(BlockEntityType<?> type, BlockPos pos, BlockState state, short index) {
        super(type, pos, state);
        this.getRGB16(null).setValues(index);
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        short rgbIndex = this.getRGB16(null).getIndex();
        nbtTag.m_128376_("rgb16", rgbIndex);
        nbtTag.m_128344_("rgbsimple", RGB16Helper.getSimpleColor(rgbIndex));
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        this.loadRGB16(nbtTag.m_128448_("rgb16"));
    }

    private boolean loadRGB16(short rgbIndex) {
        return rgbIndex > -1 && rgbIndex < 4096 && this.getRGB16(null).setValues(rgbIndex);
    }

    @Override
    public RGB16 getRGB16(Player player) {
        if (this.rgb16 == null) {
            this.rgb16 = new RGB16("white");
        }
        return this.rgb16;
    }

    @Override
    public boolean setRGB16(short rgbIndex, Player player) {
        boolean result = this.loadRGB16(rgbIndex);
        if (result) {
            Function.syncTile(this);
        }
        return result;
    }
}

