/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.item;

import com.ombremoon.playingcards.entity.EntityCard;
import com.ombremoon.playingcards.entity.EntityCardDeck;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.base.ItemBase;
import com.ombremoon.playingcards.util.CardHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ItemCardCovered
extends ItemBase {
    public ItemCardCovered() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag nbt = ItemHelper.getNBT(pStack);
        pTooltipComponents.add((Component)Component.m_237115_((String)"lore.cover").m_130946_(" ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)CardHelper.CARD_SKIN_NAMES[nbt.m_128445_("SkinID")]).m_130940_(ChatFormatting.AQUA)));
    }

    public void flipCard(ItemStack heldItem, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (heldItem.m_41720_() instanceof ItemCardCovered) {
                CompoundTag heldNBT = ItemHelper.getNBT(heldItem);
                Item nextCard = (Item)InitItems.CARD.get();
                if (!heldNBT.m_128471_("Covered")) {
                    nextCard = (Item)InitItems.CARD_COVERED.get();
                }
                ItemStack newCard = new ItemStack((ItemLike)nextCard);
                newCard.m_41721_(heldItem.m_41773_());
                ItemHelper.getNBT(newCard).m_128362_("UUID", heldNBT.m_128342_("UUID"));
                ItemHelper.getNBT(newCard).m_128344_("SkinID", heldNBT.m_128445_("SkinID"));
                ItemHelper.getNBT(newCard).m_128379_("Covered", !heldNBT.m_128471_("Covered"));
                player.m_21008_(InteractionHand.MAIN_HAND, newCard);
            }
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.m_46467_() % 60L == 0L && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockPos pos = player.m_20183_();
            CompoundTag nbt = ItemHelper.getNBT(pStack);
            if (nbt.m_128403_("UUID")) {
                UUID id = ItemHelper.getNBT(pStack).m_128342_("UUID");
                if (id.getLeastSignificantBits() == 0L) {
                    return;
                }
                List closeDecks = pLevel.m_45976_(EntityCardDeck.class, new AABB((double)(pos.m_123341_() - 20), (double)(pos.m_123342_() - 20), (double)(pos.m_123343_() - 20), (double)(pos.m_123341_() + 20), (double)(pos.m_123342_() + 20), (double)(pos.m_123343_() + 20)));
                boolean found = false;
                for (EntityCardDeck closeDeck : closeDecks) {
                    if (!closeDeck.m_20148_().equals(id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    player.m_150109_().m_8020_(pSlotId).m_41774_(1);
                }
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Player player = pContext.m_43723_();
        if (player != null && !player.m_6047_()) {
            BlockPos pos = pContext.m_8083_();
            List closeDecks = pContext.m_43725_().m_45976_(EntityCardDeck.class, new AABB((double)(pos.m_123341_() - 8), (double)(pos.m_123342_() - 8), (double)(pos.m_123343_() - 8), (double)(pos.m_123341_() + 8), (double)(pos.m_123342_() + 8), (double)(pos.m_123343_() + 8)));
            CompoundTag nbt = ItemHelper.getNBT(pContext.m_43722_());
            UUID deckID = nbt.m_128342_("UUID");
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!closeDeck.m_20148_().equals(deckID)) continue;
                Level world = pContext.m_43725_();
                EntityCard cardDeck = new EntityCard(world, pContext.m_43720_(), pContext.m_7074_(), nbt.m_128445_("SkinID"), deckID, nbt.m_128471_("Covered"), (byte)pContext.m_43722_().m_41773_());
                world.m_7967_((Entity)cardDeck);
                pContext.m_43722_().m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

