/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity.base;

import com.ombremoon.playingcards.entity.data.PCDataSerializers;
import com.ombremoon.playingcards.util.ArrayHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class EntityStacked
extends Entity {
    public static final byte MAX_STACK_SIZE = 52;
    protected static final EntityDataAccessor<Byte[]> STACK = SynchedEntityData.m_135353_(EntityStacked.class, PCDataSerializers.STACK);

    public EntityStacked(EntityType<? extends EntityStacked> type, Level world) {
        super(type, world);
    }

    public EntityStacked(EntityType<? extends EntityStacked> type, Level world, Vec3 position) {
        this(type, world);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.m_19915_(0.0f, 0.0f);
    }

    public int getStackAmount() {
        return ((Byte[])this.f_19804_.m_135370_(STACK)).length;
    }

    public byte getTopStackID() {
        return this.getIDAt(this.getStackAmount() - 1);
    }

    public byte getIDAt(int index) {
        if (index >= 0 && index < this.getStackAmount()) {
            return ((Byte[])this.f_19804_.m_135370_(STACK))[index];
        }
        return 0;
    }

    public void removeFromTop() {
        Byte[] newStack = new Byte[this.getStackAmount() - 1];
        for (int index = 0; index < newStack.length; ++index) {
            newStack[index] = ((Byte[])this.f_19804_.m_135370_(STACK))[index];
        }
        this.f_19804_.m_135381_(STACK, (Object)newStack);
    }

    public void addToTop(byte id) {
        Byte[] newStack = new Byte[this.getStackAmount() + 1];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.f_19804_.m_135370_(STACK))[index];
        }
        newStack[newStack.length - 1] = id;
        this.f_19804_.m_135381_(STACK, (Object)newStack);
    }

    public void createStack() {
        Byte[] newStack = new Byte[]{};
        this.f_19804_.m_135381_(STACK, (Object)newStack);
    }

    public void shuffleStack() {
        Object[] newStack = new Byte[this.getStackAmount()];
        for (int index = 0; index < this.getStackAmount(); ++index) {
            newStack[index] = ((Byte[])this.f_19804_.m_135370_(STACK))[index];
        }
        ArrayHelper.shuffle(newStack);
        this.f_19804_.m_135381_(STACK, (Object)newStack);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.f_19794_ = false;
        } else {
            boolean bl = this.f_19794_ = !this.m_9236_().m_45786_((Entity)this);
            if (this.f_19794_) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.02, 0.0));
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 pos = this.m_20182_();
        double size = 0.2;
        double addAmount = 0.0045;
        this.m_20011_(new AABB(pos.f_82479_ - size, pos.f_82480_, pos.f_82481_ - size, pos.f_82479_ + size, pos.f_82480_ + 0.03 + addAmount * (double)this.getStackAmount(), pos.f_82481_ + size));
    }

    public abstract void moreData();

    protected void m_8097_() {
        this.f_19804_.m_135372_(STACK, (Object)new Byte[0]);
        this.moreData();
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.f_19804_.m_135381_(STACK, (Object)ArrayHelper.toObject(compoundTag.m_128463_("Stack")));
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128382_("Stack", ArrayHelper.toPrimitive((Byte[])this.f_19804_.m_135370_(STACK)));
    }

    public boolean m_6087_() {
        return true;
    }
}

