/*
 * Decompiled with CFR 0.152.
 */
package com.ombremoon.playingcards.entity;

import com.ombremoon.playingcards.entity.EntityCardDeck;
import com.ombremoon.playingcards.entity.base.EntityStacked;
import com.ombremoon.playingcards.init.InitEntityTypes;
import com.ombremoon.playingcards.init.InitItems;
import com.ombremoon.playingcards.item.ItemCardCovered;
import com.ombremoon.playingcards.util.ChatHelper;
import com.ombremoon.playingcards.util.ItemHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityCard
extends EntityStacked {
    private static final EntityDataAccessor<Float> ROTATION = SynchedEntityData.m_135353_(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> SKIN_ID = SynchedEntityData.m_135353_(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DECK_UUID = SynchedEntityData.m_135353_(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> COVERED = SynchedEntityData.m_135353_(EntityCard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityCard(EntityType<? extends EntityCard> type, Level world) {
        super(type, world);
    }

    public EntityCard(Level world, Vec3 position, float rotation, byte skinID, UUID deckUUID, boolean covered, byte firstCardID) {
        super((EntityType<? extends EntityStacked>)((EntityType)InitEntityTypes.CARD.get()), world, position);
        this.createStack();
        this.addToTop(firstCardID);
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(rotation));
        this.f_19804_.m_135381_(SKIN_ID, (Object)skinID);
        this.f_19804_.m_135381_(DECK_UUID, Optional.of(deckUUID));
        this.f_19804_.m_135381_(COVERED, (Object)covered);
    }

    public float getRotation() {
        return ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue();
    }

    public byte getSkinID() {
        return (Byte)this.f_19804_.m_135370_(SKIN_ID);
    }

    public UUID getDeckUUID() {
        return ((Optional)this.f_19804_.m_135370_(DECK_UUID)).isPresent() ? (UUID)((Optional)this.f_19804_.m_135370_(DECK_UUID)).get() : null;
    }

    public boolean isCover() {
        return (Boolean)this.f_19804_.m_135370_(COVERED);
    }

    private void takeCard(Player player) {
        ItemStack card = new ItemStack((ItemLike)InitItems.CARD.get());
        if (((Boolean)this.f_19804_.m_135370_(COVERED)).booleanValue()) {
            card = new ItemStack((ItemLike)InitItems.CARD_COVERED.get());
        }
        card.m_41721_((int)this.getTopStackID());
        ItemHelper.getNBT(card).m_128362_("UUID", this.getDeckUUID());
        ItemHelper.getNBT(card).m_128344_("SkinID", ((Byte)this.f_19804_.m_135370_(SKIN_ID)).byteValue());
        ItemHelper.getNBT(card).m_128379_("Covered", ((Boolean)this.f_19804_.m_135370_(COVERED)).booleanValue());
        if (!this.m_9236_().f_46443_) {
            ItemHelper.spawnStackAtEntity(this.m_9236_(), (Entity)player, card);
        }
        this.removeFromTop();
        if (this.getStackAmount() <= 0) {
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 20L == 0L) {
            BlockPos pos = this.m_20183_();
            List closeDecks = this.m_9236_().m_45976_(EntityCardDeck.class, new AABB((double)(pos.m_123341_() - 20), (double)(pos.m_123342_() - 20), (double)(pos.m_123343_() - 20), (double)(pos.m_123341_() + 20), (double)(pos.m_123342_() + 20), (double)(pos.m_123343_() + 20)));
            boolean foundParentDeck = false;
            for (EntityCardDeck closeDeck : closeDecks) {
                if (!this.getDeckUUID().equals(closeDeck.m_20148_())) continue;
                foundParentDeck = true;
            }
            if (!foundParentDeck) {
                this.m_146870_();
            }
            super.onRemovedFromWorld();
        }
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (stack.m_41720_() instanceof ItemCardCovered) {
            if (this.getStackAmount() < 52) {
                this.addToTop((byte)stack.m_41773_());
                stack.m_41774_(1);
            } else if (this.m_9236_().f_46443_) {
                ChatHelper.printModMessage(ChatFormatting.RED, Component.m_237115_((String)"message.stack_full"), new Entity[]{pPlayer});
            }
        } else {
            this.takeCard(pPlayer);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.f_19804_.m_135381_(COVERED, (Object)((Boolean)this.f_19804_.m_135370_(COVERED) == false ? 1 : 0));
        return true;
    }

    @Override
    public void moreData() {
        this.f_19804_.m_135372_(ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SKIN_ID, (Object)0);
        this.f_19804_.m_135372_(DECK_UUID, Optional.empty());
        this.f_19804_.m_135372_(COVERED, (Object)false);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(ROTATION, (Object)Float.valueOf(compoundTag.m_128457_("Rotation")));
        this.f_19804_.m_135381_(SKIN_ID, (Object)compoundTag.m_128445_("SkinID"));
        this.f_19804_.m_135381_(DECK_UUID, Optional.of(compoundTag.m_128342_("DeckID")));
        this.f_19804_.m_135381_(COVERED, (Object)compoundTag.m_128471_("Covered"));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128350_("Rotation", ((Float)this.f_19804_.m_135370_(ROTATION)).floatValue());
        compoundTag.m_128344_("SkinID", ((Byte)this.f_19804_.m_135370_(SKIN_ID)).byteValue());
        compoundTag.m_128362_("DeckID", this.getDeckUUID());
        compoundTag.m_128379_("Covered", ((Boolean)this.f_19804_.m_135370_(COVERED)).booleanValue());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

