/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.platforms.Roster;
import shetiphian.platforms.common.item.ItemBlockPlatform;
import shetiphian.platforms.common.misc.EnumCovering;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class TileEntityPlatformRailing
extends TileEntityPlatformBase {
    private boolean linkedToRamp = false;
    private boolean linkedToFloor = false;
    private boolean isRail = false;

    public TileEntityPlatformRailing(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.RISE.get(), pos, state);
    }

    @Override
    protected void buildNBT(CompoundTag nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.m_128379_("linkedToRamp", this.linkedToRamp);
        nbtTag.m_128379_("linkedToFloor", this.linkedToFloor);
        nbtTag.m_128379_("isRail", this.isRail);
    }

    @Override
    protected void processNBT(CompoundTag nbtTag) {
        super.processNBT(nbtTag);
        this.linkedToRamp = nbtTag.m_128471_("linkedToRamp");
        this.linkedToFloor = nbtTag.m_128471_("linkedToFloor");
        this.isRail = nbtTag.m_128471_("isRail");
    }

    @Override
    public void setTextureInfo(ItemStack stack) {
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform) {
            this.setFrameTextureBlock(ItemBlockPlatform.getFrameTextureStack(stack));
            this.setCoverTextureBlock(ItemBlockPlatform.getCoverTextureStack(stack));
            this.isRail = ((ItemBlockPlatform)stack.m_41720_()).getPlatformType() == EnumPlatformType.RAIL;
        }
    }

    @Override
    protected boolean canApplyCovering(EnumCovering covering) {
        return covering.renderOnRails() && super.canApplyCovering(covering);
    }

    public void setLinkedToRamp(boolean linkToRamp) {
        this.linkedToRamp = linkToRamp;
    }

    public boolean isLinkedToRamp() {
        return this.linkedToRamp;
    }

    public void setLinkedToFloor(boolean linkedToFloor) {
        this.linkedToFloor = linkedToFloor;
    }

    public boolean isLinkedToFloor() {
        return this.linkedToFloor;
    }

    public boolean isLinked() {
        return this.isLinkedToFloor() || this.isLinkedToRamp();
    }

    public boolean isRail() {
        return this.isRail;
    }
}

