/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.ToolHelper;
import shetiphian.core.common.UseContext;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.misc.TextureInfoHelper;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.block.BlockPlatformBase;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class ItemBlockPlatform
extends BlockItem
implements ITabFiller,
IColored {
    private final EnumPlatformType platformType;

    public ItemBlockPlatform(EnumPlatformType platformType, Block block, Item.Properties properties) {
        super(block, properties);
        this.platformType = platformType;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        entries.m_246342_(ItemBlockPlatform.createStack(this.m_40614_(), new ItemStack((ItemLike)Blocks.f_50705_), new ItemStack((ItemLike)Blocks.f_50705_)));
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        CompoundTag texture;
        ItemStack textureStack;
        CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
        if (!tag.m_128441_(ItemBlockPlatform.getFrameTextureKey())) {
            textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getFrameTextureKey(), (Tag)texture);
        }
        if (!tag.m_128441_(ItemBlockPlatform.getCoverTextureKey())) {
            textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getCoverTextureKey(), (Tag)texture);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Optional<BlockPos> optional;
        InteractionResultHolder<BlockPos> holder;
        Direction face;
        BlockPos pos;
        Level world;
        Player player = context.m_43723_();
        if (ItemBlockPlatform.canExtend(this.platformType, player, world = context.m_43725_(), pos = context.m_8083_(), face = context.m_43719_()) && (holder = ItemBlockPlatform.getExtensionPos(this.platformType, player, world, pos, face)).m_19089_() != InteractionResult.PASS) {
            if (holder.m_19089_() == InteractionResult.SUCCESS) {
                BlockPos extPos = (BlockPos)holder.m_19095_();
                UseContext.Item extContext = new UseContext.Item(world, player, context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), Direction.UP, extPos, context.m_43721_()));
                InteractionResult actionResult = this.m_40576_(new BlockPlaceContext((UseOnContext)extContext));
                if (actionResult.m_19077_()) {
                    BlockState state = world.m_8055_(pos);
                    BlockState extState = world.m_8055_(extPos);
                    if (state.m_60734_() == extState.m_60734_() && state.m_60734_() instanceof BlockPlatformBase) {
                        Function.setBlock((LevelAccessor)world, (BlockPos)extPos, (BlockState)((BlockState)BlockPlatformBase.getStateWithPlatformSubType(extState, BlockPlatformBase.getPlatformSubType(state)).m_61124_((Property)BlockPlatformBase.FACING, (Comparable)((Direction)state.m_61143_((Property)BlockPlatformBase.FACING)))), (boolean)true);
                    }
                    return actionResult;
                }
            }
            return InteractionResult.FAIL;
        }
        if (ItemBlockPlatform.canDropRamp(this.platformType, player, face) && (optional = ItemBlockPlatform.getRampDropPos(player, world, pos)).isPresent()) {
            BlockPos placePos = optional.get();
            UseContext.Item extContext = new UseContext.Item(world, context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), Direction.UP, placePos, context.m_43721_()));
            InteractionResult actionResult = this.m_40576_(new BlockPlaceContext((UseOnContext)extContext));
            if (actionResult.m_19077_()) {
                BlockState state = world.m_8055_(placePos);
                if (state.m_60734_() instanceof BlockPlatformBase) {
                    EnumSubType subType = BlockPlatformBase.getPlatformSubType(state = (BlockState)state.m_61124_((Property)BlockPlatformBase.FACING, (Comparable)((Direction)state.m_61143_((Property)BlockPlatformBase.FACING)).m_122424_()));
                    state = BlockPlatformBase.getStateWithPlatformSubType(state, subType == EnumSubType.RIGHT ? EnumSubType.LEFT : (subType == EnumSubType.LEFT ? EnumSubType.RIGHT : EnumSubType.MIDDLE));
                    Function.setBlock((LevelAccessor)world, (BlockPos)placePos, (BlockState)state, (boolean)true);
                }
                return actionResult;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    public static boolean canExtend(EnumPlatformType platformType, Player player, Level world, BlockPos pos, Direction face) {
        BlockPlatformBase platform;
        BlockState state;
        Block block;
        if (player != null && !player.m_6144_() && ToolHelper.isWrench((ItemStack)player.m_21206_()) && (block = (state = world.m_8055_(pos)).m_60734_()) instanceof BlockPlatformBase && (platform = (BlockPlatformBase)block).getPlatformType() == platformType) {
            return switch (platformType) {
                default -> throw new IncompatibleClassChangeError();
                case EnumPlatformType.FLAT, EnumPlatformType.FLOOR -> {
                    if (face == Direction.UP) {
                        yield true;
                    }
                    yield false;
                }
                case EnumPlatformType.FRAME -> true;
                case EnumPlatformType.RAIL, EnumPlatformType.RISE -> false;
                case EnumPlatformType.RAMP, EnumPlatformType.STAIRS, EnumPlatformType.STEPS, EnumPlatformType.SHINGLES, EnumPlatformType.TILES -> {
                    if (face == Direction.UP) {
                        yield true;
                    }
                    Direction platformFacing = (Direction)state.m_61143_((Property)BlockPlatformBase.FACING);
                    if (face == platformFacing.m_122424_() && platformFacing.m_122434_() == player.m_6350_().m_122434_()) {
                        yield true;
                    }
                    yield false;
                }
            };
        }
        return false;
    }

    public static InteractionResultHolder<BlockPos> getExtensionPos(EnumPlatformType platformType, Player player, Level world, BlockPos pos, Direction face) {
        BlockPlatformBase platform;
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BlockPlatformBase && (platform = (BlockPlatformBase)block).getPlatformType() == platformType && BlockPlatformBase.getPlatformSubType(state).getBaseType() == EnumSubType.EnumBase.NORMAL) {
            Direction playerFacing = player.m_6350_();
            Direction platformFacing = (Direction)state.m_61143_((Property)BlockPlatformBase.FACING);
            if (!platformType.isInclineOrRoof() || platformFacing.m_122434_() == playerFacing.m_122434_()) {
                BlockPos.MutableBlockPos sPos = pos.m_122032_();
                int counter = 0;
                while (counter < 16) {
                    BlockPlatformBase sPlatform;
                    ++counter;
                    switch (platformType) {
                        case FLAT: 
                        case FLOOR: {
                            sPos.m_122173_(playerFacing);
                            break;
                        }
                        case FRAME: {
                            sPos.m_122173_(face == Direction.UP ? playerFacing : Direction.UP);
                            break;
                        }
                        case RAIL: 
                        case RISE: {
                            return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
                        }
                        case RAMP: 
                        case STAIRS: 
                        case STEPS: 
                        case SHINGLES: 
                        case TILES: {
                            sPos.m_122173_(playerFacing).m_122173_(playerFacing == platformFacing ? Direction.UP : Direction.DOWN);
                        }
                    }
                    BlockState sState = world.m_8055_((BlockPos)sPos);
                    if (sState.m_247087_()) {
                        return InteractionResultHolder.m_19090_((Object)sPos.m_7949_());
                    }
                    Block block2 = sState.m_60734_();
                    if (block2 instanceof BlockPlatformBase && (sPlatform = (BlockPlatformBase)block2).getPlatformType() == platformType) continue;
                }
                return InteractionResultHolder.m_19100_((Object)BlockPos.f_121853_);
            }
        }
        return InteractionResultHolder.m_19098_((Object)BlockPos.f_121853_);
    }

    public static boolean canDropRamp(EnumPlatformType platformType, Player player, Direction face) {
        return player != null && !player.m_6144_() && ToolHelper.isWrench((ItemStack)player.m_21206_()) && platformType.isInclineOrRoof() && face == Direction.UP;
    }

    public static Optional<BlockPos> getRampDropPos(Player player, Level world, BlockPos pos) {
        BlockPos.MutableBlockPos placePos = pos.m_122032_().m_122173_(player.m_6350_());
        if (world.m_8055_(pos).m_247087_()) {
            placePos.m_122173_(Direction.DOWN);
        }
        if (world.m_8055_((BlockPos)placePos).m_247087_()) {
            return Optional.of(placePos.m_7949_());
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!stack.m_41619_()) {
            if (advancedTooltips.m_7050_() || Screen.m_96638_()) {
                CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
                TextureInfoHelper.addTextureInfo(tooltip, tag, ItemBlockPlatform.getFrameTextureKey());
                TextureInfoHelper.addTextureInfo(tooltip, tag, ItemBlockPlatform.getCoverTextureKey());
            } else {
                tooltip.add((Component)Component.m_237115_((String)"info.shetiphian.holdshift"));
            }
        }
    }

    public static ItemStack createStack(EnumPlatformType platformType, ItemStack textures) {
        return ItemBlockPlatform.createStack(platformType, ItemBlockPlatform.getFrameTextureStack(textures), ItemBlockPlatform.getCoverTextureStack(textures));
    }

    public static ItemStack createStack(EnumPlatformType platformType, ItemStack texFrame, ItemStack texCover) {
        return ItemBlockPlatform.createStack(Values.getPlatform(platformType), texFrame, texCover);
    }

    public static ItemStack createStack(Block block, ItemStack texFrame, ItemStack texCover) {
        ItemStack stack;
        if (block != null && !(stack = new ItemStack((ItemLike)block)).m_41619_()) {
            CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
            if (texFrame.m_41619_()) {
                texFrame = new ItemStack((ItemLike)Blocks.f_50705_);
            }
            CompoundTag texture = new CompoundTag();
            texFrame.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getFrameTextureKey(), (Tag)texture);
            if (texCover.m_41619_()) {
                texCover = new ItemStack((ItemLike)Blocks.f_50705_);
            }
            texture = new CompoundTag();
            texCover.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getCoverTextureKey(), (Tag)texture);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getFrameTextureStack(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_(ItemBlockPlatform.getFrameTextureKey())) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockPlatform.getFrameTextureKey()));
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }

    public static ItemStack getCoverTextureStack(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_(ItemBlockPlatform.getCoverTextureKey())) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockPlatform.getCoverTextureKey()));
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }

    public static void setSubType(ItemStack stack, EnumSubType subtype) {
        if (!stack.m_41619_()) {
            CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
            tag.m_128359_("subtype", subtype.m_7912_());
        }
    }

    public static EnumSubType getSubType(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_("subtype")) {
            return EnumSubType.byName(tag.m_128461_("subtype"));
        }
        return EnumSubType.NONE;
    }

    public static String getFrameTextureKey() {
        return "frame_texture_item";
    }

    public static String getCoverTextureKey() {
        return "cover_texture_item";
    }

    public static CompoundTag getNBTTag(ItemStack stack) {
        return stack.m_41698_("BlockEntityTag");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index >= 1 && index <= 4) {
            return Minecraft.m_91087_().getItemColors().m_92676_(index == 1 || index == 3 ? ItemBlockPlatform.getFrameTextureStack(data.stack) : ItemBlockPlatform.getCoverTextureStack(data.stack), 0);
        }
        return 0xFFFFFF;
    }
}

