/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.common.Function;
import shetiphian.core.common.TagHelper;
import shetiphian.core.common.ToolHelper;
import shetiphian.platforms.Configuration;
import shetiphian.platforms.common.block.BlockPlatformType;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumTorchType;
import shetiphian.platforms.common.misc.TileHelper;
import shetiphian.platforms.common.tileentity.TileEntityPlatformBase;

public class BlockPlatformFrame
extends BlockPlatformType.Singles {
    private static final VoxelShape SHAPE_CORE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_STEP = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_PLACE = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_FRAME = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)16.0, (double)3.0), Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0)});
    private static final VoxelShape SHAPE_AX = Shapes.m_83124_((VoxelShape)SHAPE_FRAME, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)1.0, (double)5.0, (double)16.0), Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)1.0), Block.m_49796_((double)0.0, (double)11.0, (double)15.0, (double)16.0, (double)14.0, (double)16.0)});
    private static final VoxelShape SHAPE_AZ = Shapes.m_83124_((VoxelShape)SHAPE_FRAME, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0), Block.m_49796_((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)5.0, (double)1.0), Block.m_49796_((double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)5.0, (double)16.0)});

    public BlockPlatformFrame() {
        super(EnumPlatformType.FRAME);
    }

    public boolean isScaffolding(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return ((Configuration.Menu_General.ClimbMode)((Object)Configuration.GENERAL.frameClimbMode.get())).sneakDescend();
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Configuration.Menu_General.ClimbMode climbMode = (Configuration.Menu_General.ClimbMode)((Object)Configuration.GENERAL.frameClimbMode.get());
        if (climbMode == Configuration.Menu_General.ClimbMode.NONE) {
            return Shapes.m_83144_();
        }
        if (climbMode.sneakDescend() && !context.m_6513_(SHAPE_CORE, pos, true) && context.m_6513_(SHAPE_STEP, pos, true) && !context.m_6226_()) {
            return SHAPE_STEP;
        }
        return climbMode == Configuration.Menu_General.ClimbMode.SCAFFOLD ? Shapes.m_83040_() : SHAPE_CORE;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        Entity entity;
        if (context.m_7142_(this.m_5456_())) {
            return SHAPE_PLACE;
        }
        if (context instanceof EntityCollisionContext && (entity = (entityContext = (EntityCollisionContext)context).m_193113_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                if (!ToolHelper.isWrench((ItemStack)living.m_21120_(hand))) continue;
                return SHAPE_PLACE;
            }
        }
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? SHAPE_AX : SHAPE_AZ;
    }

    @Override
    public InteractionResult onBlockActivated(ItemStack heldItem, TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean isGlowstone = TagHelper.isItemInTag((ItemStack)heldItem, (String)"forge:dusts/glowstone");
        if (isGlowstone || EnumTorchType.isTorchItem(heldItem.m_41720_())) {
            EnumTorchType torch;
            boolean placed = false;
            if (!TileHelper.hasTorch(tile) && !isGlowstone) {
                if (heldItem.m_41720_() == Items.f_41978_) {
                    placed = TileHelper.setTorch(tile, this.isPowered((LevelReader)world, pos) ? EnumTorchType.REDSTONE_OFF : EnumTorchType.REDSTONE_ON);
                } else if (heldItem.m_41720_() == Items.f_42000_) {
                    placed = TileHelper.setTorch(tile, EnumTorchType.LIGHT);
                } else if (heldItem.m_41720_() == Items.f_42053_) {
                    placed = TileHelper.setTorch(tile, EnumTorchType.SOUL);
                }
            } else if (isGlowstone && (torch = TileHelper.getTorch(tile)) != null) {
                switch (torch) {
                    case REDSTONE_OFF: {
                        boolean bl = TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                        break;
                    }
                    case REDSTONE_ON: {
                        boolean bl = TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                        break;
                    }
                    case LIGHT: {
                        boolean bl = TileHelper.setTorch(tile, EnumTorchType.GLOWSTONE);
                        break;
                    }
                    case SOUL: {
                        boolean bl = TileHelper.setTorch(tile, EnumTorchType.SOULSTONE);
                        break;
                    }
                    default: {
                        boolean bl = placed = placed;
                    }
                }
            }
            if (placed) {
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                world.m_5594_(player, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
                world.m_46672_(pos, (Block)this);
                if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                    world.m_46672_(pos.m_7494_(), (Block)this);
                }
                Function.syncTile((BlockEntity)tile);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.onBlockActivated(heldItem, tile, state, world, pos, player, hand, hit);
    }

    @Override
    protected void updateBlock(TileEntityPlatformBase tile, BlockState state, Level world, BlockPos pos) {
        if (TileHelper.hasTorch(tile)) {
            boolean notify = false;
            EnumTorchType torch = TileHelper.getTorch(tile);
            if (torch == EnumTorchType.REDSTONE_OFF || torch == EnumTorchType.REDSTONE_ON) {
                if (this.isPowered((LevelReader)world, pos)) {
                    if (torch != EnumTorchType.REDSTONE_OFF) {
                        TileHelper.setTorch(tile, EnumTorchType.REDSTONE_OFF);
                        notify = true;
                        Function.syncTile((BlockEntity)tile);
                    }
                } else if (torch != EnumTorchType.REDSTONE_ON) {
                    TileHelper.setTorch(tile, EnumTorchType.REDSTONE_ON);
                    notify = true;
                    Function.syncTile((BlockEntity)tile);
                }
            } else if (torch == EnumTorchType.LAMP_OFF || torch == EnumTorchType.LAMP_ON) {
                if (this.isPowered((LevelReader)world, pos)) {
                    if (torch != EnumTorchType.LAMP_ON) {
                        TileHelper.setTorch(tile, EnumTorchType.LAMP_ON);
                        notify = true;
                        Function.syncTile((BlockEntity)tile);
                    }
                } else if (torch != EnumTorchType.LAMP_OFF) {
                    TileHelper.setTorch(tile, EnumTorchType.LAMP_OFF);
                    notify = true;
                    Function.syncTile((BlockEntity)tile);
                }
            }
            if (notify) {
                world.m_46672_(pos, (Block)this);
                if (world.m_8055_(pos.m_7494_()).m_60734_() != this) {
                    world.m_46672_(pos.m_7494_(), (Block)this);
                }
            }
        }
    }

    private boolean isPowered(LevelReader world, BlockPos pos) {
        if (world.m_277075_(pos.m_7495_(), Direction.DOWN) > 0) {
            return true;
        }
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            TileEntityPlatformBase tile = BlockPlatformFrame.getTile((BlockGetter)world, pos.m_121945_(facing));
            if (TileHelper.hasTorch(tile) || world.m_277075_(pos.m_121945_(facing), facing) <= 1) continue;
            return true;
        }
        return false;
    }

    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side == Direction.DOWN ? this.m_6378_(state, world, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        TileEntityPlatformBase tile;
        if (side != Direction.UP && this.platformType == EnumPlatformType.FRAME && (tile = BlockPlatformFrame.getTile(world, pos)) != null) {
            EnumTorchType torch = TileHelper.getTorch(tile);
            return torch == EnumTorchType.REDSTONE_ON || torch == EnumTorchType.LAMP_ON ? (side == Direction.DOWN ? 15 : 1) : 0;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        EnumTorchType torch;
        TileEntityPlatformBase tile = BlockPlatformFrame.getTile((BlockGetter)world, pos);
        if (TileHelper.hasTorch(tile) && (torch = TileHelper.getTorch(tile)) != null) {
            double x = (float)pos.m_123341_() + 0.5f;
            double y = (float)pos.m_123342_() + 0.75f;
            double z = (float)pos.m_123343_() + 0.5f;
            switch (torch) {
                case REDSTONE_ON: 
                case LAMP_ON: {
                    world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x += (double)(rand.m_188501_() - 0.5f) * 0.2, y += (double)(rand.m_188501_() - 0.5f) * 0.2, z += (double)(rand.m_188501_() - 0.5f) * 0.2, 0.0, 0.0, 0.0);
                    break;
                }
                case LIGHT: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case SOUL: {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

