/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.njb.worldgen.trunk;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.njb.registry.NJBTrunkPlacers;
import dev.worldgen.njb.worldgen.util.SeededNoiseProvider;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_3542;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5216;
import net.minecraft.class_5819;
import net.minecraft.class_5820;

public class NoiseBasedStraight
extends class_5141 {
    public static final Codec<NoiseBasedStraight> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("minimum_height").forGetter(trunkPlacer -> trunkPlacer.minimumHeight), (App)Codec.intRange((int)0, (int)32).fieldOf("maximum_height").forGetter(trunkPlacer -> trunkPlacer.maximumHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_random").forGetter(trunkPlacer -> trunkPlacer.randomHeight), (App)SeededNoiseProvider.CODEC.fieldOf("noise_provider").forGetter(trunkPlacer -> trunkPlacer.noiseProvider), (App)TrunkType.CODEC.fieldOf("trunk_type").orElse((Object)TrunkType.DEFAULT).forGetter(trunkPlacer -> trunkPlacer.trunkType)).apply((Applicative)instance, NoiseBasedStraight::new));
    private final SeededNoiseProvider noiseProvider;
    private final class_5216 noiseSampler;
    private final int minimumHeight;
    private final int maximumHeight;
    private final int randomHeight;
    private final TrunkType trunkType;

    public NoiseBasedStraight(int minimumHeight, int maximumHeight, int randomHeight, SeededNoiseProvider noiseProvider, TrunkType trunkType) {
        super(minimumHeight, maximumHeight, randomHeight);
        this.minimumHeight = minimumHeight;
        this.maximumHeight = maximumHeight;
        this.randomHeight = randomHeight;
        this.trunkType = trunkType;
        this.noiseProvider = noiseProvider;
        this.noiseSampler = class_5216.method_38476((class_5819)new class_2919((class_5819)new class_5820(noiseProvider.seed)), (class_5216.class_5487)noiseProvider.noiseParameters);
    }

    protected class_5142<?> method_28903() {
        return NJBTrunkPlacers.NOISE_BASED_STRAIGHT;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        int k;
        class_2350.class_2351 oppositeAxis;
        NoiseBasedStraight.method_27400((class_3746)world, replacer, (class_5819)random, (class_2338)startPos.method_10074(), (class_4643)config);
        double i = this.noiseSampler.method_27406((double)startPos.method_10263() * (double)this.noiseProvider.xz_scale, (double)startPos.method_10264() * (double)this.noiseProvider.y_scale, (double)startPos.method_10260() * (double)this.noiseProvider.xz_scale);
        int trunkHeight = Math.toIntExact(Math.min(Math.max(Math.round((double)((float)(this.maximumHeight - this.minimumHeight) / 2.0f) * i + (double)((float)(this.minimumHeight + this.maximumHeight) / 2.0f)), (long)this.minimumHeight), (long)this.maximumHeight)) + random.method_43048(this.randomHeight + 1);
        if (this.trunkType == TrunkType.DEFAULT) {
            for (int k2 = 0; k2 < trunkHeight; ++k2) {
                this.method_35375(world, replacer, random, startPos.method_10086(k2), config);
            }
            return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(trunkHeight), 0, false));
        }
        int halfHeight = (int)Math.ceil((double)trunkHeight / 2.0);
        for (int k3 = 0; k3 < halfHeight + 1; ++k3) {
            this.method_35375(world, replacer, random, startPos.method_10086(k3), config);
        }
        boolean r = random.method_43056();
        boolean hasDoubleBranches = random.method_43056();
        int offset = random.method_43056() ? 1 : -1;
        int offset2 = random.method_43056() ? 1 : -1;
        class_2350.class_2351 axis = random.method_43056() ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        class_2350.class_2351 class_23512 = oppositeAxis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        if (r) {
            int k4;
            for (k4 = halfHeight; k4 < trunkHeight; ++k4) {
                this.method_35375(world, replacer, random, startPos.method_10086(k4).method_30513(axis, offset), config);
            }
            if (hasDoubleBranches) {
                for (k4 = halfHeight; k4 < trunkHeight; ++k4) {
                    this.method_35375(world, replacer, random, startPos.method_10086(k4).method_30513(axis, offset * -1), config);
                }
                return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset), 0, false), (Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset * -1), 0, false));
            }
            return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset), 0, false));
        }
        for (k = halfHeight; k < trunkHeight; ++k) {
            this.method_35375(world, replacer, random, startPos.method_10086(k).method_30513(axis, offset).method_30513(oppositeAxis, offset2), config);
        }
        if (hasDoubleBranches) {
            for (k = halfHeight; k < trunkHeight; ++k) {
                this.method_35375(world, replacer, random, startPos.method_10086(k).method_30513(axis, offset * -1).method_30513(oppositeAxis, offset2 * -1), config);
            }
            return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset).method_30513(oppositeAxis, offset2), 0, false), (Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset * -1).method_30513(oppositeAxis, offset2 * -1), 0, false));
        }
        return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(trunkHeight - 1).method_30513(axis, offset).method_30513(oppositeAxis, offset2), 0, false));
    }

    public static enum TrunkType implements class_3542
    {
        TECTONIC_OAK("tectonic_oak"),
        DEFAULT("default");

        public static final class_3542.class_7292<TrunkType> CODEC;
        private final String name;

        private TrunkType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(TrunkType::values);
        }
    }
}

