/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.njb.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class NJBBiomeModifications {
    private static final class_6862<class_1959> OAK_FOREST = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("njb", "oak_forest"));
    private static final class_6862<class_1959> CHERRY = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960("njb", "cherry"));
    private static final List<String> birchFeatures = Arrays.asList("fallen_log", "block_patch", "rock");
    private static final List<String> forestFeatures = Arrays.asList("fallen_log", "block_patch", "rock");
    private static final List<String> taigaFeatures = Arrays.asList("fallen_log", "block_patch", "rock");
    private static final List<String> cherryFeatures = Arrays.asList("azalea_bush", "bamboo_cherry", "flowers_cherry", "rock_cherry", "block_patch");
    private static final List<String> swampFeatures = Arrays.asList("mud_pools", "blue_orchids", "disk_mud");
    private static final class_5321<class_6796> DESERT_DUNGEON = NJBBiomeModifications.getRegistryKeyWithPath("dungeon/desert");
    public static final class_5321<class_6796> JUNGLE_DUNGEON = NJBBiomeModifications.getRegistryKeyWithPath("dungeon/jungle");
    public static final class_5321<class_6796> BADLANDS_DUNGEON = NJBBiomeModifications.getRegistryKeyWithPath("dungeon/badlands");
    public static final class_5321<class_6796> MOUNTAIN_DUNGEON = NJBBiomeModifications.getRegistryKeyWithPath("dungeon/mountain");
    public static final class_5321<class_6796> FROZEN_WELL = NJBBiomeModifications.getRegistryKeyWithModuleAndPath("well/", "frozen");
    public static final class_5321<class_6796> BADLANDS_WELL = NJBBiomeModifications.getRegistryKeyWithModuleAndPath("well/", "badlands");
    public static final class_5321<class_6796> EMERALD_ORE_VEIN = NJBBiomeModifications.getRegistryKeyWithModuleAndPath("ore_vein/", "emerald");
    public static final class_5321<class_6796> GOLD_ORE_VEIN = NJBBiomeModifications.getRegistryKeyWithModuleAndPath("ore_vein/", "gold");
    public static final class_5321<class_6796> NETHER_GOLD_ORE_VEIN = NJBBiomeModifications.getRegistryKeyWithModuleAndPath("ore_vein/", "nether_gold");

    public static class_5321<class_6796> getRegistryKeyWithPath(String path) {
        return class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("njb", path));
    }

    public static class_5321<class_6796> getRegistryKeyWithModuleAndPath(String moduleFolder, String path) {
        return class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("njb", moduleFolder.concat(path)));
    }

    public static void placeModuleFeatures(List<String> features, class_6862<class_1959> biomeTagKey, String moduleFolder) {
        for (String feature : features) {
            BiomeModifications.addFeature((Predicate)BiomeSelectors.tag(biomeTagKey), (class_2893.class_2895)class_2893.class_2895.field_13178, NJBBiomeModifications.getRegistryKeyWithModuleAndPath(moduleFolder, feature));
        }
    }

    public static void placeFeaturesInWorld() {
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.DESERT), (class_2893.class_2895)class_2893.class_2895.field_13172, DESERT_DUNGEON);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.JUNGLE), (class_2893.class_2895)class_2893.class_2895.field_13172, JUNGLE_DUNGEON);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.BADLANDS), (class_2893.class_2895)class_2893.class_2895.field_13172, BADLANDS_DUNGEON);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.MOUNTAIN), (class_2893.class_2895)class_2893.class_2895.field_13172, MOUNTAIN_DUNGEON);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.SNOWY), (class_2893.class_2895)class_2893.class_2895.field_13173, FROZEN_WELL);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.BADLANDS), (class_2893.class_2895)class_2893.class_2895.field_13173, BADLANDS_WELL);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.MOUNTAIN), (class_2893.class_2895)class_2893.class_2895.field_13176, EMERALD_ORE_VEIN);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.tag((class_6862)ConventionalBiomeTags.BADLANDS), (class_2893.class_2895)class_2893.class_2895.field_13176, GOLD_ORE_VEIN);
        BiomeModifications.addFeature((Predicate)BiomeSelectors.foundInTheNether(), (class_2893.class_2895)class_2893.class_2895.field_13176, NETHER_GOLD_ORE_VEIN);
        NJBBiomeModifications.placeModuleFeatures(birchFeatures, (class_6862<class_1959>)ConventionalBiomeTags.BIRCH_FOREST, "birch_forest/");
        NJBBiomeModifications.placeModuleFeatures(cherryFeatures, CHERRY, "cherry_grove/");
        NJBBiomeModifications.placeModuleFeatures(forestFeatures, OAK_FOREST, "forest/");
        NJBBiomeModifications.placeModuleFeatures(taigaFeatures, (class_6862<class_1959>)ConventionalBiomeTags.TAIGA, "taiga/");
        NJBBiomeModifications.placeModuleFeatures(swampFeatures, (class_6862<class_1959>)ConventionalBiomeTags.SWAMP, "swamp/");
    }
}

