/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.njb.structure;

import com.google.common.collect.Lists;
import dev.worldgen.njb.registry.NJBStructurePieces;
import dev.worldgen.njb.worldgen.structure.MansionTemplates;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_39;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class AlternateMansionGenerator {
    public static void addPieces(class_3485 manager, class_2338 pos, class_2470 rotation, List<Piece> pieces, class_5819 random, MansionTemplates roomTemplates) {
        MansionParameters mansionParameters = new MansionParameters(random);
        LayoutGenerator layoutGenerator = new LayoutGenerator(manager, random, roomTemplates);
        layoutGenerator.generate(pos, rotation, pieces, mansionParameters);
    }

    private static class MansionParameters {
        private final class_5819 random;
        final FlagMatrix baseLayout;
        final FlagMatrix thirdFloorLayout;
        final FlagMatrix[] roomFlagsByFloor;
        final int entranceI;
        final int entranceJ;

        public MansionParameters(class_5819 random) {
            this.random = random;
            this.entranceI = 7;
            this.entranceJ = 4;
            this.baseLayout = new FlagMatrix(11, 11, 5);
            this.baseLayout.fill(this.entranceI, this.entranceJ, this.entranceI + 1, this.entranceJ + 1, 3);
            this.baseLayout.fill(this.entranceI - 1, this.entranceJ, this.entranceI - 1, this.entranceJ + 1, 2);
            this.baseLayout.fill(this.entranceI + 2, this.entranceJ - 2, this.entranceI + 3, this.entranceJ + 3, 5);
            this.baseLayout.fill(this.entranceI + 1, this.entranceJ - 2, this.entranceI + 1, this.entranceJ - 1, 1);
            this.baseLayout.fill(this.entranceI + 1, this.entranceJ + 2, this.entranceI + 1, this.entranceJ + 3, 1);
            this.baseLayout.set(this.entranceI - 1, this.entranceJ - 1, 1);
            this.baseLayout.set(this.entranceI - 1, this.entranceJ + 2, 1);
            this.baseLayout.fill(0, 0, 11, 1, 5);
            this.baseLayout.fill(0, 9, 11, 11, 5);
            this.layoutCorridor(this.baseLayout, this.entranceI, this.entranceJ - 2, class_2350.field_11039, 6);
            this.layoutCorridor(this.baseLayout, this.entranceI, this.entranceJ + 3, class_2350.field_11039, 6);
            this.layoutCorridor(this.baseLayout, this.entranceI - 2, this.entranceJ - 1, class_2350.field_11039, 3);
            this.layoutCorridor(this.baseLayout, this.entranceI - 2, this.entranceJ + 2, class_2350.field_11039, 3);
            while (this.adjustLayoutWithRooms(this.baseLayout)) {
            }
            this.roomFlagsByFloor = new FlagMatrix[3];
            this.roomFlagsByFloor[0] = new FlagMatrix(11, 11, 5);
            this.roomFlagsByFloor[1] = new FlagMatrix(11, 11, 5);
            this.roomFlagsByFloor[2] = new FlagMatrix(11, 11, 5);
            this.updateRoomFlags(this.baseLayout, this.roomFlagsByFloor[0]);
            this.updateRoomFlags(this.baseLayout, this.roomFlagsByFloor[1]);
            this.roomFlagsByFloor[0].fill(this.entranceI + 1, this.entranceJ, this.entranceI + 1, this.entranceJ + 1, 0x800000);
            this.roomFlagsByFloor[1].fill(this.entranceI + 1, this.entranceJ, this.entranceI + 1, this.entranceJ + 1, 0x800000);
            this.thirdFloorLayout = new FlagMatrix(this.baseLayout.n, this.baseLayout.m, 5);
            this.layoutThirdFloor();
            this.updateRoomFlags(this.thirdFloorLayout, this.roomFlagsByFloor[2]);
        }

        public static boolean isInsideMansion(FlagMatrix layout, int i, int j) {
            int k = layout.get(i, j);
            return k == 1 || k == 2 || k == 3 || k == 4;
        }

        public boolean isRoomId(FlagMatrix layout, int i, int j, int floor, int roomId) {
            return (this.roomFlagsByFloor[floor].get(i, j) & 0xFFFF) == roomId;
        }

        @Nullable
        public class_2350 findConnectedRoomDirection(FlagMatrix layout, int i, int j, int floor, int roomId) {
            class_2350 direction;
            Iterator var6 = class_2350.class_2353.field_11062.iterator();
            do {
                if (var6.hasNext()) continue;
                return null;
            } while (!this.isRoomId(layout, i + (direction = (class_2350)var6.next()).method_10148(), j + direction.method_10165(), floor, roomId));
            return direction;
        }

        private void layoutCorridor(FlagMatrix layout, int i, int j, class_2350 direction, int length) {
            if (length > 0) {
                class_2350 direction2;
                layout.set(i, j, 1);
                layout.update(i + direction.method_10148(), j + direction.method_10165(), 0, 1);
                for (int k = 0; k < 8; ++k) {
                    direction2 = class_2350.method_10139((int)this.random.method_43048(4));
                    if (direction2 == direction.method_10153() || direction2 == class_2350.field_11034 && this.random.method_43056()) continue;
                    int l = i + direction.method_10148();
                    int m = j + direction.method_10165();
                    if (layout.get(l + direction2.method_10148(), m + direction2.method_10165()) != 0 || layout.get(l + direction2.method_10148() * 2, m + direction2.method_10165() * 2) != 0) continue;
                    this.layoutCorridor(layout, i + direction.method_10148() + direction2.method_10148(), j + direction.method_10165() + direction2.method_10165(), direction2, length - 1);
                    break;
                }
                class_2350 direction3 = direction.method_10170();
                direction2 = direction.method_10160();
                layout.update(i + direction3.method_10148(), j + direction3.method_10165(), 0, 2);
                layout.update(i + direction2.method_10148(), j + direction2.method_10165(), 0, 2);
                layout.update(i + direction.method_10148() + direction3.method_10148(), j + direction.method_10165() + direction3.method_10165(), 0, 2);
                layout.update(i + direction.method_10148() + direction2.method_10148(), j + direction.method_10165() + direction2.method_10165(), 0, 2);
                layout.update(i + direction.method_10148() * 2, j + direction.method_10165() * 2, 0, 2);
                layout.update(i + direction3.method_10148() * 2, j + direction3.method_10165() * 2, 0, 2);
                layout.update(i + direction2.method_10148() * 2, j + direction2.method_10165() * 2, 0, 2);
            }
        }

        private boolean adjustLayoutWithRooms(FlagMatrix layout) {
            boolean bl = false;
            for (int i = 0; i < layout.m; ++i) {
                for (int j = 0; j < layout.n; ++j) {
                    if (layout.get(j, i) != 0) continue;
                    int k = 0;
                    k += MansionParameters.isInsideMansion(layout, j + 1, i) ? 1 : 0;
                    k += MansionParameters.isInsideMansion(layout, j - 1, i) ? 1 : 0;
                    k += MansionParameters.isInsideMansion(layout, j, i + 1) ? 1 : 0;
                    if ((k += MansionParameters.isInsideMansion(layout, j, i - 1) ? 1 : 0) >= 3) {
                        layout.set(j, i, 2);
                        bl = true;
                        continue;
                    }
                    if (k != 2) continue;
                    int l = 0;
                    l += MansionParameters.isInsideMansion(layout, j + 1, i + 1) ? 1 : 0;
                    l += MansionParameters.isInsideMansion(layout, j - 1, i + 1) ? 1 : 0;
                    l += MansionParameters.isInsideMansion(layout, j + 1, i - 1) ? 1 : 0;
                    if ((l += MansionParameters.isInsideMansion(layout, j - 1, i - 1) ? 1 : 0) > 1) continue;
                    layout.set(j, i, 2);
                    bl = true;
                }
            }
            return bl;
        }

        private void layoutThirdFloor() {
            int l;
            int j;
            ArrayList list = Lists.newArrayList();
            FlagMatrix flagMatrix = this.roomFlagsByFloor[1];
            for (int i = 0; i < this.thirdFloorLayout.m; ++i) {
                for (j = 0; j < this.thirdFloorLayout.n; ++j) {
                    int k = flagMatrix.get(j, i);
                    l = k & 0xF0000;
                    if (l != 131072 || (k & 0x200000) != 0x200000) continue;
                    list.add(new class_3545((Object)j, (Object)i));
                }
            }
            if (list.isEmpty()) {
                this.thirdFloorLayout.fill(0, 0, this.thirdFloorLayout.n, this.thirdFloorLayout.m, 5);
            } else {
                class_3545 pair = (class_3545)list.get(this.random.method_43048(list.size()));
                j = flagMatrix.get((Integer)pair.method_15442(), (Integer)pair.method_15441());
                flagMatrix.set((Integer)pair.method_15442(), (Integer)pair.method_15441(), j | 0x400000);
                class_2350 direction = this.findConnectedRoomDirection(this.baseLayout, (Integer)pair.method_15442(), (Integer)pair.method_15441(), 1, j & 0xFFFF);
                l = (Integer)pair.method_15442() + direction.method_10148();
                int m = (Integer)pair.method_15441() + direction.method_10165();
                for (int n = 0; n < this.thirdFloorLayout.m; ++n) {
                    for (int o = 0; o < this.thirdFloorLayout.n; ++o) {
                        if (!MansionParameters.isInsideMansion(this.baseLayout, o, n)) {
                            this.thirdFloorLayout.set(o, n, 5);
                            continue;
                        }
                        if (o == (Integer)pair.method_15442() && n == (Integer)pair.method_15441()) {
                            this.thirdFloorLayout.set(o, n, 3);
                            continue;
                        }
                        if (o != l || n != m) continue;
                        this.thirdFloorLayout.set(o, n, 3);
                        this.roomFlagsByFloor[2].set(o, n, 0x800000);
                    }
                }
                ArrayList list2 = Lists.newArrayList();
                for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                    if (this.thirdFloorLayout.get(l + direction2.method_10148(), m + direction2.method_10165()) != 0) continue;
                    list2.add(direction2);
                }
                if (list2.isEmpty()) {
                    this.thirdFloorLayout.fill(0, 0, this.thirdFloorLayout.n, this.thirdFloorLayout.m, 5);
                    flagMatrix.set((Integer)pair.method_15442(), (Integer)pair.method_15441(), j);
                } else {
                    class_2350 direction3 = (class_2350)list2.get(this.random.method_43048(list2.size()));
                    this.layoutCorridor(this.thirdFloorLayout, l + direction3.method_10148(), m + direction3.method_10165(), direction3, 4);
                    while (this.adjustLayoutWithRooms(this.thirdFloorLayout)) {
                    }
                }
            }
        }

        private void updateRoomFlags(FlagMatrix layout, FlagMatrix roomFlags) {
            int i;
            ObjectArrayList objectArrayList = new ObjectArrayList();
            for (i = 0; i < layout.m; ++i) {
                for (int j = 0; j < layout.n; ++j) {
                    if (layout.get(j, i) != 2) continue;
                    objectArrayList.add((Object)new class_3545((Object)j, (Object)i));
                }
            }
            class_156.method_43028((ObjectArrayList)objectArrayList, (class_5819)this.random);
            i = 10;
            ObjectListIterator var19 = objectArrayList.iterator();
            while (var19.hasNext()) {
                int l;
                class_3545 pair = (class_3545)var19.next();
                int k = (Integer)pair.method_15442();
                if (roomFlags.get(k, l = ((Integer)pair.method_15441()).intValue()) != 0) continue;
                int m = k;
                int n = k;
                int o = l;
                int p = l;
                int q = 65536;
                if (roomFlags.get(k + 1, l) == 0 && roomFlags.get(k, l + 1) == 0 && roomFlags.get(k + 1, l + 1) == 0 && layout.get(k + 1, l) == 2 && layout.get(k, l + 1) == 2 && layout.get(k + 1, l + 1) == 2) {
                    n = k + 1;
                    p = l + 1;
                    q = 262144;
                } else if (roomFlags.get(k - 1, l) == 0 && roomFlags.get(k, l + 1) == 0 && roomFlags.get(k - 1, l + 1) == 0 && layout.get(k - 1, l) == 2 && layout.get(k, l + 1) == 2 && layout.get(k - 1, l + 1) == 2) {
                    m = k - 1;
                    p = l + 1;
                    q = 262144;
                } else if (roomFlags.get(k - 1, l) == 0 && roomFlags.get(k, l - 1) == 0 && roomFlags.get(k - 1, l - 1) == 0 && layout.get(k - 1, l) == 2 && layout.get(k, l - 1) == 2 && layout.get(k - 1, l - 1) == 2) {
                    m = k - 1;
                    o = l - 1;
                    q = 262144;
                } else if (roomFlags.get(k + 1, l) == 0 && layout.get(k + 1, l) == 2) {
                    n = k + 1;
                    q = 131072;
                } else if (roomFlags.get(k, l + 1) == 0 && layout.get(k, l + 1) == 2) {
                    p = l + 1;
                    q = 131072;
                } else if (roomFlags.get(k - 1, l) == 0 && layout.get(k - 1, l) == 2) {
                    m = k - 1;
                    q = 131072;
                } else if (roomFlags.get(k, l - 1) == 0 && layout.get(k, l - 1) == 2) {
                    o = l - 1;
                    q = 131072;
                }
                int r = this.random.method_43056() ? m : n;
                int s = this.random.method_43056() ? o : p;
                int t = 0x200000;
                if (!layout.anyMatchAround(r, s, 1)) {
                    r = r == m ? n : m;
                    int n2 = s = s == o ? p : o;
                    if (!layout.anyMatchAround(r, s, 1)) {
                        int n3 = s = s == o ? p : o;
                        if (!layout.anyMatchAround(r, s, 1)) {
                            r = r == m ? n : m;
                            int n4 = s = s == o ? p : o;
                            if (!layout.anyMatchAround(r, s, 1)) {
                                t = 0;
                                r = m;
                                s = o;
                            }
                        }
                    }
                }
                for (int u = o; u <= p; ++u) {
                    for (int v = m; v <= n; ++v) {
                        if (v == r && u == s) {
                            roomFlags.set(v, u, 0x100000 | t | q | i);
                            continue;
                        }
                        roomFlags.set(v, u, q | i);
                    }
                }
                ++i;
            }
            return;
        }
    }

    private static class LayoutGenerator {
        private final class_3485 manager;
        private final class_5819 random;
        private final MansionTemplates roomTemplates;
        private int entranceI;
        private int entranceJ;

        public LayoutGenerator(class_3485 manager, class_5819 random, MansionTemplates roomTemplates) {
            this.manager = manager;
            this.random = random;
            this.roomTemplates = roomTemplates;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        public void generate(class_2338 pos, class_2470 rotation, List<Piece> pieces, MansionParameters parameters) {
            generationPiece = new GenerationPiece();
            generationPiece.position = pos;
            generationPiece.rotation = rotation;
            generationPiece.template = this.roomTemplates.walls.lowerWall;
            generationPiece2 = new GenerationPiece();
            this.addEntrance(pieces, generationPiece);
            generationPiece2.position = generationPiece.position.method_10086(8);
            generationPiece2.rotation = generationPiece.rotation;
            generationPiece2.template = this.roomTemplates.walls.upperWall;
            if (!pieces.isEmpty()) {
                // empty if block
            }
            flagMatrix = parameters.baseLayout;
            flagMatrix2 = parameters.thirdFloorLayout;
            this.entranceI = parameters.entranceI + 1;
            this.entranceJ = parameters.entranceJ + 1;
            i = parameters.entranceI + 1;
            j = parameters.entranceJ;
            this.addOuterWall(pieces, generationPiece, flagMatrix, class_2350.field_11035, this.entranceI, this.entranceJ, i, j);
            this.addOuterWall(pieces, generationPiece2, flagMatrix, class_2350.field_11035, this.entranceI, this.entranceJ, i, j);
            generationPiece3 = new GenerationPiece();
            generationPiece3.position = generationPiece.position.method_10086(19);
            generationPiece3.rotation = generationPiece.rotation;
            generationPiece3.template = this.roomTemplates.walls.upperWall;
            bl = false;
            for (k = 0; k < flagMatrix2.m && !bl; ++k) {
                for (l = flagMatrix2.n - 1; l >= 0 && !bl; --l) {
                    if (!MansionParameters.isInsideMansion(flagMatrix2, l, k)) continue;
                    generationPiece3.position = generationPiece3.position.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (k - this.entranceJ) * 8);
                    generationPiece3.position = generationPiece3.position.method_10079(rotation.method_10503(class_2350.field_11034), (l - this.entranceI) * 8);
                    this.addWallPiece(pieces, generationPiece3);
                    this.addOuterWall(pieces, generationPiece3, flagMatrix2, class_2350.field_11035, l, k, l, k);
                    bl = true;
                }
            }
            this.addRoof(pieces, pos.method_10086(16), rotation, flagMatrix, flagMatrix2);
            this.addRoof(pieces, pos.method_10086(27), rotation, flagMatrix2, null);
            if (!pieces.isEmpty()) {
                // empty if block
            }
            l = 0;
            block7: while (true) {
                block33: {
                    if (l >= 3) {
                        return;
                    }
                    switch (l) {
                        case 0: {
                            v0 = this.roomTemplates.firstFloor;
                            ** GOTO lbl52
                        }
                        case 1: {
                            v0 = this.roomTemplates.secondFloor;
                            ** GOTO lbl52
                        }
                        case 2: {
                            v0 = this.roomTemplates.thirdFloor;
lbl52:
                            // 3 sources

                            floor = v0;
                            blockPos = pos.method_10086(8 * l + (l == 2 ? 3 : 0));
                            flagMatrix3 = parameters.roomFlagsByFloor[l];
                            flagMatrix4 = l == 2 ? flagMatrix2 : flagMatrix;
                            string = l == 0 ? "carpet_south_1" : "carpet_south_2";
                            string2 = l == 0 ? "carpet_west_1" : "carpet_west_2";
                            break block33;
                        }
                    }
                    throw new IllegalStateException("Unexpected value: " + l);
                }
                for (m = 0; m < flagMatrix4.m; ++m) {
                    for (n = 0; n < flagMatrix4.n; ++n) {
                        if (flagMatrix4.get(n, m) != 1) continue;
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (m - this.entranceJ) * 8);
                        blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11034), (n - this.entranceI) * 8);
                        pieces.add(new Piece(this.roomTemplates, this.manager, "corridor_floor", blockPos2, rotation));
                        if (flagMatrix4.get(n, m - 1) == 1 || (flagMatrix3.get(n, m - 1) & 0x800000) == 0x800000) {
                            pieces.add(new Piece(this.roomTemplates, this.manager, "carpet_north", blockPos2.method_10079(rotation.method_10503(class_2350.field_11034), 1).method_10084(), rotation));
                        }
                        if (flagMatrix4.get(n + 1, m) == 1 || (flagMatrix3.get(n + 1, m) & 0x800000) == 0x800000) {
                            pieces.add(new Piece(this.roomTemplates, this.manager, "carpet_east", blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 1).method_10079(rotation.method_10503(class_2350.field_11034), 5).method_10084(), rotation));
                        }
                        if (flagMatrix4.get(n, m + 1) == 1 || (flagMatrix3.get(n, m + 1) & 0x800000) == 0x800000) {
                            pieces.add(new Piece(this.roomTemplates, this.manager, string, blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 5).method_10079(rotation.method_10503(class_2350.field_11039), 1), rotation));
                        }
                        if (flagMatrix4.get(n - 1, m) != 1 && (flagMatrix3.get(n - 1, m) & 0x800000) != 0x800000) continue;
                        pieces.add(new Piece(this.roomTemplates, this.manager, string2, blockPos2.method_10079(rotation.method_10503(class_2350.field_11039), 1).method_10079(rotation.method_10503(class_2350.field_11043), 1), rotation));
                    }
                }
                string3 = l == 0 ? "indoors_wall_1" : "indoors_wall_2";
                string4 = l == 0 ? "indoors_door_1" : "indoors_door_2";
                list = Lists.newArrayList();
                o = 0;
                while (true) {
                    if (o < flagMatrix4.m) {
                    } else {
                        ++l;
                        continue block7;
                    }
                    for (p = 0; p < flagMatrix4.n; ++p) {
                        v1 = bl2 = l == 2 && flagMatrix4.get(p, o) == 3;
                        if (flagMatrix4.get(p, o) != 2 && !bl2) continue;
                        q = flagMatrix3.get(p, o);
                        r = q & 983040;
                        s = q & 65535;
                        bl2 = bl2 != false && (q & 0x800000) == 0x800000;
                        list.clear();
                        if ((q & 0x200000) == 0x200000) {
                            for (class_2350 direction : class_2350.class_2353.field_11062) {
                                if (flagMatrix4.get(p + direction.method_10148(), o + direction.method_10165()) != 1) continue;
                                list.add(direction);
                            }
                        }
                        direction2 = null;
                        if (!list.isEmpty()) {
                            direction2 = (class_2350)list.get(this.random.method_43048(list.size()));
                        } else if ((q & 0x100000) == 0x100000) {
                            direction2 = class_2350.field_11036;
                        }
                        blockPos3 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (o - this.entranceJ) * 8);
                        blockPos3 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11034), -1 + (p - this.entranceI) * 8);
                        if (MansionParameters.isInsideMansion(flagMatrix4, p - 1, o) && !parameters.isRoomId(flagMatrix4, p - 1, o, l, s)) {
                            pieces.add(new Piece(this.roomTemplates, this.manager, direction2 == class_2350.field_11039 ? string4 : string3, blockPos3, rotation));
                        }
                        if (flagMatrix4.get(p + 1, o) == 1 && !bl2) {
                            blockPos4 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11034), 8);
                            pieces.add(new Piece(this.roomTemplates, this.manager, direction2 == class_2350.field_11034 ? string4 : string3, blockPos4, rotation));
                        }
                        if (MansionParameters.isInsideMansion(flagMatrix4, p, o + 1) && !parameters.isRoomId(flagMatrix4, p, o + 1, l, s)) {
                            blockPos4 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                            blockPos4 = blockPos4.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            pieces.add(new Piece(this.roomTemplates, this.manager, direction2 == class_2350.field_11035 ? string4 : string3, blockPos4, rotation.method_10501(class_2470.field_11463)));
                        }
                        if (flagMatrix4.get(p, o - 1) == 1 && !bl2) {
                            blockPos4 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            blockPos4 = blockPos4.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            pieces.add(new Piece(this.roomTemplates, this.manager, direction2 == class_2350.field_11043 ? string4 : string3, blockPos4, rotation.method_10501(class_2470.field_11463)));
                        }
                        if (r == 65536) {
                            this.addSmallRoom(pieces, blockPos3, rotation, direction2, floor);
                            continue;
                        }
                        if (r == 131072 && direction2 != null) {
                            direction3 = parameters.findConnectedRoomDirection(flagMatrix4, p, o, l, s);
                            bl3 = (q & 0x400000) == 0x400000;
                            this.addMediumRoom(pieces, blockPos3, rotation, direction3, direction2, floor, bl3);
                            continue;
                        }
                        if (r == 262144 && direction2 != null && direction2 != class_2350.field_11036) {
                            direction3 = direction2.method_10170();
                            if (!parameters.isRoomId(flagMatrix4, p + direction3.method_10148(), o + direction3.method_10165(), l, s)) {
                                direction3 = direction3.method_10153();
                            }
                            this.addBigRoom(pieces, blockPos3, rotation, direction3, direction2, floor);
                            continue;
                        }
                        if (r != 262144 || direction2 != class_2350.field_11036) continue;
                        this.addBigSecretRoom(pieces, blockPos3, rotation, floor);
                    }
                    ++o;
                }
                break;
            }
        }

        private void addOuterWall(List<Piece> pieces, GenerationPiece wallPiece, FlagMatrix layout, class_2350 direction, int startI, int startJ, int endI, int endJ) {
            int i = startI;
            int j = startJ;
            class_2350 direction2 = direction;
            do {
                if (!MansionParameters.isInsideMansion(layout, i + direction.method_10148(), j + direction.method_10165())) {
                    this.turnLeft(pieces, wallPiece);
                    direction = direction.method_10170();
                    if (i == endI && j == endJ && direction2 == direction) continue;
                    this.addWallPiece(pieces, wallPiece);
                    continue;
                }
                if (MansionParameters.isInsideMansion(layout, i + direction.method_10148(), j + direction.method_10165()) && MansionParameters.isInsideMansion(layout, i + direction.method_10148() + direction.method_10160().method_10148(), j + direction.method_10165() + direction.method_10160().method_10165())) {
                    this.turnRight(pieces, wallPiece);
                    i += direction.method_10148();
                    j += direction.method_10165();
                    direction = direction.method_10160();
                    continue;
                }
                if ((i += direction.method_10148()) == endI && (j += direction.method_10165()) == endJ && direction2 == direction) continue;
                this.addWallPiece(pieces, wallPiece);
            } while (i != endI || j != endJ || direction2 != direction);
        }

        private void addRoof(List<Piece> pieces, class_2338 pos, class_2470 rotation, FlagMatrix layout, @Nullable FlagMatrix nextFloorLayout) {
            class_2338 blockPos2;
            boolean bl;
            class_2338 blockPos;
            int j;
            int i;
            for (i = 0; i < layout.m; ++i) {
                for (j = 0; j < layout.n; ++j) {
                    blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (i - this.entranceJ) * 8);
                    blockPos = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), (j - this.entranceI) * 8);
                    boolean bl2 = bl = nextFloorLayout != null && MansionParameters.isInsideMansion(nextFloorLayout, j, i);
                    if (!MansionParameters.isInsideMansion(layout, j, i) || bl) continue;
                    pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roof, blockPos.method_10086(3), rotation, class_2415.field_11302));
                    if (!MansionParameters.isInsideMansion(layout, j + 1, i)) {
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofSide, blockPos2, rotation, class_2415.field_11302));
                    }
                    if (!MansionParameters.isInsideMansion(layout, j - 1, i)) {
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 0);
                        blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofSide, blockPos2, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                    }
                    if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofSide, blockPos2, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                    }
                    if (MansionParameters.isInsideMansion(layout, j, i + 1)) continue;
                    blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                    blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                    pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofSide, blockPos2, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                }
            }
            if (nextFloorLayout != null) {
                for (i = 0; i < layout.m; ++i) {
                    for (j = 0; j < layout.n; ++j) {
                        blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (i - this.entranceJ) * 8);
                        blockPos = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), (j - this.entranceI) * 8);
                        bl = MansionParameters.isInsideMansion(nextFloorLayout, j, i);
                        if (!MansionParameters.isInsideMansion(layout, j, i) || !bl) continue;
                        if (!MansionParameters.isInsideMansion(layout, j + 1, i)) {
                            blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallWall, blockPos2, rotation));
                        }
                        if (!MansionParameters.isInsideMansion(layout, j - 1, i)) {
                            blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                            blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallWall, blockPos2, rotation.method_10501(class_2470.field_11464)));
                        }
                        if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                            blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11039), 0);
                            blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallWall, blockPos2, rotation.method_10501(class_2470.field_11465)));
                        }
                        if (!MansionParameters.isInsideMansion(layout, j, i + 1)) {
                            blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                            blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallWall, blockPos2, rotation.method_10501(class_2470.field_11463)));
                        }
                        if (!MansionParameters.isInsideMansion(layout, j + 1, i)) {
                            if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                                blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                                blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11043), 2);
                                pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallCornerWall, blockPos2, rotation));
                            }
                            if (!MansionParameters.isInsideMansion(layout, j, i + 1)) {
                                blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 8);
                                blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                                pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallCornerWall, blockPos2, rotation.method_10501(class_2470.field_11463)));
                            }
                        }
                        if (MansionParameters.isInsideMansion(layout, j - 1, i)) continue;
                        if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                            blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11039), 2);
                            blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallCornerWall, blockPos2, rotation.method_10501(class_2470.field_11465)));
                        }
                        if (MansionParameters.isInsideMansion(layout, j, i + 1)) continue;
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                        blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 8);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.smallCornerWall, blockPos2, rotation.method_10501(class_2470.field_11464)));
                    }
                }
            }
            for (i = 0; i < layout.m; ++i) {
                for (j = 0; j < layout.n; ++j) {
                    class_2338 blockPos3;
                    blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (i - this.entranceJ) * 8);
                    blockPos = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), (j - this.entranceI) * 8);
                    boolean bl3 = bl = nextFloorLayout != null && MansionParameters.isInsideMansion(nextFloorLayout, j, i);
                    if (!MansionParameters.isInsideMansion(layout, j, i) || bl) continue;
                    if (!MansionParameters.isInsideMansion(layout, j + 1, i)) {
                        blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                        if (!MansionParameters.isInsideMansion(layout, j, i + 1)) {
                            blockPos3 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofCorner, blockPos3, rotation, class_2415.field_11302));
                        } else if (MansionParameters.isInsideMansion(layout, j + 1, i + 1)) {
                            blockPos3 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 5);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofInnerCorner, blockPos3, rotation, class_2415.field_11302));
                        }
                        if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofCorner, blockPos2, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                        } else if (MansionParameters.isInsideMansion(layout, j + 1, i - 1)) {
                            blockPos3 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 9);
                            blockPos3 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11043), 2);
                            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofInnerCorner, blockPos3, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                        }
                    }
                    if (MansionParameters.isInsideMansion(layout, j - 1, i)) continue;
                    blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11034), 0);
                    blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 0);
                    if (!MansionParameters.isInsideMansion(layout, j, i + 1)) {
                        blockPos3 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofCorner, blockPos3, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                    } else if (MansionParameters.isInsideMansion(layout, j - 1, i + 1)) {
                        blockPos3 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 8);
                        blockPos3 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11039), 3);
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofInnerCorner, blockPos3, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                    }
                    if (!MansionParameters.isInsideMansion(layout, j, i - 1)) {
                        pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofCorner, blockPos2, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                        continue;
                    }
                    if (!MansionParameters.isInsideMansion(layout, j - 1, i - 1)) continue;
                    blockPos3 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 1);
                    pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.roofInnerCorner, blockPos3, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                }
            }
        }

        private void addEntrance(List<Piece> pieces, GenerationPiece wallPiece) {
            class_2350 direction = wallPiece.rotation.method_10503(class_2350.field_11039);
            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.entrance, wallPiece.position.method_10079(direction, 9), wallPiece.rotation, class_2415.field_11302));
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11035), 16);
        }

        private void addWallPiece(List<Piece> pieces, GenerationPiece wallPiece) {
            pieces.add(new Piece(this.roomTemplates, this.manager, wallPiece.template, wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11034), 7), wallPiece.rotation, class_2415.field_11302));
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11035), 8);
        }

        private void turnLeft(List<Piece> pieces, GenerationPiece wallPiece) {
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11035), -1);
            pieces.add(new Piece(this.roomTemplates, this.manager, this.roomTemplates.walls.cornerWall, wallPiece.position, wallPiece.rotation, class_2415.field_11302));
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11035), -7);
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11039), -6);
            wallPiece.rotation = wallPiece.rotation.method_10501(class_2470.field_11463);
        }

        private void turnRight(List<Piece> pieces, GenerationPiece wallPiece) {
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11035), 6);
            wallPiece.position = wallPiece.position.method_10079(wallPiece.rotation.method_10503(class_2350.field_11034), 8);
            wallPiece.rotation = wallPiece.rotation.method_10501(class_2470.field_11465);
        }

        private void addSmallRoom(List<Piece> pieces, class_2338 pos, class_2470 rotation, class_2350 direction, MansionTemplates.FloorTemplates floorTemplates) {
            class_2960 smallRoom = this.getRoom(floorTemplates.small, this.random);
            if (direction == class_2350.field_11036) {
                smallRoom = this.getRoom(floorTemplates.smallSecret, this.random);
            }
            class_2470 blockRotation = class_2470.field_11467.method_10501(this.rotateFromDirection(direction)).method_10501(class_2470.field_11465);
            class_2338 blockPos = class_3499.method_15162((class_2338)new class_2338(1, 0, 0), (class_2415)class_2415.field_11302, (class_2470)blockRotation, (int)7, (int)7);
            blockRotation = blockRotation.method_10501(rotation);
            blockPos = blockPos.method_10070(rotation);
            class_2338 blockPos2 = pos.method_10069(blockPos.method_10263(), 0, blockPos.method_10260());
            pieces.add(new Piece(this.roomTemplates, this.manager, smallRoom, blockPos2, blockRotation, class_2415.field_11302));
        }

        private void addMediumRoom(List<Piece> pieces, class_2338 pos, class_2470 rotation, class_2350 connectedRoomDirection, class_2350 entranceDirection, MansionTemplates.FloorTemplates floorTemplates, boolean staircase) {
            class_2415 blockMirror = class_2415.field_11302;
            int i = 0;
            int j = 0;
            if (entranceDirection == class_2350.field_11036) {
                class_2350 rotationDirection = class_2350.field_11034;
                if (connectedRoomDirection == class_2350.field_11034) {
                    i = 14;
                }
                class_2338 blockPos = pos.method_10079(rotation.method_10503(rotationDirection), i + 1);
                rotation = rotation.method_10501(this.rotateFromDirection(connectedRoomDirection));
                if (connectedRoomDirection == class_2350.field_11035) {
                    rotation = rotation.method_10501(class_2470.field_11464);
                }
                pieces.add(new Piece(this.roomTemplates, this.manager, this.getRoom(floorTemplates.mediumSecret, this.random), blockPos, rotation, class_2415.field_11302));
            } else if (entranceDirection.method_10166() == connectedRoomDirection.method_10166()) {
                class_2350 rotationDirection2;
                class_2350 rotationDirection = entranceDirection == class_2350.field_11034 ? class_2350.field_11039 : class_2350.field_11034;
                class_2350 class_23502 = rotationDirection2 = entranceDirection.method_35834(class_2350.class_2351.field_11052).method_10171() == class_2350.class_2352.field_11060 ? class_2350.field_11035 : class_2350.field_11043;
                if (entranceDirection == class_2350.field_11035) {
                    i = 1;
                    j = 8;
                } else if (entranceDirection == class_2350.field_11043) {
                    i = 7;
                    j = 14;
                } else if (entranceDirection == class_2350.field_11039) {
                    i = 15;
                } else if (entranceDirection == class_2350.field_11034) {
                    i = 7;
                    j = 6;
                }
                class_2338 blockPos = pos.method_10079(rotation.method_10503(rotationDirection), i).method_10079(rotation.method_10503(rotationDirection2), j);
                rotation = rotation.method_10501(this.rotateFromDirection(connectedRoomDirection));
                class_2960 roomType = staircase ? this.roomTemplates.genericStaircase : this.getRoom(floorTemplates.mediumGeneric, this.random);
                pieces.add(new Piece(this.roomTemplates, this.manager, roomType, blockPos, rotation, class_2415.field_11302));
            } else {
                if (entranceDirection.method_35834(class_2350.class_2351.field_11052) == connectedRoomDirection) {
                    blockMirror = entranceDirection.method_10171() == class_2350.class_2352.field_11060 ? class_2415.field_11301 : class_2415.field_11300;
                }
                i = entranceDirection == class_2350.field_11039 || connectedRoomDirection == class_2350.field_11039 ? 7 : 1;
                class_2338 blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11034), i);
                if (entranceDirection == class_2350.field_11043 || connectedRoomDirection == class_2350.field_11043) {
                    blockPos = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                }
                if (entranceDirection == class_2350.field_11039 && connectedRoomDirection == class_2350.field_11043) {
                    rotation = rotation.method_10501(class_2470.field_11464);
                } else if (entranceDirection == class_2350.field_11035 || connectedRoomDirection == class_2350.field_11039) {
                    rotation = rotation.method_10501(class_2470.field_11463);
                } else if (entranceDirection == class_2350.field_11043 && connectedRoomDirection == class_2350.field_11034) {
                    rotation = rotation.method_10501(class_2470.field_11465);
                }
                class_2960 roomType = staircase ? this.roomTemplates.functionalStaircase : this.getRoom(floorTemplates.mediumFunctional, this.random);
                pieces.add(new Piece(this.roomTemplates, this.manager, roomType, blockPos, rotation, blockMirror));
            }
        }

        private void addBigRoom(List<Piece> pieces, class_2338 pos, class_2470 rotation, class_2350 connectedRoomDirection, class_2350 entranceDirection, MansionTemplates.FloorTemplates floorTemplates) {
            int i = 0;
            int j = 0;
            class_2470 blockRotation = rotation;
            class_2415 blockMirror = class_2415.field_11302;
            if (entranceDirection == class_2350.field_11034 && connectedRoomDirection == class_2350.field_11035) {
                i = -7;
            } else if (entranceDirection == class_2350.field_11034 && connectedRoomDirection == class_2350.field_11043) {
                i = -7;
                j = 6;
                blockMirror = class_2415.field_11300;
            } else if (entranceDirection == class_2350.field_11043 && connectedRoomDirection == class_2350.field_11034) {
                i = 1;
                j = 14;
                blockRotation = rotation.method_10501(class_2470.field_11465);
            } else if (entranceDirection == class_2350.field_11043 && connectedRoomDirection == class_2350.field_11039) {
                i = 7;
                j = 14;
                blockRotation = rotation.method_10501(class_2470.field_11465);
                blockMirror = class_2415.field_11300;
            } else if (entranceDirection == class_2350.field_11035 && connectedRoomDirection == class_2350.field_11039) {
                i = 7;
                j = -8;
                blockRotation = rotation.method_10501(class_2470.field_11463);
            } else if (entranceDirection == class_2350.field_11035 && connectedRoomDirection == class_2350.field_11034) {
                i = 1;
                j = -8;
                blockRotation = rotation.method_10501(class_2470.field_11463);
                blockMirror = class_2415.field_11300;
            } else if (entranceDirection == class_2350.field_11039 && connectedRoomDirection == class_2350.field_11043) {
                i = 15;
                j = 6;
                blockRotation = rotation.method_10501(class_2470.field_11464);
            } else if (entranceDirection == class_2350.field_11039 && connectedRoomDirection == class_2350.field_11035) {
                i = 15;
                blockMirror = class_2415.field_11301;
            }
            class_2338 blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11034), i);
            blockPos = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), j);
            pieces.add(new Piece(this.roomTemplates, this.manager, this.getRoom(floorTemplates.large, this.random), blockPos, blockRotation, blockMirror));
        }

        private void addBigSecretRoom(List<Piece> pieces, class_2338 pos, class_2470 rotation, MansionTemplates.FloorTemplates floorTemplates) {
            class_2338 blockPos = pos.method_10079(rotation.method_10503(class_2350.field_11034), 1);
            pieces.add(new Piece(this.roomTemplates, this.manager, this.getRoom(floorTemplates.largeSecret, this.random), blockPos, rotation, class_2415.field_11302));
        }

        private class_2470 rotateFromDirection(class_2350 direction) {
            return switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11036, class_2350.field_11033, class_2350.field_11043 -> class_2470.field_11467;
                case class_2350.field_11034 -> class_2470.field_11463;
                case class_2350.field_11035 -> class_2470.field_11464;
                case class_2350.field_11039 -> class_2470.field_11465;
            };
        }

        private class_2960 getRoom(List<class_2960> roomType, class_5819 random) {
            return roomType.get(random.method_43048(roomType.size()));
        }
    }

    public static class Piece
    extends class_3470 {
        public Piece(MansionTemplates mansionTemplates, class_3485 manager, String template, class_2338 pos, class_2470 rotation) {
            this(mansionTemplates, manager, new class_2960("woodland_mansion/" + template), pos, rotation, class_2415.field_11302);
        }

        public Piece(MansionTemplates mansionTemplates, class_3485 manager, class_2960 template, class_2338 pos, class_2470 rotation) {
            this(mansionTemplates, manager, template, pos, rotation, class_2415.field_11302);
        }

        public Piece(MansionTemplates mansionTemplates, class_3485 manager, class_2960 template, class_2338 pos, class_2470 rotation, class_2415 mirror) {
            super(NJBStructurePieces.ALTERNATE_MANSION_PIECE, 0, manager, template, String.valueOf(template), Piece.createPlacementData(mansionTemplates, mirror, rotation), pos);
        }

        public Piece(class_3485 manager, class_5455 dynamicRegistryManager, class_2487 nbt) {
            super(NJBStructurePieces.ALTERNATE_MANSION_PIECE, nbt, manager, id -> Piece.createPlacementData(dynamicRegistryManager, class_2415.valueOf((String)nbt.method_10558("Mi")), class_2470.valueOf((String)nbt.method_10558("Rot"))));
        }

        public Piece(class_6625 structureContext, class_2487 nbtCompound) {
            this(structureContext.comp_135(), structureContext.comp_134(), nbtCompound);
        }

        private static class_3492 createPlacementData(MansionTemplates mansionTemplates, class_2415 mirror, class_2470 rotation) {
            class_3492 structurePlacementData = new class_3492().method_15133(false).method_15123(rotation).method_15125(mirror).method_16184((class_3491)class_3793.field_16718);
            List processors = ((class_5497)mansionTemplates.mansionProcessor.comp_349()).method_31027();
            processors.forEach(arg_0 -> ((class_3492)structurePlacementData).method_16184(arg_0));
            return structurePlacementData;
        }

        private static class_3492 createPlacementData(class_5455 dynamicRegistryManager, class_2415 mirror, class_2470 rotation) {
            class_3492 structurePlacementData = new class_3492().method_15133(false).method_15123(rotation).method_15125(mirror).method_16184((class_3491)class_3793.field_16718);
            class_5321 processorList = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)new class_2960("njb", "mansion/generic"));
            List processors = ((class_5497)dynamicRegistryManager.method_30530(class_7924.field_41247).method_29107(processorList)).method_31027();
            processors.forEach(arg_0 -> ((class_3492)structurePlacementData).method_16184(arg_0));
            return structurePlacementData;
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_10582("Rot", this.field_15434.method_15113().name());
            nbt.method_10582("Mi", this.field_15434.method_15114().name());
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 world, class_5819 random, class_3341 boundingBox) {
            if (metadata.startsWith("Chest")) {
                class_2470 blockRotation = this.field_15434.method_15113();
                class_2680 blockState = class_2246.field_10034.method_9564();
                if ("ChestWest".equals(metadata)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2281.field_10768, (Comparable)blockRotation.method_10503(class_2350.field_11039));
                } else if ("ChestEast".equals(metadata)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2281.field_10768, (Comparable)blockRotation.method_10503(class_2350.field_11034));
                } else if ("ChestSouth".equals(metadata)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2281.field_10768, (Comparable)blockRotation.method_10503(class_2350.field_11035));
                } else if ("ChestNorth".equals(metadata)) {
                    blockState = (class_2680)blockState.method_11657((class_2769)class_2281.field_10768, (Comparable)blockRotation.method_10503(class_2350.field_11043));
                }
                this.method_14921(world, boundingBox, random, pos, class_39.field_484, blockState);
            } else {
                ArrayList<class_1308> list = new ArrayList<class_1308>();
                switch (metadata) {
                    case "Mage": {
                        list.add((class_1308)class_1299.field_6090.method_5883((class_1937)world.method_8410()));
                        break;
                    }
                    case "Warrior": {
                        list.add((class_1308)class_1299.field_6117.method_5883((class_1937)world.method_8410()));
                        break;
                    }
                    case "Prisoner": {
                        if (random.method_43056()) {
                            int i = world.method_8409().method_43048(3) + 1;
                            for (int j = 0; j < i; ++j) {
                                list.add((class_1308)class_1299.field_38384.method_5883((class_1937)world.method_8410()));
                            }
                            break;
                        }
                        list.add((class_1308)class_1299.field_6077.method_5883((class_1937)world.method_8410()));
                    }
                    default: {
                        return;
                    }
                }
                for (class_1308 mobEntity : list) {
                    if (mobEntity == null) continue;
                    mobEntity.method_5971();
                    mobEntity.method_5725(pos, 0.0f, 0.0f);
                    mobEntity.method_5943(world, world.method_8404(mobEntity.method_24515()), class_3730.field_16474, null, null);
                    world.method_30771((class_1297)mobEntity);
                    world.method_8652(pos, class_2246.field_10124.method_9564(), 2);
                }
            }
        }
    }

    private static class GenerationPiece {
        public class_2470 rotation;
        public class_2338 position;
        public class_2960 template;

        GenerationPiece() {
        }
    }

    private static class FlagMatrix {
        private final int[][] array;
        final int n;
        final int m;
        private final int fallback;

        public FlagMatrix(int n, int m, int fallback) {
            this.n = n;
            this.m = m;
            this.fallback = fallback;
            this.array = new int[n][m];
        }

        public void set(int i, int j, int value) {
            if (i >= 0 && i < this.n && j >= 0 && j < this.m) {
                this.array[i][j] = value;
            }
        }

        public void fill(int i0, int j0, int i1, int j1, int value) {
            for (int i = j0; i <= j1; ++i) {
                for (int j = i0; j <= i1; ++j) {
                    this.set(j, i, value);
                }
            }
        }

        public int get(int i, int j) {
            return i >= 0 && i < this.n && j >= 0 && j < this.m ? this.array[i][j] : this.fallback;
        }

        public void update(int i, int j, int expected, int newValue) {
            if (this.get(i, j) == expected) {
                this.set(i, j, newValue);
            }
        }

        public boolean anyMatchAround(int i, int j, int value) {
            return this.get(i - 1, j) == value || this.get(i + 1, j) == value || this.get(i, j + 1) == value || this.get(i, j - 1) == value;
        }
    }
}

