/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.njb.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.worldgen.njb.NotJustBiomes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private static final Path FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("not-just-biomes.json");
    public static final Map<String, Boolean> DEFAULT_CONFIG_VALUES = new LinkedHashMap<String, Boolean>(){
        {
            this.put("birch_forest", true);
            this.put("cherry_grove", true);
            this.put("dungeon", true);
            this.put("forest", true);
            this.put("mansion", true);
            this.put("ore_vein", true);
            this.put("swamp", true);
            this.put("taiga", true);
            this.put("well", true);
        }
    };
    static Map<String, Boolean> CONFIG_VALUES = new HashMap<String, Boolean>();

    public static void loadOrCreateDefaultConfig() {
        if (!Files.isRegularFile(FILE_PATH, new LinkOption[0])) {
            NotJustBiomes.LOGGER.info("Config file for Not Just Biomes not found, creating file with default values...");
            try (BufferedWriter writer = Files.newBufferedWriter(FILE_PATH, new OpenOption[0]);){
                writer.write("{}");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(FILE_PATH);){
            JsonElement json = JsonParser.parseReader((Reader)reader);
            JsonObject jsonObject = json.getAsJsonObject().getAsJsonObject("enabled_modules");
            if (jsonObject != null) {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    if (!DEFAULT_CONFIG_VALUES.containsKey(entry.getKey()) && !Objects.equals(entry.getKey(), "tectonic_trees")) continue;
                    String key = (String)entry.getKey();
                    Boolean value = ((JsonElement)entry.getValue()).getAsBoolean();
                    CONFIG_VALUES.put(key, value);
                }
            }
            for (Map.Entry entry : DEFAULT_CONFIG_VALUES.entrySet()) {
                CONFIG_VALUES.putIfAbsent((String)entry.getKey(), (Boolean)entry.getValue());
            }
            if (NotJustBiomes.isTectonicLoaded) {
                CONFIG_VALUES.putIfAbsent("tectonic_trees", false);
            }
            ConfigHandler.writeToFile(CONFIG_VALUES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getConfigValue(String key) {
        boolean value = false;
        if (CONFIG_VALUES.containsKey(key)) {
            value = CONFIG_VALUES.get(key);
        } else if (DEFAULT_CONFIG_VALUES.containsKey(key)) {
            value = DEFAULT_CONFIG_VALUES.get(key);
        }
        return value;
    }

    public static void writeToFile(Map<String, Boolean> input) {
        try (BufferedWriter writer = Files.newBufferedWriter(FILE_PATH, new OpenOption[0]);){
            LinkedHashMap<String, Map<String, Boolean>> map = new LinkedHashMap<String, Map<String, Boolean>>();
            map.put("enabled_modules", input);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson(map));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void flipValue(String key) {
        CONFIG_VALUES.put(key, CONFIG_VALUES.get(key) == false);
        ConfigHandler.writeToFile(CONFIG_VALUES);
    }
}

