/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.inventory;

import com.github.tartaricacid.netmusic.compat.tlm.backpack.data.MusicPlayerBackpackData;
import com.github.tartaricacid.netmusic.compat.tlm.message.MaidMusicToClientMessage;
import com.github.tartaricacid.netmusic.compat.tlm.message.MaidStopMusicMessage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MusicPlayerBackpackContainer
extends MaidMainContainer {
    public static final MenuType<MusicPlayerBackpackContainer> TYPE = IForgeMenuType.create((windowId, inv, data) -> new MusicPlayerBackpackContainer(windowId, inv, data.readInt()));
    private static final ResourceLocation EMPTY_CD_SLOT = new ResourceLocation("netmusic", "slot/music_cd_slot");
    private final ContainerData data;

    public MusicPlayerBackpackContainer(int id, Inventory inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        MusicPlayerBackpackData musicPlayerBackpackData = this.getMaid().getBackpackData() instanceof MusicPlayerBackpackData ? (MusicPlayerBackpackData)this.getMaid().getBackpackData() : new MusicPlayerBackpackData();
        this.data = musicPlayerBackpackData.getDataAccess();
        this.m_38884_(this.data);
    }

    protected void addBackpackInv(Inventory inventory) {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 6; ++x) {
                int index = (y + 1) * 6 + x;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.maid.getMaidInv(), index, 143 + 18 * x, 57 + 18 * y){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return stack.m_150930_((Item)InitItems.MUSIC_CD.get());
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                        return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CD_SLOT);
                    }
                });
            }
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (id == 0) {
            return this.previousSlot();
        }
        if (id == 1) {
            return this.nextSlot();
        }
        if (id == 2) {
            return this.stopMusic();
        }
        if (id == 3) {
            this.stopMusic();
            return this.playMusic();
        }
        return false;
    }

    private boolean previousSlot() {
        this.stopMusic();
        int slotId = this.data.m_6413_(0);
        if (--slotId < 0) {
            slotId = 23;
        }
        this.data.m_8050_(0, slotId);
        return true;
    }

    private boolean nextSlot() {
        this.stopMusic();
        int slotId = this.data.m_6413_(0);
        if (++slotId > 23) {
            slotId = 0;
        }
        this.data.m_8050_(0, slotId);
        return true;
    }

    private boolean playMusic() {
        CombinedInvWrapper availableInv;
        ItemStack stackInSlot;
        if (this.maid == null) {
            return false;
        }
        int slotId = this.getSelectSlotId();
        if (0 <= slotId && slotId < 24 && (stackInSlot = (availableInv = this.maid.getAvailableInv(false)).getStackInSlot(6 + slotId)).m_150930_((Item)InitItems.MUSIC_CD.get())) {
            ItemMusicCD.SongInfo info = ItemMusicCD.getSongInfo(stackInSlot);
            if (info == null) {
                return false;
            }
            this.setSoundTicks(info.songTime * 20 + 64);
            MaidMusicToClientMessage msg = new MaidMusicToClientMessage(this.maid.m_19879_(), info.songUrl, info.songTime, info.songName);
            NetworkHandler.sendToNearby(this.maid.m_9236_(), this.maid.m_20183_(), msg);
            return true;
        }
        return false;
    }

    private boolean stopMusic() {
        if (this.maid == null) {
            return false;
        }
        this.setSoundTicks(0);
        MaidStopMusicMessage stopMsg = new MaidStopMusicMessage(this.maid.m_19879_());
        NetworkHandler.sendToNearby(this.maid.m_9236_(), this.maid.m_20183_(), stopMsg);
        return true;
    }

    public int getSelectSlotId() {
        return this.data.m_6413_(0);
    }

    public void setSoundTicks(int ticks) {
        this.data.m_8050_(1, ticks);
    }
}

