/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.compat.tlm.client.audio;

import com.github.tartaricacid.netmusic.client.audio.NetMusicAudioStream;
import com.github.tartaricacid.netmusic.compat.tlm.backpack.MusicPlayerBackpack;
import com.github.tartaricacid.netmusic.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class MaidNetMusicSound
extends AbstractTickableSoundInstance {
    private final EntityMaid maid;
    private final URL songUrl;
    private final int tickTimes;
    private int tick;

    public MaidNetMusicSound(EntityMaid maid, URL songUrl, int timeSecond) {
        super((SoundEvent)InitSounds.NET_MUSIC.get(), SoundSource.RECORDS, SoundInstance.m_235150_());
        this.maid = maid;
        this.songUrl = songUrl;
        this.f_119575_ = maid.m_20185_();
        this.f_119576_ = maid.m_20186_();
        this.f_119577_ = maid.m_20189_();
        this.tickTimes = timeSecond * 20;
        this.f_119573_ = 4.0f;
        this.tick = 0;
    }

    public void m_7788_() {
        ClientLevel world;
        if (this.maid.m_213877_()) {
            this.m_119609_();
        }
        if (!(this.maid.getMaidBackpackType() instanceof MusicPlayerBackpack)) {
            this.m_119609_();
        }
        if ((world = Minecraft.m_91087_().f_91073_) == null) {
            this.m_119609_();
            return;
        }
        ++this.tick;
        if (this.tick > this.tickTimes + 50) {
            this.m_119609_();
        } else {
            this.f_119575_ = this.maid.m_20185_();
            this.f_119576_ = this.maid.m_20186_();
            this.f_119577_ = this.maid.m_20189_();
            if (world.m_46467_() % 8L == 0L) {
                for (int i = 0; i < 2; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, this.f_119575_ - 0.5 + world.f_46441_.m_188500_(), this.f_119576_ + 1.5 + world.f_46441_.m_188500_(), this.f_119577_ - 0.5 + world.f_46441_.m_188500_(), world.f_46441_.m_188583_(), world.f_46441_.m_188583_(), (double)world.f_46441_.m_188503_(3));
                }
            }
        }
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return new NetMusicAudioStream(this.songUrl);
            }
            catch (IOException | UnsupportedAudioFileException e) {
                e.printStackTrace();
                return null;
            }
        }, Util.m_183991_());
    }

    public int getMaidId() {
        return this.maid.m_19879_();
    }

    public void setStop() {
        this.m_119609_();
    }
}

