/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.audio;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.NetWorker;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class MusicPlayManager {
    private static final String ERROR_404 = "http://music.163.com/404";
    private static final String MUSIC_163_URL = "https://music.163.com/";
    private static final String LOCAL_FILE_PROTOCOL = "file";

    public static void play(String url, String songName, Function<URL, SoundInstance> sound) {
        String rawUrl = url;
        if (url.startsWith(MUSIC_163_URL)) {
            try {
                url = NetWorker.getRedirectUrl(url, NetMusic.NET_EASE_WEB_API.getRequestPropertyData());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (url != null) {
            if (url.equals(ERROR_404)) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    player.m_213846_((Component)Component.m_237110_((String)"message.netmusic.music_player.404", (Object[])new Object[]{rawUrl}).m_130940_(ChatFormatting.RED));
                }
                NetMusic.LOGGER.info("Music not found: {}", (Object)rawUrl);
                return;
            }
            MusicPlayManager.playMusic(url, songName, sound);
        }
    }

    private static void playMusic(String url, String songName, Function<URL, SoundInstance> sound) {
        try {
            File file;
            URL urlFinal = new URL(url);
            if (urlFinal.getProtocol().equals(LOCAL_FILE_PROTOCOL) && !(file = new File(urlFinal.toURI())).exists()) {
                NetMusic.LOGGER.info("File not found: {}", (Object)url);
                return;
            }
            Minecraft.m_91087_().m_18689_(() -> {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound.apply(urlFinal));
                Minecraft.m_91087_().f_91065_.m_93055_((Component)Component.m_237113_((String)songName));
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

