/*
 * Decompiled with CFR 0.152.
 */
package cn.mcmod_mmf.mmlib.item;

import cn.mcmod_mmf.mmlib.item.info.FoodInfo;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;

public interface IFoodLike {
    public FoodInfo getFoodInfo();

    public boolean shouldAddEffectTooltips();

    default public void addEffectTooltips(List<Component> tooltips) {
        List<Pair<Supplier<MobEffectInstance>, Float>> effectList = this.getFoodInfo().getEffects();
        if (effectList.isEmpty()) {
            tooltips.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
            return;
        }
        ArrayList attributeList = Lists.newArrayList();
        for (Pair<Supplier<MobEffectInstance>, Float> effectPair : effectList) {
            Supplier instance = (Supplier)effectPair.getFirst();
            MutableComponent iformattabletextcomponent = Component.m_237115_((String)((MobEffectInstance)instance.get()).m_19576_());
            MobEffect effect = ((MobEffectInstance)instance.get()).m_19544_();
            Map attributeMap = effect.m_19485_();
            if (!attributeMap.isEmpty()) {
                for (Map.Entry entry : attributeMap.entrySet()) {
                    AttributeModifier rawModifier = (AttributeModifier)entry.getValue();
                    AttributeModifier modifier = new AttributeModifier(rawModifier.m_22214_(), effect.m_7048_(((MobEffectInstance)instance.get()).m_19564_(), rawModifier), rawModifier.m_22217_());
                    attributeList.add(new Pair((Object)((Attribute)entry.getKey()), (Object)modifier));
                }
            }
            if (((MobEffectInstance)instance.get()).m_19564_() > 0) {
                iformattabletextcomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.m_237115_((String)("potion.potency." + ((MobEffectInstance)instance.get()).m_19564_()))});
            }
            if (((MobEffectInstance)instance.get()).m_19557_() > 20) {
                iformattabletextcomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.m_267641_((MobEffectInstance)((MobEffectInstance)instance.get()), (float)1.0f)});
            }
            tooltips.add((Component)iformattabletextcomponent.m_130940_(effect.m_19483_().m_19497_()));
        }
        if (!attributeList.isEmpty()) {
            tooltips.add(CommonComponents.f_237098_);
            tooltips.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeList) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.m_22218_();
                double formattedAmount = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.m_22218_() : modifier.m_22218_() * 100.0;
                if (amount > 0.0) {
                    tooltips.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(formattedAmount), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltips.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(formattedAmount *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

