/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod.mixin;

import ewewukek.musketmod.Config;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.RangedGunAttackGoal;
import ewewukek.musketmod.VanillaHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pillager.class})
abstract class PillagerMixin {
    private static final ResourceLocation LOOT_TABLE = MusketMod.resource("pillager_weapon");

    PillagerMixin() {
    }

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        Pillager pillager = (Pillager)this;
        pillager.f_21345_.m_25352_(3, (Goal)new RangedGunAttackGoal<Pillager>(pillager){
            private static final double speedModifier = 1.0;
            private static final float attackRadius = 8.0f;
            private int seeTime;
            private int attackDelay;
            private int updatePathDelay;

            @Override
            public void m_8037_() {
                boolean walk;
                boolean wasSeeing;
                super.m_8037_();
                LivingEntity target = ((Pillager)this.mob).m_5448_();
                if (target == null) {
                    return;
                }
                boolean canSee = ((Pillager)this.mob).m_21574_().m_148306_((Entity)target);
                boolean bl = wasSeeing = this.seeTime > 0;
                if (canSee != wasSeeing) {
                    this.seeTime = 0;
                }
                this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
                float dist = ((Pillager)this.mob).m_20270_((Entity)target);
                boolean bl2 = walk = (dist > 8.0f || this.seeTime < 5) && this.attackDelay == 0;
                if (walk) {
                    --this.updatePathDelay;
                    if (this.updatePathDelay <= 0) {
                        boolean canRun = !this.isReady() && !this.isLoading();
                        ((Pillager)this.mob).m_21573_().m_5624_((Entity)target, canRun ? 1.0 : 0.5);
                        this.updatePathDelay = RangedCrossbowAttackGoal.f_25804_.m_214085_(((Pillager)this.mob).m_217043_());
                    }
                } else {
                    this.updatePathDelay = 0;
                    ((Pillager)this.mob).m_21573_().m_26573_();
                }
                ((Pillager)this.mob).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                if (this.isReady()) {
                    if (this.attackDelay > 0) {
                        --this.attackDelay;
                    } else if (canSee) {
                        this.fire(2.0f);
                    }
                } else if (!walk) {
                    this.reload();
                }
            }

            @Override
            public void onReady() {
                this.attackDelay = 20 + ((Pillager)this.mob).m_217043_().m_188503_(20);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                this.seeTime = 0;
            }
        });
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    private void populateDefaultEquipmentSlots(CallbackInfo ci) {
        ItemStack weapon;
        Pillager pillager = (Pillager)this;
        if (pillager.m_217043_().m_188501_() < Config.pistolPillagerChance && !(weapon = VanillaHelper.getRandomWeapon((Entity)pillager, LOOT_TABLE)).m_41619_()) {
            pillager.m_8061_(EquipmentSlot.MAINHAND, weapon);
        }
    }

    @Inject(method={"getArmPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void getArmPose(CallbackInfoReturnable<AbstractIllager.IllagerArmPose> ci) {
        Pillager pillager = (Pillager)this;
        if (GunItem.isHoldingGun((LivingEntity)pillager)) {
            ci.setReturnValue((Object)(pillager.m_6117_() ? AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE : AbstractIllager.IllagerArmPose.CROSSBOW_HOLD));
            ci.cancel();
        }
    }
}

