/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod.mixin;

import ewewukek.musketmod.ClientUtilities;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.ScopedMusketItem;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
abstract class MultiPlayerGameModeMixin {
    MultiPlayerGameModeMixin() {
    }

    @Inject(method={"interactAt"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactAtHead(Player player, Entity entity, EntityHitResult hitResult, InteractionHand hand, CallbackInfoReturnable<InteractionResult> ci) {
        if (ScopedMusketItem.isScoping) {
            ci.setReturnValue((Object)InteractionResult.FAIL);
            ci.cancel();
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactHead(Player player, Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> ci) {
        if (ScopedMusketItem.isScoping) {
            ci.setReturnValue((Object)InteractionResult.FAIL);
            ci.cancel();
        }
    }

    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void useItemOnHead(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> ci) {
        if (ScopedMusketItem.isScoping) {
            ci.setReturnValue((Object)InteractionResult.FAIL);
            ci.cancel();
        }
    }

    @Inject(method={"useItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void useItemHead(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> ci) {
        Item item;
        ItemStack stack = player.m_21120_(hand);
        if (ClientUtilities.canUseScope && hand == InteractionHand.MAIN_HAND && GunItem.isReady(stack)) {
            ClientUtilities.setScoping(player, true);
            if (ClientUtilities.attackKeyDown) {
                return;
            }
        }
        if (ScopedMusketItem.isScoping) {
            ci.setReturnValue((Object)InteractionResult.FAIL);
            ci.cancel();
        }
        if ((item = stack.m_41720_()) instanceof GunItem) {
            GunItem gun = (GunItem)item;
            if (GunItem.isReady(stack) && gun.canUseFrom((LivingEntity)player, hand) && ClientUtilities.preventFiring) {
                ci.setReturnValue((Object)InteractionResult.FAIL);
                ci.cancel();
            }
        }
    }
}

