/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.mss.utils;

import com.finndog.mss.MSSCommon;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class GeneralUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<BlockState, Boolean>();

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, RandomSource random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.m_188501_() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(BlockGetter world, BlockPos pos, BlockState state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> Block.m_49916_((VoxelShape)stateIn.m_60768_(world, pos)));
    }

    public static ItemStack enchantRandomly(RandomSource random, ItemStack itemToEnchant, float chance) {
        List<Enchantment> list;
        if (random.m_188501_() < chance && !(list = BuiltInRegistries.f_256876_.m_123024_().filter(Enchantment::m_6592_).filter(enchantmentToCheck -> enchantmentToCheck.m_6081_(itemToEnchant)).toList()).isEmpty()) {
            Enchantment enchantment = list.get(random.m_188503_(list.size()));
            int enchantmentLevel = random.m_188503_(Mth.m_216271_((RandomSource)random, (int)enchantment.m_44702_(), (int)enchantment.m_6586_()) + 1);
            itemToEnchant.m_41663_(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(ChunkGenerator chunkGenerator) {
        return chunkGenerator.m_142062_() + chunkGenerator.m_6331_();
    }

    public static BlockPos getHighestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(boundingBox.m_162394_().m_123341_(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.m_162394_().m_123343_());
        NoiseColumn blockView = chunkGenerator.m_214184_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView, randomState);
        while (mutable.m_123342_() > chunkGenerator.m_6337_()) {
            BlockState currentBlockstate = blockView.m_183556_(mutable.m_123342_());
            if (!currentBlockstate.m_60815_()) {
                mutable.m_122173_(Direction.DOWN);
                continue;
            }
            if (blockView.m_183556_(mutable.m_123342_() + 3).m_60795_() && (canBeOnLiquid ? !currentBlockstate.m_60795_() : currentBlockstate.m_60815_())) {
                return mutable;
            }
            mutable.m_122173_(Direction.DOWN);
        }
        return mutable;
    }

    public static BlockPos getLowestLand(ChunkGenerator chunkGenerator, RandomState randomState, BoundingBox boundingBox, LevelHeightAccessor heightLimitView, boolean canBeOnLiquid) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122178_(boundingBox.m_162394_().m_123341_(), chunkGenerator.m_6337_() + 1, boundingBox.m_162394_().m_123343_());
        NoiseColumn blockView = chunkGenerator.m_214184_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView, randomState);
        BlockState currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        while (mutable.m_123342_() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.m_60795_() : currentBlockstate.m_60815_()) && blockView.m_183556_(mutable.m_123342_() + 1).m_60795_() && blockView.m_183556_(mutable.m_123342_() + 5).m_60795_()) {
                mutable.m_122173_(Direction.UP);
                return mutable;
            }
            mutable.m_122173_(Direction.UP);
            currentBlockstate = blockView.m_183556_(mutable.m_123342_());
        }
        return mutable.m_122178_(mutable.m_123341_(), chunkGenerator.m_6337_(), mutable.m_123343_());
    }

    public static int getFirstLandYFromPos(LevelReader worldView, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)pos);
        ChunkAccess currentChunk = worldView.m_46865_((BlockPos)mutable);
        BlockState currentState = currentChunk.m_8055_((BlockPos)mutable);
        while (mutable.m_123342_() >= worldView.m_141937_() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.m_122173_(Direction.DOWN);
            currentState = currentChunk.m_8055_((BlockPos)mutable);
        }
        return mutable.m_123342_();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.m_60795_() || !blockState.m_60819_().m_76178_() || blockState.m_204336_(BlockTags.f_278411_);
    }

    public static void centerAllPieces(BlockPos targetPos, List<? extends StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        BlockPos structureCenter = pieces.get(0).m_73547_().m_162394_();
        int xOffset = targetPos.m_123341_() - structureCenter.m_123341_();
        int zOffset = targetPos.m_123343_() - structureCenter.m_123343_();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.m_6324_(xOffset, 0, zOffset);
        }
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.f_74676_().m_61143_((Property)JigsawBlock.f_54222_);
        String joint = jigsaw1.f_74677_().m_128461_("joint");
        if (joint.isEmpty()) {
            joint = prop1.m_122625_().m_122434_().m_122479_() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.m_122625_() == prop2.m_122625_().m_122424_() && (isRollable || prop1.m_122629_() == prop2.m_122629_()) && jigsaw1.f_74677_().m_128461_("target").equals(jigsaw2.f_74677_().m_128461_("name"));
    }

    public static Map<ResourceLocation, List<JsonElement>> getAllDatapacksJSONElement(ResourceManager resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.m_214160_(dataType, fileString -> fileString.toString().endsWith(".json")).entrySet()) {
            String identifierPath = ((ResourceLocation)resourceStackEntry.getKey()).m_135815_();
            ResourceLocation fileID = new ResourceLocation(((ResourceLocation)resourceStackEntry.getKey()).m_135827_(), identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (Resource resource : (List)resourceStackEntry.getValue()) {
                    InputStream fileStream = resource.m_215507_();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        MSSCommon.LOGGER.error("(Moog's Soaring Structures {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, resourceStackEntry);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                MSSCommon.LOGGER.error("(Moog's Soaring Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<ResourceLocation, ResourceLocation> entry) {
        boolean invalidLootTableFound = false;
        if (minecraftServer.m_278653_().m_278676_(entry.getKey()) == LootTable.f_79105_) {
            MSSCommon.LOGGER.error("Unable to find loot table key: {}", (Object)entry.getKey());
            invalidLootTableFound = true;
        }
        if (minecraftServer.m_278653_().m_278676_(entry.getValue()) == LootTable.f_79105_) {
            MSSCommon.LOGGER.error("Unable to find loot table value: {}", (Object)entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }

    public static boolean isMissingLootImporting(MinecraftServer minecraftServer, Set<ResourceLocation> tableKeys) {
        AtomicBoolean invalidLootTableFound = new AtomicBoolean(false);
        minecraftServer.m_278653_().m_278706_(LootDataType.f_278413_).forEach(rl -> {
            if (rl.m_135827_().equals("mss") && !tableKeys.contains(rl)) {
                if (rl.m_135815_().contains("mansions") && rl.m_135815_().contains("storage")) {
                    return;
                }
                if (rl.m_135815_().contains("monuments")) {
                    return;
                }
                if (rl.m_135815_().contains("dispensers/temples/wasteland_lava")) {
                    return;
                }
                if (rl.m_135815_().contains("lucky_pool")) {
                    return;
                }
                if (rl.m_135815_().contains("archaeology")) {
                    return;
                }
                MSSCommon.LOGGER.error("No loot importing found for: {}", rl);
                invalidLootTableFound.set(true);
            }
        });
        return invalidLootTableFound.get();
    }
}

