/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.network;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.platform.ClientPlatform;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class C2SPlayCardPacket {
    public static final ResourceLocation ID = Mino.id("play_card");

    public static void handleC2S(MinecraftServer server, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos gamePos = packet.m_130135_();
        ServerLevel level = player.m_284548_();
        UUID playerUuid = packet.m_130259_();
        int actionType = packet.readInt();
        switch (actionType) {
            case 0: {
                Card card = new Card(Objects.requireNonNull(packet.m_130260_()));
                int wildSelectionOrdinal = packet.readInt();
                boolean shout = packet.readBoolean();
                server.execute(() -> {
                    BlockEntity patt0$temp = level.m_7702_(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    Card.Suit wildSelection = wildSelectionOrdinal == -1 ? null : Card.Suit.values()[wildSelectionOrdinal];
                    ActionReport result = tableEntity.game.playCard(cardPlayer, card, wildSelection, shout);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
                break;
            }
            case 1: {
                server.execute(() -> {
                    BlockEntity patt0$temp = level.m_7702_(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    ActionReport result = tableEntity.game.playNoCard(cardPlayer);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
                break;
            }
            case 2: {
                UUID targetPlayerUuid = packet.m_130259_();
                server.execute(() -> {
                    BlockEntity patt0$temp = level.m_7702_(gamePos);
                    if (!(patt0$temp instanceof BlockEntityMinoTable)) {
                        return;
                    }
                    BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)patt0$temp;
                    if (tableEntity.game == null) {
                        return;
                    }
                    CardPlayer cardPlayer = tableEntity.game.deAmputate(playerUuid);
                    if (cardPlayer == null) {
                        return;
                    }
                    ActionReport result = tableEntity.game.doubtMino(cardPlayer, targetPlayerUuid);
                    tableEntity.handleActionResult(result, cardPlayer, player);
                });
            }
        }
    }

    public static class Client {
        public static void sendPlayCardC2S(BlockPos gamePos, CardPlayer player, Card card, Card.Suit wildSelection, boolean shout) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130064_(gamePos);
            packet.m_130077_(player.uuid);
            packet.writeInt(0);
            packet.m_130079_(card.toTag());
            packet.writeInt(wildSelection == null ? -1 : wildSelection.ordinal());
            packet.writeBoolean(shout);
            ClientPlatform.sendPacketToServer(ID, packet);
        }

        public static void sendPlayNoCardC2S(BlockPos gamePos, CardPlayer player) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130064_(gamePos);
            packet.m_130077_(player.uuid);
            packet.writeInt(1);
            ClientPlatform.sendPacketToServer(ID, packet);
        }

        public static void sendDoubtMinoC2S(BlockPos gamePos, CardPlayer player, UUID targetPlayer) {
            FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
            packet.m_130064_(gamePos);
            packet.m_130077_(player.uuid);
            packet.writeInt(2);
            packet.m_130077_(targetPlayer);
            ClientPlatform.sendPacketToServer(ID, packet);
        }
    }
}

