/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.gui;

import cn.zbx1425.minopp.Mino;
import cn.zbx1425.minopp.MinoClient;
import cn.zbx1425.minopp.block.BlockEntityMinoTable;
import cn.zbx1425.minopp.block.BlockMinoTable;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import cn.zbx1425.minopp.gui.TurnDeadMan;
import cn.zbx1425.minopp.item.ItemHandCards;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2FloatArrayMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class GameOverlayLayer {
    private double zoomAnimationProgress = 0.0;
    private double zoomAnimationTarget = 0.0;
    private final Long2FloatArrayMap handCardCurrentXOff = new Long2FloatArrayMap();
    private static final ResourceLocation ATLAS_LOCATION = Mino.id("textures/gui/deck.png");
    public static final GameOverlayLayer INSTANCE = new GameOverlayLayer();

    public void render(GuiGraphics guiGraphics, float partialTick) {
        BlockPos gamePos;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos handCardGamePos = ItemHandCards.getHandCardGamePos((Player)player);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos hitResultGamePos = BlockMinoTable.Client.getCursorPickedGame();
        BlockPos blockPos = gamePos = handCardGamePos != null ? handCardGamePos : hitResultGamePos;
        if (gamePos == null) {
            TurnDeadMan.setOutsideGame();
            MinoClient.handCardOverlayActive = false;
            this.handCardCurrentXOff.clear();
            return;
        }
        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)level.m_7702_(gamePos);
        if (tableEntity == null) {
            TurnDeadMan.setOutsideGame();
            MinoClient.handCardOverlayActive = false;
            this.handCardCurrentXOff.clear();
            return;
        }
        if (tableEntity.game == null) {
            this.renderGameInactive(guiGraphics, partialTick, tableEntity);
            TurnDeadMan.setOutsideGame();
            this.zoomAnimationTarget = 0.0;
            this.zoomAnimationProgress = 0.0;
        } else {
            TurnDeadMan.tick(tableEntity.game, partialTick);
            if (handCardGamePos == null || hitResultGamePos == null || Objects.equals(handCardGamePos, hitResultGamePos)) {
                this.renderGameActive(guiGraphics, partialTick, tableEntity);
            } else {
                this.zoomAnimationTarget = 0.0;
            }
        }
        this.performZoomAnimation(partialTick, tableEntity);
        MinoClient.handCardOverlayActive = this.renderHandCards(guiGraphics, partialTick);
    }

    private void renderGameInactive(GuiGraphics guiGraphics, float partialTick, BlockEntityMinoTable tableEntity) {
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        int x = 20;
        int y = 60;
        Font font = Minecraft.m_91087_().f_91062_;
        for (String part : tableEntity.state.message().getString().split("\n")) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237113_((String)part), x, y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
        Objects.requireNonNull(font);
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237115_((String)"gui.minopp.play.start_hint"), x, y += 9, -16720555);
    }

    private void renderGameActive(GuiGraphics guiGraphics, float partialTick, BlockEntityMinoTable tableEntity) {
        BlockPos hitPos;
        BlockState hitState;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        CardPlayer cardPlayer = ItemHandCards.getCardPlayer((Player)player);
        CardPlayer currentPlayer = tableEntity.game.players.get(tableEntity.game.currentPlayerIndex);
        if (currentPlayer.equals(cardPlayer)) {
            if (tableEntity.game.currentPlayerPhase == CardGame.PlayerActionPhase.DISCARD_HAND) {
                this.zoomAnimationTarget = 1.0;
            } else if (this.zoomAnimationTarget < 1.01) {
                this.zoomAnimationTarget = 1.5;
            } else if (this.zoomAnimationProgress >= 1.5) {
                this.zoomAnimationTarget = 1.05;
            }
        } else {
            this.zoomAnimationTarget = 0.0;
        }
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return;
        }
        int x = 20;
        int y = 60;
        Font font = Minecraft.m_91087_().f_91062_;
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237115_((String)"gui.minopp.play.game_active").m_130946_(" \u00a9 Zbx1425"), x, y, -9400065);
        Objects.requireNonNull(font);
        y += 9;
        if (currentPlayer.equals(cardPlayer)) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237115_((String)("gui.minopp.play." + tableEntity.game.currentPlayerPhase.name().toLowerCase())), x, y, System.currentTimeMillis() % 400L < 200L ? -1 : -256);
        } else {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237110_((String)"gui.minopp.play.turn_other", (Object[])new Object[]{currentPlayer.name}), x, y, -5592406);
        }
        Objects.requireNonNull(font);
        y += 9;
        MutableComponent auxInfo = Component.m_237115_((String)("gui.minopp.play.direction." + (tableEntity.game.isAntiClockwise ? "ccw" : "cw")));
        if (tableEntity.game.drawCount > 0) {
            auxInfo = auxInfo.m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"gui.minopp.play.draw_accumulate", (Object[])new Object[]{tableEntity.game.drawCount}));
        }
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)auxInfo, x, y, -5592406);
        Objects.requireNonNull(font);
        y += 9 * 2;
        MutableComponent topCardInfo = Component.m_237110_((String)"gui.minopp.play.top_card", (Object[])new Object[]{tableEntity.game.topCard.getDisplayName().getString()});
        if (tableEntity.game.topCard.suit == Card.Suit.WILD) {
            topCardInfo.m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"gui.minopp.play.top_card_wild_color", (Object[])new Object[]{Component.m_237115_((String)("game.minopp.card.suit." + tableEntity.game.topCard.getEquivSuit().name().toLowerCase()))}));
        }
        GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)topCardInfo, x, y, -35);
        Objects.requireNonNull(font);
        y += 9 * 2;
        for (String part : tableEntity.state.message().getString().split("\n")) {
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, (Component)Component.m_237113_((String)part), x, y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
        ListIterator<Pair<ActionMessage, Long>> it = tableEntity.clientMessageList.listIterator(tableEntity.clientMessageList.size());
        while (it.hasPrevious()) {
            int n = Minecraft.m_91087_().m_91268_().m_85446_();
            Objects.requireNonNull(font);
            if (y > n - 9 - 40) break;
            Pair<ActionMessage, Long> entry = it.previous();
            long currentTime = System.currentTimeMillis();
            if ((Long)entry.getSecond() - 200L < currentTime) {
                it.remove();
                continue;
            }
            int color = ((ActionMessage)entry.getFirst()).type().isEphemeral() ? 0xFF0000 : 0xAAAAAA;
            int alpha = Mth.m_14045_((int)0, (int)255, (int)((int)(255L * ((Long)entry.getSecond() - currentTime) / 1000L)));
            GameOverlayLayer.drawStringWithBackdrop(guiGraphics, font, ((ActionMessage)entry.getFirst()).message(), x, y, alpha << 24 | color);
            Objects.requireNonNull(font);
            y += 9;
        }
        if (Minecraft.m_91087_().f_91077_.m_6662_() == HitResult.Type.BLOCK && (hitState = Minecraft.m_91087_().f_91073_.m_8055_(hitPos = ((BlockHitResult)Minecraft.m_91087_().f_91077_).m_82425_())).m_60713_(Mino.BLOCK_MINO_TABLE.get())) {
            boolean isPass = BlockMinoTable.Client.isCursorHittingPile();
            if (currentPlayer.equals(cardPlayer)) {
                int n;
                MutableComponent cursorMessage = switch (tableEntity.game.currentPlayerPhase) {
                    default -> throw new IncompatibleClassChangeError();
                    case CardGame.PlayerActionPhase.DISCARD_HAND -> {
                        if (isPass) {
                            yield Component.m_237115_((String)"gui.minopp.play.cursor.pass_draw");
                        }
                        yield Component.m_237115_((String)"gui.minopp.play.cursor.play");
                    }
                    case CardGame.PlayerActionPhase.DISCARD_DRAWN -> isPass ? Component.m_237115_((String)"gui.minopp.play.cursor.pass") : Component.m_237115_((String)"gui.minopp.play.cursor.play");
                };
                MutableComponent shoutMessage = Component.m_237115_((String)"gui.minopp.play.cursor.shout");
                boolean isShouting = !isPass && BlockMinoTable.Client.isShoutModifierHeld();
                int width = Minecraft.m_91087_().m_91268_().m_85445_();
                int height = Minecraft.m_91087_().m_91268_().m_85446_();
                boolean highlight = Minecraft.m_91087_().f_91073_.m_46467_() % 3L < 2L && isPass;
                int msgWidth = Math.max(font.m_92852_((FormattedText)cursorMessage), isShouting ? font.m_92852_((FormattedText)shoutMessage) : 0);
                if (isShouting) {
                    Objects.requireNonNull(font);
                    n = 9 * 2;
                } else {
                    Objects.requireNonNull(font);
                    n = 9;
                }
                int msgHeight = n;
                guiGraphics.m_280509_(width / 2 + 8, height / 2 - msgHeight / 2 - 2, width / 2 + msgWidth + 16, height / 2 + msgHeight / 2 + 3, highlight ? -2136298906 : Integer.MIN_VALUE);
                guiGraphics.m_280430_(font, (Component)cursorMessage, width / 2 + 12, height / 2 - msgHeight / 2, highlight ? -14540254 : -35);
                if (isShouting) {
                    int n2 = width / 2 + 12;
                    int n3 = height / 2 - msgHeight / 2;
                    Objects.requireNonNull(font);
                    guiGraphics.m_280430_(font, (Component)shoutMessage, n2, n3 + 9, highlight ? -14540254 : -35);
                }
            }
        }
        if (TurnDeadMan.isAlarmActive()) {
            MutableComponent deadManMessage = Component.m_237115_((String)"gui.minopp.play.cursor.dead_man");
            int width = Minecraft.m_91087_().m_91268_().m_85445_();
            int height = Minecraft.m_91087_().m_91268_().m_85446_();
            boolean highlight = Minecraft.m_91087_().f_91073_.m_46467_() % 3L < 2L;
            int msgWidth = font.m_92852_((FormattedText)deadManMessage);
            Objects.requireNonNull(font);
            int msgHeight = 9;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(width / 2), (float)(height / 2 + 12), 0.0f);
            guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
            guiGraphics.m_280509_(-msgWidth / 2 - 4, 0, msgWidth / 2 + 4, msgHeight + 4, highlight ? -2136298906 : Integer.MIN_VALUE);
            guiGraphics.m_280430_(font, (Component)deadManMessage, -msgWidth / 2, 2, highlight ? -14540254 : -35);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private static void drawStringWithBackdrop(GuiGraphics guiGraphics, Font font, Component component, int x, int y, int color) {
        int i = 0x66000000;
        int var10001 = x - 2;
        int var10002 = y;
        int var10003 = x + font.m_92852_((FormattedText)component) + 2;
        Objects.requireNonNull(font);
        guiGraphics.m_280509_(var10001, var10002, var10003, y + 9, FastColor.ARGB32.m_13657_((int)i, (int)color));
        guiGraphics.m_280614_(font, component, x, y, color, true);
    }

    private boolean renderHandCards(GuiGraphics guiGraphics, float partialTick) {
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            return false;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        BlockPos gamePos = ItemHandCards.getHandCardGamePos((Player)player);
        if (gamePos == null) {
            return false;
        }
        BlockEntityMinoTable tableEntity = (BlockEntityMinoTable)level.m_7702_(gamePos);
        CardPlayer playerWithoutHand = ItemHandCards.getCardPlayer((Player)player);
        int CARD_V_SPACING = 20;
        int CARD_WIDTH = (int)(100.0 * Mth.m_14139_((double)this.zoomAnimationProgress, (double)0.93, (double)1.0));
        int CARD_HEIGHT = (int)((double)CARD_WIDTH * 8.9 / 5.6);
        if (tableEntity.game == null) {
            return false;
        }
        CardPlayer realPlayer = tableEntity.game.players.stream().filter(p -> p.equals(playerWithoutHand)).findFirst().orElse(null);
        if (realPlayer == null) {
            return false;
        }
        int clientHandIndex = Mth.m_14045_((int)ItemHandCards.getClientHandIndex((Player)player), (int)0, (int)(realPlayer.hand.size() - 1));
        realPlayer.hand.sort(Card::compareTo);
        LongArrayList handCardHashes = new LongArrayList();
        for (Card card : realPlayer.hand) {
            if (!handCardHashes.isEmpty() && (long)card.hashCode() == (handCardHashes.getLong(handCardHashes.size() - 1) & 0xFFFFFFFFL)) {
                handCardHashes.add(handCardHashes.getLong(handCardHashes.size() - 1) + 0x100000000L);
                continue;
            }
            handCardHashes.add((long)card.hashCode());
        }
        this.handCardCurrentXOff.keySet().removeIf(hash -> !handCardHashes.contains(hash));
        RenderSystem.enableBlend();
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int height = Minecraft.m_91087_().m_91268_().m_85446_();
        int handSize = realPlayer.hand.size();
        int selectedCardYRaw = height - (CARD_HEIGHT / 2 + 20 * (handSize - clientHandIndex));
        int cardDrawOffset = selectedCardYRaw < 20 ? 20 - selectedCardYRaw : 0;
        Random cardRandom = new Random(handSize);
        for (int i = 0; i < handSize; ++i) {
            Card card;
            int targetXOff = (i == clientHandIndex ? -30 : 0) + cardRandom.nextInt(-3, 4);
            float currentXOff = this.handCardCurrentXOff.computeIfAbsent(handCardHashes.getLong(i), ignored -> CARD_WIDTH + 10);
            int x = width - 10 - CARD_WIDTH + (int)currentXOff;
            this.handCardCurrentXOff.put(handCardHashes.getLong(i), (float)Mth.m_14139_((double)(0.4 * (double)partialTick), (double)currentXOff, (double)targetXOff));
            int y = height - (CARD_HEIGHT / 2 + 20 * (handSize - i)) + cardDrawOffset;
            if (i == clientHandIndex) {
                card = realPlayer.hand.get(i);
                Component cardName = card.getDisplayName();
                guiGraphics.m_280430_(font, cardName, x - font.m_92852_((FormattedText)cardName) - 10, y + 10, -35);
            }
            guiGraphics.m_280509_(x, y, x + CARD_WIDTH, y + CARD_HEIGHT, -14540254);
            guiGraphics.m_280509_(x + 1, y + 1, x + CARD_WIDTH - 1, y + CARD_HEIGHT - 1, -2236963);
            card = realPlayer.hand.get(i);
            float cardU = switch (card.family) {
                default -> throw new IncompatibleClassChangeError();
                case Card.Family.NUMBER -> Math.abs(card.number) * 16;
                case Card.Family.SKIP -> 160.0f;
                case Card.Family.DRAW -> 176.0f;
                case Card.Family.REVERSE -> 192.0f;
            };
            float cardV = card.suit.ordinal() * 25;
            int cardUW = 16;
            int cardVH = 25;
            float shadowAlpha = (float)Math.max(Mth.m_14139_((double)this.zoomAnimationProgress, (double)0.5, (double)0.0), 0.0);
            guiGraphics.m_280411_(ATLAS_LOCATION, x + 5, y + 5, CARD_WIDTH - 10, CARD_HEIGHT - 10, cardU + 1.0f, cardV + 1.0f, cardUW - 2, cardVH - 2, 256, 128);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(x + 7), (float)(y + 7), 0.0f);
            guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
            if (card.family == Card.Family.REVERSE) {
                guiGraphics.m_280163_(ATLAS_LOCATION, 0, 0, 208.0f, 0.0f, 10, 10, 256, 128);
            } else if (card.family == Card.Family.SKIP) {
                guiGraphics.m_280163_(ATLAS_LOCATION, 0, 0, 218.0f, 0.0f, 10, 10, 256, 128);
            } else if (card.suit == Card.Suit.WILD && card.family == Card.Family.NUMBER) {
                guiGraphics.m_280163_(ATLAS_LOCATION, 0, 0, 228.0f, 0.0f, 10, 10, 256, 128);
            } else {
                MutableComponent cardName = card.getCardFaceName().m_6881_().m_130948_(Style.f_131099_.m_131150_(new ResourceLocation("include/default")));
                int colorA = (int)(34.0f * shadowAlpha + 255.0f * (1.0f - shadowAlpha));
                guiGraphics.m_280430_(font, (Component)cardName, 0, 0, -16777216 + colorA * 65793);
            }
            guiGraphics.m_280168_().m_85849_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280509_(x, y, x + CARD_WIDTH, y + CARD_HEIGHT, 0x222222 | (int)(255.0f * shadowAlpha) << 24);
            guiGraphics.m_280168_().m_85849_();
        }
        RenderSystem.disableBlend();
        return true;
    }

    private void performZoomAnimation(float partialTick, BlockEntityMinoTable tableEntity) {
        this.zoomAnimationProgress = Math.abs(this.zoomAnimationTarget - this.zoomAnimationProgress) < 0.01 ? this.zoomAnimationTarget : (this.zoomAnimationProgress += (this.zoomAnimationTarget - this.zoomAnimationProgress) * 8.0 * 0.05 * (double)partialTick);
        MinoClient.globalFovModifier = Mth.m_14139_((double)Mth.m_14008_((double)this.zoomAnimationProgress, (double)0.0, (double)1.0), (double)1.0, (double)0.97);
    }
}

