/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.game.ActionReport;
import cn.zbx1425.minopp.game.Card;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;

public class AutoPlayer {
    public boolean aiNoWin = false;
    public boolean aiNoPlayerDraw = false;
    public float aiForgetChance = 0.2f;
    public byte aiNoDelay = 0;
    public boolean aiStartGame = false;

    public ActionReport playAtGame(CardGame game, CardPlayer realPlayer, MinecraftServer server) {
        ActionReport result;
        boolean canPlayDrawCard;
        Card topCard = game.topCard;
        boolean forgetsMino = new Random().nextFloat() < this.aiForgetChance;
        boolean shoutsMino = !forgetsMino && realPlayer.hand.size() <= 2;
        CardPlayer nextPlayer = game.players.get((game.currentPlayerIndex + (game.isAntiClockwise ? -1 : 1) + game.players.size()) % game.players.size());
        boolean bl = canPlayDrawCard = !this.aiNoPlayerDraw || server.m_6846_().m_11259_(nextPlayer.uuid) == null;
        if (this.aiNoWin && realPlayer.hand.size() <= 1) {
            return game.playNoCard(realPlayer);
        }
        for (Card card : realPlayer.hand) {
            if (card.number != topCard.number || card.suit == topCard.getEquivSuit() || card.suit == Card.Suit.WILD || !canPlayDrawCard && card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (card.suit != Card.Suit.WILD || card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, this.getMostCommonSuit(realPlayer), shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (card.suit != topCard.getEquivSuit() || card.suit == Card.Suit.WILD || !canPlayDrawCard && card.family == Card.Family.DRAW) continue;
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        for (Card card : realPlayer.hand) {
            if (!canPlayDrawCard && card.family == Card.Family.DRAW || !card.canPlayOn(topCard)) continue;
            if (card.suit == Card.Suit.WILD) {
                result = game.playCard(realPlayer, card, this.getMostCommonSuit(realPlayer), shoutsMino);
                if (result.isFail) continue;
                return result;
            }
            result = game.playCard(realPlayer, card, null, shoutsMino);
            if (result.isFail) continue;
            return result;
        }
        return game.playNoCard(realPlayer);
    }

    private Card.Suit getMostCommonSuit(CardPlayer realPlayer) {
        int[] suitCount = new int[4];
        for (Card handCard : realPlayer.hand) {
            if (handCard.suit == Card.Suit.WILD) continue;
            int n = handCard.suit.ordinal();
            suitCount[n] = suitCount[n] + 1;
        }
        Card.Suit mostCommonSuit = Card.Suit.values()[new Random().nextInt(0, 4)];
        for (int i = 1; i < 4; ++i) {
            if (suitCount[i] <= suitCount[mostCommonSuit.ordinal()]) continue;
            mostCommonSuit = Card.Suit.values()[i];
        }
        return mostCommonSuit;
    }

    public void useConfigNbt(CompoundTag aiConfig) {
        this.aiNoWin = aiConfig.m_128471_("NoWin");
        this.aiNoPlayerDraw = aiConfig.m_128471_("NoPlayerDraw");
        this.aiForgetChance = aiConfig.m_128425_("ForgetChance", 5) ? aiConfig.m_128457_("ForgetChance") : 0.2f;
        this.aiNoDelay = aiConfig.m_128445_("NoDelay");
        this.aiStartGame = aiConfig.m_128471_("StartGame");
    }

    public CompoundTag toConfigNbt() {
        CompoundTag aiConfig = new CompoundTag();
        aiConfig.m_128379_("NoWin", this.aiNoWin);
        aiConfig.m_128379_("NoPlayerDraw", this.aiNoPlayerDraw);
        aiConfig.m_128350_("ForgetChance", this.aiForgetChance);
        aiConfig.m_128344_("NoDelay", this.aiNoDelay);
        aiConfig.m_128379_("StartGame", this.aiStartGame);
        return aiConfig;
    }
}

