/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.minopp.game;

import cn.zbx1425.minopp.effect.EffectEvent;
import cn.zbx1425.minopp.effect.SoundEffectEvent;
import cn.zbx1425.minopp.game.ActionMessage;
import cn.zbx1425.minopp.game.CardGame;
import cn.zbx1425.minopp.game.CardPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class ActionReport {
    private CardGame game;
    private CardPlayer initiator;
    public ActionMessage state;
    public List<ActionMessage> messages = new ArrayList<ActionMessage>();
    public List<EffectEvent> effects = new ArrayList<EffectEvent>();
    public boolean shouldDestroyGame = false;
    public boolean isFail = false;
    private static final int SOUND_RANGE = 16;
    public static final ActionReport NO_GAME = ActionReport.builder().state((Component)Component.m_237115_((String)"game.minopp.play.no_game"));

    private ActionReport(CardGame game, CardPlayer player) {
        this.initiator = player;
        this.game = game;
    }

    public static ActionReport builder(CardGame game, CardPlayer player) {
        return new ActionReport(game, player);
    }

    public static ActionReport builder(CardGame game) {
        return ActionReport.builder(game, null);
    }

    public static ActionReport builder(CardPlayer player) {
        return ActionReport.builder(null, player);
    }

    public static ActionReport builder() {
        return ActionReport.builder(null, null);
    }

    public ActionReport state(Component message) {
        this.state = new ActionMessage(ActionMessage.Type.STATE, message);
        return this;
    }

    public ActionReport fail(Component message) {
        this.isFail = true;
        this.messages.add(new ActionMessage(ActionMessage.Type.FAIL, message));
        return this;
    }

    public ActionReport messageAll(Component message) {
        this.messages.add(new ActionMessage(ActionMessage.Type.MESSAGE_ALL, message));
        return this;
    }

    public ActionReport combineWith(ActionReport other) {
        if (other == null) {
            return this;
        }
        if (this.state == null) {
            this.state = other.state;
        }
        this.messages.addAll(other.messages);
        this.shouldDestroyGame |= other.shouldDestroyGame;
        this.effects.addAll(other.effects);
        return this;
    }

    public ActionReport sound(ResourceLocation sound, int timeOffset, CardPlayer target) {
        this.effects.add(new SoundEffectEvent(timeOffset, Optional.of(target.uuid), SoundEvent.m_262856_((ResourceLocation)sound, (float)16.0f)));
        return this;
    }

    public ActionReport sound(ResourceLocation sound, int timeOffset) {
        this.effects.add(new SoundEffectEvent(timeOffset, Optional.empty(), SoundEvent.m_262856_((ResourceLocation)sound, (float)16.0f)));
        return this;
    }

    public ActionReport effect(EffectEvent event) {
        this.effects.add(event);
        return this;
    }

    public ActionReport played() {
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.played", (Object[])new Object[]{this.initiator.name, this.game.topCard.getDisplayName()}));
    }

    public ActionReport cut() {
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.cut", (Object[])new Object[]{this.initiator.name, this.game.topCard.getDisplayName()}));
    }

    public ActionReport drew(int drawCount) {
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.drew", (Object[])new Object[]{this.initiator.name, drawCount}));
    }

    public ActionReport playedNoCard(boolean drawn) {
        if (drawn) {
            return this.state((Component)Component.m_237110_((String)"game.minopp.play.played_no_drawn_card", (Object[])new Object[]{this.initiator.name}));
        }
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.played_no_card", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameDestroyed() {
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.game_destroyed", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameStarted() {
        return this.state((Component)Component.m_237110_((String)"game.minopp.play.game_started", (Object[])new Object[]{this.initiator.name}));
    }

    public ActionReport gameWon() {
        this.shouldDestroyGame = true;
        MutableComponent result = Component.m_237110_((String)"game.minopp.play.game_won", (Object[])new Object[]{this.initiator.name});
        for (CardPlayer player : this.game.players) {
            if (player.equals(this.initiator)) continue;
            result = result.m_130946_("\n").m_7220_((Component)Component.m_237110_((String)"game.minopp.play.game_nearly_won", (Object[])new Object[]{player.name, player.hand.size()}));
        }
        return this.state((Component)result);
    }

    public ActionReport panic(Component message) {
        this.shouldDestroyGame = true;
        return this.state(message);
    }
}

